<?php
/**
 * Block styles.
 *
 * @package rainbow-kindergarten
 * @since 1.0.0
 */

/**
 * Register block styles
 *
 * @since 1.0.0
 *
 * @return void
 */
function rainbow_kindergarten_register_block_styles() {

	register_block_style( // phpcs:ignore WPThemeReview.PluginTerritory.ForbiddenFunctions.editor_blocks_register_block_style
		'core/button',
		array(
			'name'  => 'rainbow-kindergarten-flat-button',
			'label' => __( 'Flat button', 'rainbow-kindergarten' ),
		)
	);

	register_block_style( // phpcs:ignore WPThemeReview.PluginTerritory.ForbiddenFunctions.editor_blocks_register_block_style
		'core/list',
		array(
			'name'  => 'rainbow-kindergarten-list-underline',
			'label' => __( 'Underlined list items', 'rainbow-kindergarten' ),
		)
	);

	register_block_style( // phpcs:ignore WPThemeReview.PluginTerritory.ForbiddenFunctions.editor_blocks_register_block_style
		'core/group',
		array(
			'name'  => 'rainbow-kindergarten-box-shadow',
			'label' => __( 'Box shadow', 'rainbow-kindergarten' ),
		)
	);

	register_block_style( // phpcs:ignore WPThemeReview.PluginTerritory.ForbiddenFunctions.editor_blocks_register_block_style
		'core/column',
		array(
			'name'  => 'rainbow-kindergarten-box-shadow',
			'label' => __( 'Box shadow', 'rainbow-kindergarten' ),
		)
	);

	register_block_style( // phpcs:ignore WPThemeReview.PluginTerritory.ForbiddenFunctions.editor_blocks_register_block_style
		'core/columns',
		array(
			'name'  => 'rainbow-kindergarten-box-shadow',
			'label' => __( 'Box shadow', 'rainbow-kindergarten' ),
		)
	);

	register_block_style( // phpcs:ignore WPThemeReview.PluginTerritory.ForbiddenFunctions.editor_blocks_register_block_style
		'core/details',
		array(
			'name'  => 'rainbow-kindergarten-plus',
			'label' => __( 'Plus & minus', 'rainbow-kindergarten' ),
		)
	);
}
add_action( 'init', 'rainbow_kindergarten_register_block_styles' );

/**
 * This is an example of how to unregister a core block style.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-styles/
 * @see https://github.com/WordPress/gutenberg/pull/37580
 *
 * @since 1.0.0
 *
 * @return void
 */
function rainbow_kindergarten_unregister_block_style() {
	wp_enqueue_script(
		'rainbow-kindergarten-unregister',
		get_stylesheet_directory_uri() . '/assets/js/unregister.js',
		array( 'wp-blocks', 'wp-dom-ready', 'wp-edit-post' ),
		rainbow_kindergarten_VERSION,
		true
	);
}
add_action( 'enqueue_block_editor_assets', 'rainbow_kindergarten_unregister_block_style' );
