<?php
/**
 * Customizer
 * 
 * @package WordPress
 * @subpackage radiant-adventure-tour
 * @since radiant-adventure-tour 1.0
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function radiant_adventure_tour_customize_register( $wp_customize ) {
	$wp_customize->add_section( new Radiant_Adventure_Tour_Upsell_Section($wp_customize,'upsell_section',array(
		'title'            => __( 'Radiant Adventure Tour Pro', 'radiant-adventure-tour' ),
		'button_text'      => __( 'Upgrade Pro', 'radiant-adventure-tour' ),
		'url'              => 'https://www.wpradiant.net/products/adventure-tour-wordpress-theme',
		'priority'         => 0,
	)));
}
add_action( 'customize_register', 'radiant_adventure_tour_customize_register' );

/**
 * Enqueue script for custom customize control.
 */
function radiant_adventure_tour_custom_control_scripts() {
	wp_enqueue_script( 'radiant-adventure-tour-custom-controls-js', get_template_directory_uri() . '/assets/js/custom-controls.js', array( 'jquery', 'jquery-ui-core', 'jquery-ui-sortable' ), '1.0', true );
	wp_enqueue_style( 'radiant-adventure-tour-customize-controls', trailingslashit( get_template_directory_uri() ) . '/assets/css/customize-controls.css' );
}
add_action( 'customize_controls_enqueue_scripts', 'radiant_adventure_tour_custom_control_scripts' );