<?php
/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 * @package WordPress
 * @subpackage radiant-adventure-tour
 * @since radiant-adventure-tour 1.0
 */

if ( function_exists( 'register_block_style' ) ) {
	/**
	 * Register block styles.
	 *
	 * @since radiant-adventure-tour 1.0
	 *
	 * @return void
	 */
	function radiant_adventure_tour_register_block_styles() {
		

		// Image: Borders.
		register_block_style(
			'core/image',
			array(
				'name'  => 'radiant-adventure-tour-border',
				'label' => esc_html__( 'Borders', 'radiant-adventure-tour' ),
			)
		);

		
	}
	add_action( 'init', 'radiant_adventure_tour_register_block_styles' );
}