jQuery(document).ready(function ($) {
    // Attach click event to the dismiss button
    $(document).on('click', '.notice[data-notice="get-start"] button.notice-dismiss', function () {
        // Dismiss the notice via AJAX
        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: {
                action: 'radiant_adventure_tour_dismissed_notice',
            },
            success: function () {
                // Remove the notice on success
                $('.notice[data-notice="example"]').remove();
            }
        });
    });
});

// Plugin – AI Content Writer plugin activation
document.addEventListener('DOMContentLoaded', function () {
    const radiant_adventure_tour_button = document.getElementById('install-activate-button');

    if (!radiant_adventure_tour_button) return;

    radiant_adventure_tour_button.addEventListener('click', function (e) {
        e.preventDefault();

        const radiant_adventure_tour_redirectUrl = radiant_adventure_tour_button.getAttribute('data-redirect');

        // Step 1: Check if plugin is already active
        const radiant_adventure_tour_checkData = new FormData();
        radiant_adventure_tour_checkData.append('action', 'check_plugin_activation');

        fetch(installPluginData.ajaxurl, {
            method: 'POST',
            body: radiant_adventure_tour_checkData,
        })
        .then(res => res.json())
        .then(res => {
            if (res.success && res.data.active) {
                // Plugin is already active → just redirect
                window.location.href = radiant_adventure_tour_redirectUrl;
            } else {
                // Not active → proceed with install + activate
                radiant_adventure_tour_button.textContent = 'Installing & Activating...';
                const radiant_adventure_tour_installData = new FormData();
                radiant_adventure_tour_installData.append('action', 'install_and_activate_required_plugin');
                radiant_adventure_tour_installData.append('_ajax_nonce', installPluginData.nonce);

                fetch(installPluginData.ajaxurl, {
                    method: 'POST',
                    body: radiant_adventure_tour_installData,
                })
                .then(res => res.json())
                .then(res => {
                    if (res.success) {
                        window.location.href = radiant_adventure_tour_redirectUrl;
                    } else {
                        alert('Activation error: ' + (res.data?.message || 'Unknown error'));
                        radiant_adventure_tour_button.textContent = 'Try Again';
                    }
                })
                .catch(error => {
                    alert('Request failed: ' + error.message);
                    radiant_adventure_tour_button.textContent = 'Try Again';
                });
            }
        })
        .catch(error => {
            alert('Check request failed: ' + error.message);
        });
    });
});
