<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

class Purea_Magazine_Rating_Notice {
    private $past_date;

    public function __construct() {
        $this->past_date = false == get_option('purea_magazine_maybe_later_time') ? strtotime( '-5 days' ) : strtotime('-15 days');

        if ( current_user_can('administrator') ) {
            if ( empty(get_option('purea_magazine_rating_dismiss_notice')) && empty(get_option('purea_magazine_rating_already_rated')) ) {
                add_action( 'admin_init', [$this, 'purea_magazine_check_theme_install_time'] );
            }
        }

        if ( is_admin() ) {
            add_action( 'admin_head', [$this, 'purea_magazine_enqueue_scripts' ] );
        }

        add_action( 'wp_ajax_purea_magazine_rating_dismiss_notice', [$this, 'purea_magazine_rating_dismiss_notice'] );
        add_action( 'wp_ajax_purea_magazine_rating_already_rated', [$this, 'purea_magazine_rating_already_rated'] );
        add_action( 'wp_ajax_purea_magazine_rating_maybe_later', [$this, 'purea_magazine_rating_maybe_later'] );
    }

    public function purea_magazine_check_theme_install_time() {   
        $install_date = get_option('purea_magazine_activation_time');

        if ( false !== $install_date && $this->past_date >= $install_date ) {
            add_action( 'admin_notices', [$this, 'purea_magazine_render_rating_notice' ]);
        }
    }

    public function purea_magazine_rating_maybe_later() {
        update_option('purea_magazine_maybe_later_time', true);
        update_option('purea_magazine_activation_time', strtotime('now'));
    }
    
    public function purea_magazine_rating_dismiss_notice() {
        update_option( 'purea_magazine_rating_dismiss_notice', true );
    }

    function purea_magazine_rating_already_rated() {    
        update_option( 'purea_magazine_rating_already_rated' , true );
    }

    public function purea_magazine_render_rating_notice() {
        if ( is_admin() ) {

            echo '<div class="notice purea-magazine-rating-notice is-dismissible" style="border-left-color: #0073aa!important; display: flex; align-items: center;">
                        <div class="purea-magazine-rating-notice-logo">
                        <img class="purea-magazine-logo" src="'.get_theme_file_uri().'/inc/activation/img/logo-spiracle.png">
                        </div>
                        <div>
                            <h3>Thank you for using Purea Magazine WordPress Theme to build this website!</h3>
                            <p>Could you please do us a BIG favor and give it a 5-star rating on WordPress? Just to help us spread the word and boost our motivation.</p>
                            <p>
                                <a href="https://wordpress.org/support/theme/purea-magazine/reviews/?filter=5" target="_blank" class="purea-magazine-you-deserve-it button button-primary">OK, you deserve it!</a>
                                <a class="purea-magazine-maybe-later"><span class="dashicons dashicons-clock"></span> Maybe Later</a>
                                <a class="purea-magazine-already-rated"><span class="dashicons dashicons-yes"></span> I Already did</a>
                            </p>
                        </div>
                </div>';
        }
    }

    public function purea_magazine_enqueue_scripts() { 
        echo "
        <script>
        jQuery( document ).ready( function() {

            jQuery(document).on( 'click', '.purea-magazine-rating-notice .notice-dismiss', function(e) {
                e.preventDefault();
                jQuery(document).find('.purea-magazine-rating-notice').slideUp();
                jQuery.post({
                    url: ajaxurl,
                    data: {
                        action: 'purea_magazine_rating_dismiss_notice',
                    }
                })
            });

            jQuery(document).on( 'click', '.purea-magazine-maybe-later', function() {
                jQuery(document).find('.purea-magazine-rating-notice').slideUp();
                jQuery.post({
                    url: ajaxurl,
                    data: {
                        action: 'purea_magazine_rating_maybe_later',
                    }
                })
            });
        
            jQuery(document).on( 'click', '.purea-magazine-already-rated', function() {
                jQuery(document).find('.purea-magazine-rating-notice').slideUp();
                jQuery.post({
                    url: ajaxurl,
                    data: {
                        action: 'purea_magazine_rating_already_rated',
                    }
                })
            });
        });
        </script>

        <style>
            .purea-magazine-rating-notice {
              padding: 0 15px;
            }

            .purea-magazine-rating-notice-logo {
                margin-right: 20px;
                width: 100px;
                height: 100px;
            }

            .purea-magazine-rating-notice-logo img {
                max-width: 100%;
            }

            .purea-magazine-rating-notice h3 {
              margin-bottom: 0;
            }

            .purea-magazine-rating-notice p {
              margin-top: 3px;
              margin-bottom: 15px;
            }

            .purea-magazine-already-rated,
            .purea-magazine-maybe-later {
              text-decoration: none;
              margin-left: 12px;
              font-size: 14px;
              cursor: pointer;
            }

            .purea-magazine-already-rated .dashicons,
            .purea-magazine-maybe-later .dashicons {
              vertical-align: sub;
            }

            .purea-magazine-logo {
                height: 100%;
                width: auto;
            }

        </style>
        ";
    }
}

new Purea_Magazine_Rating_Notice();