<?php
/**
 * Title: Resume list
 * Slug: pulitzer/general-resume-list
 * Categories: pulitzer
 * Viewport width: 800
 */
?>

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|60","margin":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--80);margin-bottom:var(--wp--preset--spacing--80)">
	<!-- wp:group {"layout":{"type":"constrained"}} -->
	<div class="wp-block-group">
		<!-- wp:heading {"fontSize":"small"} -->
		<h2 class="wp-block-heading has-small-font-size"><?php echo esc_html_x( 'Work Experience', 'Resume pattern placeholder content', 'pulitzer' ); ?></h2>
		<!-- /wp:heading -->

		<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|50"}}}} -->
		<div class="wp-block-columns">
			<!-- wp:column {"width":"30%","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2","fontSize":"small","fontFamily":"system-sans-serif"} -->
			<div class="wp-block-column has-contrast-2-color has-text-color has-link-color has-system-sans-serif-font-family has-small-font-size"
				style="font-style:normal;font-weight:500;flex-basis:30%"><!-- wp:paragraph -->
				<p><?php echo esc_html_x( '1885 – 1886', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|40"}}} -->
			<div class="wp-block-column">
				<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10"}},"layout":{"type":"flex","orientation":"vertical"},"fontSize":"small","fontFamily":"system-sans-serif"} -->
				<div class="wp-block-group has-system-sans-serif-font-family has-small-font-size">
					<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}}} -->
					<p style="font-style:normal;font-weight:500"><?php echo esc_html_x( 'U.S. House of Representatives', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2"} -->
					<p class="has-contrast-2-color has-text-color has-link-color"><?php echo esc_html_x( 'New York’s 9th district', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->

				<!-- wp:paragraph -->
				<p><?php echo esc_html_x( 'I led the crusade to place the newly gifted Statue of Liberty in New York City, and served as a member of the Committee on Commerce.', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->

		<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|50"}}}} -->
		<div class="wp-block-columns">
			<!-- wp:column {"width":"30%","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2","fontSize":"small","fontFamily":"system-sans-serif"} -->
			<div class="wp-block-column has-contrast-2-color has-text-color has-link-color has-system-sans-serif-font-family has-small-font-size"
				style="font-style:normal;font-weight:500;flex-basis:30%"><!-- wp:paragraph -->
				<p><?php echo esc_html_x( '1883 – 1911', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|40"}}} -->
			<div class="wp-block-column">
				<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10"}},"layout":{"type":"flex","orientation":"vertical"},"fontSize":"small","fontFamily":"system-sans-serif"} -->
				<div class="wp-block-group has-system-sans-serif-font-family has-small-font-size">
					<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}}} -->
					<p style="font-style:normal;font-weight:500"><?php echo esc_html_x( 'New York World', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2"} -->
					<p class="has-contrast-2-color has-text-color has-link-color"><?php echo esc_html_x( 'Publisher and owner', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->

				<!-- wp:paragraph -->
				<p><?php echo esc_html_x( 'I doubled the circulation of the New York World within three months of acquiring the paper.', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->

		<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|50"}}}} -->
		<div class="wp-block-columns">
			<!-- wp:column {"width":"30%","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2","fontSize":"small","fontFamily":"system-sans-serif"} -->
			<div class="wp-block-column has-contrast-2-color has-text-color has-link-color has-system-sans-serif-font-family has-small-font-size"
				style="font-style:normal;font-weight:500;flex-basis:30%"><!-- wp:paragraph -->
				<p><?php echo esc_html_x( '1878 – 1911', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|40"}}} -->
			<div class="wp-block-column">
				<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10"}},"layout":{"type":"flex","orientation":"vertical"},"fontSize":"small","fontFamily":"system-sans-serif"} -->
				<div class="wp-block-group has-system-sans-serif-font-family has-small-font-size">
					<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}}} -->
					<p style="font-style:normal;font-weight:500"><?php echo esc_html_x( 'St. Louis Post-Dispatch', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2"} -->
					<p class="has-contrast-2-color has-text-color has-link-color"><?php echo esc_html_x( 'Publisher and owner', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->

				<!-- wp:paragraph -->
				<p><?php echo esc_html_x( 'During my short time in Jefferson City, I voted for the adoption of the Fifteenth Amendment and led a crusade to reform the corrupt count court.', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"layout":{"type":"constrained"}} -->
	<div class="wp-block-group">
		<!-- wp:heading {"fontSize":"small"} -->
		<h2 class="wp-block-heading has-small-font-size"><?php echo esc_html_x( 'Work Experience', 'Resume pattern placeholder content', 'pulitzer' ); ?></h2>
		<!-- /wp:heading -->

		<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|50"}}}} -->
		<div class="wp-block-columns">
			<!-- wp:column {"width":"30%","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2","fontSize":"small","fontFamily":"system-sans-serif"} -->
			<div class="wp-block-column has-contrast-2-color has-text-color has-link-color has-system-sans-serif-font-family has-small-font-size"
				style="font-style:normal;font-weight:500;flex-basis:30%"><!-- wp:paragraph -->
				<p><?php echo esc_html_x( '1885 – 1886', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|40"}}} -->
			<div class="wp-block-column">
				<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10"}},"layout":{"type":"flex","orientation":"vertical"},"fontSize":"small","fontFamily":"system-sans-serif"} -->
				<div class="wp-block-group has-system-sans-serif-font-family has-small-font-size">
					<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}}} -->
					<p style="font-style:normal;font-weight:500"><?php echo esc_html_x( 'U.S. House of Representatives', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2"} -->
					<p class="has-contrast-2-color has-text-color has-link-color"><?php echo esc_html_x( 'New York’s 9th district', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->

				<!-- wp:paragraph -->
				<p><?php echo esc_html_x( 'I led the crusade to place the newly gifted Statue of Liberty in New York City, and served as a member of the Committee on Commerce.', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->

		<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|50"}}}} -->
		<div class="wp-block-columns">
			<!-- wp:column {"width":"30%","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2","fontSize":"small","fontFamily":"system-sans-serif"} -->
			<div class="wp-block-column has-contrast-2-color has-text-color has-link-color has-system-sans-serif-font-family has-small-font-size"
				style="font-style:normal;font-weight:500;flex-basis:30%"><!-- wp:paragraph -->
				<p><?php echo esc_html_x( '1883 – 1911', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|40"}}} -->
			<div class="wp-block-column">
				<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10"}},"layout":{"type":"flex","orientation":"vertical"},"fontSize":"small","fontFamily":"system-sans-serif"} -->
				<div class="wp-block-group has-system-sans-serif-font-family has-small-font-size">
					<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}}} -->
					<p style="font-style:normal;font-weight:500"><?php echo esc_html_x( 'New York World', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2"} -->
					<p class="has-contrast-2-color has-text-color has-link-color"><?php echo esc_html_x( 'Publisher and owner', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->

				<!-- wp:paragraph -->
				<p><?php echo esc_html_x( 'I doubled the circulation of the New York World within three months of acquiring the paper.', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->

		<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|50"}}}} -->
		<div class="wp-block-columns">
			<!-- wp:column {"width":"30%","style":{"typography":{"fontStyle":"normal","fontWeight":"500"},"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2","fontSize":"small","fontFamily":"system-sans-serif"} -->
			<div class="wp-block-column has-contrast-2-color has-text-color has-link-color has-system-sans-serif-font-family has-small-font-size"
				style="font-style:normal;font-weight:500;flex-basis:30%"><!-- wp:paragraph -->
				<p><?php echo esc_html_x( '1878 – 1911', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|40"}}} -->
			<div class="wp-block-column">
				<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|10"}},"layout":{"type":"flex","orientation":"vertical"},"fontSize":"small","fontFamily":"system-sans-serif"} -->
				<div class="wp-block-group has-system-sans-serif-font-family has-small-font-size">
					<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}}} -->
					<p style="font-style:normal;font-weight:500"><?php echo esc_html_x( 'St. Louis Post-Dispatch', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2"} -->
					<p class="has-contrast-2-color has-text-color has-link-color"><?php echo esc_html_x( 'Publisher and owner', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->

				<!-- wp:paragraph -->
				<p><?php echo esc_html_x( 'During my short time in Jefferson City, I voted for the adoption of the Fifteenth Amendment and led a crusade to reform the corrupt count court.', 'Resume pattern placeholder content', 'pulitzer' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->