<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package publisherly
 */

?>

<article id="post-<?php the_ID(); ?>" class="article-posts" <?php post_class(); ?>>

	<?php
	// show featured image
		if ( has_post_thumbnail() ) { ?>

			<div class="entry-featured">
				<a href="<?php the_permalink(); ?>">
					<?php the_post_thumbnail( 'publisherly-thumbnail-medium' ); ?>
				</a>
			</div>
			
		<?php }
	?>

	<div class="entry">

		<header class="entry-header">

			<?php
			the_title( '<h2><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			?>

		</header>

		<div class="entry-meta">

			<?php publisherly_entry_meta();	?>

		</div>

		<div class="entry-content">

			<?php
			the_excerpt( '' ,true, '' );
			?>

			<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'publisherly' ),
				'after'  => '</div>',
			) );
			?>

		</div><!-- /entry-content -->

	</div><!-- /entry -->

</article><!-- /article -->
