<?php
/**
 * Custom template tags for this theme
 *
 * @package publisherly
 */

if ( ! function_exists( 'publisherly_site_branding' ) ) :
	/**
	 * Show Site Branding
	 *
	 */
	function publisherly_site_branding() {

		// Display the Custom Logo
		if ( has_custom_logo() ) {

			the_custom_logo();

		} else {

			if ( is_front_page() && is_home() ) : ?>

			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>

		<?php else : ?>

			<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>

		<?php endif;

		}

	}
	endif;

if ( ! function_exists( 'publisherly_entry_meta' ) ) :
	/**
	 * Show HTML with meta information for the date, author and categories.
	 *
	 */
	function publisherly_entry_meta() {

		// show meta date
		echo get_the_date();
		echo ' | ';
		
		// show meta author
		the_author_meta( 'display_name' );
		echo ' | ';
		
		// show meta categories
		the_category( ', ' );

}
endif;
