<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package publisherly
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head itemscope itemtype="https://schema.org/WebSite">

  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="profile" href="https://gmpg.org/xfn/11">
  <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'publisherly' ); ?></a>

<header id="masthead" class="site-header">

	<div class="wrapper">

			<div class="site-branding">

				<?php publisherly_site_branding(); ?>

			</div><!-- .site-branding -->

			<?php if ( has_nav_menu( 'primary' ) ) : ?>

				<a id="menu-toggle" class="menu-toggle" href="#"><i class="fa fa-bars"></i> <?php esc_html_e( 'Menu', 'publisherly' ); ?></a>

				<div id="site-header-menu" class="site-header-menu">

					<nav id="site-navigation" class="main-navigation" role="navigation" aria-label="<?php esc_attr( 'Primary Menu', 'publisherly' ); ?>">

						<?php
							wp_nav_menu( array(
								'theme_location' => 'primary',
								'menu_class'     => 'primary-menu',
							) );
						?>

					</nav><!-- .main-navigation -->

				</div><!-- .site-header-menu -->

			<?php endif; ?>

		</div><!-- /header-wrapper -->

	</header><!-- .site-header -->

