<?php
/**
 * publisherly functions and definitions
 *
 * @package publisherly
 */

if ( ! function_exists( 'publisherly_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function publisherly_setup() {

		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 */
		load_theme_textdomain( 'publisherly', get_template_directory() . '/languages' );

		/*
		 * Add default posts and comments RSS feed links to head.
		 */
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * This theme uses wp_nav_menu()
		 */
		register_nav_menus( array(
			'primary' 	=> esc_html__( 'Primary Menu', 'publisherly' ),
		) );

		/**
		 * Add support for core custom logo.
		 */
		add_theme_support( 'custom-logo', apply_filters( 'publisherly_custom_logo_args', array(
			'width'       => 300,
			'height'      => 90,
			'flex-height' => true,
			'flex-width'  => true,
		) ) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

	}
endif;
add_action( 'after_setup_theme', 'publisherly_setup' );

/**
 * Fire the wp_body_open action.
 *
 * Added for backwards compatibility to support WordPress versions prior to 5.2.0.
  */
if ( ! function_exists( 'wp_body_open' ) ) {
    function wp_body_open() {
        /**
         * Triggered after the opening <body> tag.
         */
        do_action( 'wp_body_open' );
    }
}

/*
 * Enable support for Post Thumbnails on posts and pages.
 *
 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
 */
function publisherly_add_image_sizes() {

	add_theme_support( 'post-thumbnails' );

	// Set default Post Thumbnail size.
	set_post_thumbnail_size( 1300, 766, array( 'center', 'center' ) );

	// Add different thumbnail sizes
	add_image_size( 'publisherly-thumbnail-medium', 360, 212, array( 'center', 'center' ) );
	add_image_size( 'publisherly-thumbnail-large', 850, 501, array( 'center', 'center' ) );

}
add_action( 'after_setup_theme', 'publisherly_add_image_sizes' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function publisherly_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'publisherly_content_width', 800 );
}
add_action( 'after_setup_theme', 'publisherly_content_width', 0 );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function publisherly_widgets_init() {

	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'publisherly' ),
			'id'            => 'sidebar',
			'description'   => esc_html__( 'Widgets in this area will be shown in the sidebar.', 'publisherly' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h4>',
			'after_title'   => '</h4>',
		)
	);

	register_sidebar(
		array(
			'name' 			=> esc_html__( 'Footer Widget Area 1', 'publisherly' ),
			'id' 			=> 'footer-1',
			'description' 	=> esc_html__( 'Appears on all pages at the bottom of site.', 'publisherly' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h4>',
			'after_title'   => '</h4>',
		)
	);

	register_sidebar(
		array(
			'name' 			=> esc_html__( 'Footer Widget Area 2', 'publisherly' ),
			'id' 			=> 'footer-2',
			'description' 	=> esc_html__( 'Appears on all pages at the bottom of site.', 'publisherly' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h4>',
			'after_title'   => '</h4>',
		)
	);

	register_sidebar(
		array(
			'name' 			=> esc_html__( 'Footer Widget Area 3', 'publisherly' ),
			'id' 			=> 'footer-3',
			'description' 	=> esc_html__( 'Appears on all pages at the bottom of site.', 'publisherly' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h4>',
			'after_title'   => '</h4>',
		)
	);

	register_sidebar(
		array(
			'name' 			=> esc_html__( 'Footer Widget Area 4', 'publisherly' ),
			'id' 			=> 'footer-4',
			'description' 	=> esc_html__( 'Appears on all pages at the bottom of site.', 'publisherly' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h4>',
			'after_title'   => '</h4>',
		)
	);

}
add_action( 'widgets_init', 'publisherly_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function publisherly_scripts() {

	// Load Main Stylesheet
	wp_enqueue_style( 'publisherlypro-stylesheet', get_stylesheet_directory_uri().'/assets/css/style.css', array() );

	// JS file for main navigation
	wp_enqueue_script( 'publisherly-script', get_template_directory_uri() . '/assets/js/navigation.js', array( 'jquery' ), null, true );

	wp_localize_script( 'publisherly-script', 'publisherlyScreenReaderText', array(
		'expand'   => __( 'expand child menu', 'publisherly' ),
		'collapse' => __( 'collapse child menu', 'publisherly' ),
	) );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'publisherly_scripts' );


/**
 * Customizer additions.
 */
require_once( 'inc/customizer.php' );

/**
 * Custom template tags for this theme.
 */
require_once( 'inc/template-tags.php' );

/**
 * Load admin theme page.
 */
require_once( 'inc/theme-info.php' );
