<?php
/**
 * Related posts based on categories and tags.
 * 
 */

$property_broker_related_posts_taxonomy = property_broker_get_option( 'property_broker_related_posts_taxonomy', 'category' );
$property_broker_archive_layout = property_broker_get_option( 'property_broker_archive_layout' );

$property_broker_post_args = array(
    'posts_per_page'    => 3,
    'orderby'           => 'rand',
    'post__not_in'      => array( get_the_ID() ),
);

$property_broker_tax_terms = wp_get_post_terms( get_the_ID(), 'category' );
$property_broker_terms_ids = array();
foreach( $property_broker_tax_terms as $tax_term ) {
	$property_broker_terms_ids[] = $tax_term->term_id;
}

$property_broker_post_args['category__in'] = $property_broker_terms_ids;

$property_broker_related_posts = new WP_Query( $property_broker_post_args );

if ( $property_broker_related_posts->have_posts() ) : ?>
    <div class="related-post">
        <h3><?php echo esc_html__('Related Post' ,'property-broker' );?></h3>
        <div class="row">
            <?php while ( $property_broker_related_posts->have_posts() ) : $property_broker_related_posts->the_post(); ?>
                <div class="col-xl-4 col-lg-6 col-md-6 col-12">
                  <article id="post-<?php the_ID(); ?>" <?php post_class("zoomInRight wow"); ?>>
                  <?php $property_broker_enable_related_post_image = property_broker_get_option('property_broker_enable_related_post_image');
                    if ($property_broker_enable_related_post_image) { ?>
                      <div class="blog-img mb-2">
                        <?php if ( has_post_thumbnail() ) : ?>
                            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
                        <?php endif; ?>
                      </div>
                    <?php } ?>
                    <div class="entry-content-wrapper">
                      <?php property_broker_entry_meta_date(); ?>
                        <header class="entry-header">
                          <?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
                        </header>
                    </div>
                    <div class="text-content">
                      <?php if ( 'full' === $property_broker_archive_layout ) : ?>
                        <?php
                        the_content( sprintf(
                          wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'property-broker' ), array( 'span' => array( 'class' => array() ) ) ),
                          the_title( '<span class="screen-reader-text">"', '"</span>', false )
                        ) );
                        ?>
                        <?php else : ?>
                        <?php the_excerpt(); ?>
                        <?php endif; ?>
                    </div>
                  </article>
              </div>
            <?php endwhile; ?>
        </div>
    </div>
<?php endif;
wp_reset_postdata();