// Menu
function property_broker_openNav() {
  jQuery(".sidenav").addClass('show');
}
function property_broker_closeNav() {
  jQuery(".sidenav").removeClass('show');
}

( function( window, document ) {
  function property_broker_keepFocusInMenu() {
    document.addEventListener( 'keydown', function( e ) {
      const property_broker_nav = document.querySelector( '.sidenav' );

      if ( ! property_broker_nav || ! property_broker_nav.classList.contains( 'show' ) ) {
        return;
      }
      const elements = [...property_broker_nav.querySelectorAll( 'input, a, button' )],
        property_broker_lastEl = elements[ elements.length - 1 ],
        property_broker_firstEl = elements[0],
        property_broker_activeEl = document.activeElement,
        tabKey = e.keyCode === 9,
        shiftKey = e.shiftKey;

      if ( ! shiftKey && tabKey && property_broker_lastEl === property_broker_activeEl ) {
        e.preventDefault();
        property_broker_firstEl.focus();
      }

      if ( shiftKey && tabKey && property_broker_firstEl === property_broker_activeEl ) {
        e.preventDefault();
        property_broker_lastEl.focus();
      }
    } );
  }
  property_broker_keepFocusInMenu();
} )( window, document );


document.addEventListener('DOMContentLoaded', function () {
  var property_broker_preloader = document.getElementById('preloader');

  if (property_broker_preloader) {  // Check if the element exists before trying to manipulate it
      var duration = 4000; // 10 seconds

      setTimeout(function () {
        property_broker_preloader.style.display = 'none';
      }, duration);
  }
});

/* Custom Cursor
 **-----------------------------------------------------*/
const property_broker_customCursor = {
  init: function () {
    this.property_broker_customCursor();
  },
  isVariableDefined: function (el) {
    return typeof el !== "undefined" && el !== null;
  },
  select: function (selectors) {
    return document.querySelector(selectors);
  },
  selectAll: function (selectors) {
    return document.querySelectorAll(selectors);
  },
  property_broker_customCursor: function () {
    const property_broker_cursorDot = this.select(".cursor-point");
    const property_broker_cursorOutline = this.select(".cursor-point-outline");
    if (this.isVariableDefined(property_broker_cursorDot) && this.isVariableDefined(property_broker_cursorOutline)) {
      const cursor = {
        delay: 8,
        _x: 0,
        _y: 0,
        endX: window.innerWidth / 2,
        endY: window.innerHeight / 2,
        cursorVisible: true,
        cursorEnlarged: false,
        $dot: property_broker_cursorDot,
        $outline: property_broker_cursorOutline,

        init: function () {
          this.dotSize = this.$dot.offsetWidth;
          this.outlineSize = this.$outline.offsetWidth;
          this.setupEventListeners();
          this.animateDotOutline();
        },

        updateCursor: function (e) {
          this.cursorVisible = true;
          this.toggleCursorVisibility();
          this.endX = e.clientX;
          this.endY = e.clientY;
          this.$dot.style.top = `${this.endY}px`;
          this.$dot.style.left = `${this.endX}px`;
        },

        setupEventListeners: function () {
          window.addEventListener("load", () => {
            this.cursorEnlarged = false;
            this.toggleCursorSize();
          });

          property_broker_customCursor.selectAll("a, button").forEach((el) => {
            el.addEventListener("mouseover", () => {
              this.cursorEnlarged = true;
              this.toggleCursorSize();
            });
            el.addEventListener("mouseout", () => {
              this.cursorEnlarged = false;
              this.toggleCursorSize();
            });
          });

          document.addEventListener("mousedown", () => {
            this.cursorEnlarged = true;
            this.toggleCursorSize();
          });
          document.addEventListener("mouseup", () => {
            this.cursorEnlarged = false;
            this.toggleCursorSize();
          });

          document.addEventListener("mousemove", (e) => {
            this.updateCursor(e);
          });

          document.addEventListener("mouseenter", () => {
            this.cursorVisible = true;
            this.toggleCursorVisibility();
            this.$dot.style.opacity = 1;
            this.$outline.style.opacity = 1;
          });

          document.addEventListener("mouseleave", () => {
            this.cursorVisible = false;
            this.toggleCursorVisibility();
            this.$dot.style.opacity = 0;
            this.$outline.style.opacity = 0;
          });
        },

        animateDotOutline: function () {
          this._x += (this.endX - this._x) / this.delay;
          this._y += (this.endY - this._y) / this.delay;
          this.$outline.style.top = `${this._y}px`;
          this.$outline.style.left = `${this._x}px`;

          requestAnimationFrame(this.animateDotOutline.bind(this));
        },

        toggleCursorSize: function () {
          if (this.cursorEnlarged) {
            this.$dot.style.transform = "translate(-50%, -50%) scale(0.75)";
            this.$outline.style.transform = "translate(-50%, -50%) scale(1.6)";
          } else {
            this.$dot.style.transform = "translate(-50%, -50%) scale(1)";
            this.$outline.style.transform = "translate(-50%, -50%) scale(1)";
          }
        },

        toggleCursorVisibility: function () {
          if (this.cursorVisible) {
            this.$dot.style.opacity = 1;
            this.$outline.style.opacity = 1;
          } else {
            this.$dot.style.opacity = 0;
            this.$outline.style.opacity = 0;
          }
        },
      };
      cursor.init();
    }
  },
};
property_broker_customCursor.init();

//scrollToTop

const property_broker_scrollToTop = {
  scrollToTop: {
    init() {
      this.button = document.getElementById("scrollToTopBtn");
      const svg = document.getElementById("progressCircle");
      this.circle = svg?.querySelector("circle");

      if (!this.button || !this.circle) return;

      this.radius = this.circle.r.baseVal.value;
      this.circumference = 2 * Math.PI * this.radius;

      this.circle.style.strokeDasharray = `${this.circumference}`;
      this.circle.style.strokeDashoffset = this.circumference;

      window.addEventListener("scroll", this.handleScroll.bind(this));
      this.button.addEventListener("click", this.scrollToTop.bind(this));
    },

    handleScroll() {
      const scrollTop = document.documentElement.scrollTop || document.body.scrollTop;

      this.button.style.display = scrollTop > 100 ? "flex" : "none";
      requestAnimationFrame(this.updateProgress.bind(this));
    },

    scrollToTop() {
      window.scrollTo({ top: 0, behavior: "smooth" });
    },

    updateProgress() {
      if (!this.circle) return;

      const scrollTop = document.documentElement.scrollTop || document.body.scrollTop;
      const scrollHeight = document.documentElement.scrollHeight - document.documentElement.clientHeight;
      const progress = scrollTop / scrollHeight;

      const offset = this.circumference * (1 - progress);
      this.circle.style.strokeDashoffset = offset;
    }
  }
};
document.addEventListener("DOMContentLoaded", () => property_broker_scrollToTop .scrollToTop.init());

/* ===============================================
   sticky copyright
============================================= */

window.addEventListener('scroll', function() {
  var property_broker_footer = document.querySelector('.sticky-copyright');
  if (!property_broker_footer) return; 

  var property_broker_scrollTop = window.scrollY || document.documentElement.property_broker_scrollTop;

  if (property_broker_scrollTop >= 100) {
    property_broker_footer.classList.add('active-sticky');
  }
}); 