<?php
/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Property_Broker_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	*/
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . 'inc/upsell/upgrade-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Property_Broker_Customize_Section_Pro' );

		$manager->add_section(
			new Property_Broker_Customize_Section_Pro(
				$manager,
				'property_broker_upgrade_pro',
				array(
					'title'       => esc_html__( 'Property Broker Pro', 'property-broker' ),
					'pro_text'    => esc_html__( 'Get Pro Theme', 'property-broker' ),
					'pro_url'     => 'https://www.mizanthemes.com/products/real-estate-broker-wordpress-theme',
					'priority'    => 5,
				)
			)
		);

		$manager->add_section(
			new Property_Broker_Customize_Section_Pro(
				$manager,
				'property_broker_documentation',
				array(
					'pro_text'    => esc_html__( 'Documentation', 'property-broker' ),
					'pro_url'     => 'https://preview.mizanthemes.com/setup-guide/property-broker-free/',
					'priority'    => 200,
				)
			)
		);

	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'property-broker-customize-controls', trailingslashit( get_template_directory_uri() ) . '/inc/upsell/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'property-broker-customize-controls', trailingslashit( get_template_directory_uri() ) . '/inc/upsell/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Property_Broker_Customize::get_instance();