<?php
/**
 * Custom theme functions.
 *
 * This file contains hook functions attached to theme hooks.
 *
 * @package property_broker
 */

if ( ! function_exists( 'property_broker_skip_to_content' ) ) :
	/**
	 * Add Skip to content.
	 *
	 * @since 1.0.0
	 */
	function property_broker_skip_to_content() {
	?><a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'property-broker' ); ?></a><?php
	}
endif;

add_action( 'property_broker_action_before', 'property_broker_skip_to_content', 15 );

// Middle Header

if ( ! function_exists( 'property_broker_site_branding' ) ) :

	/**
	 * Site branding.
	 *
	 * @since 1.0.0
	 */
	function property_broker_site_branding() {

		$property_broker_header_top_text = property_broker_get_option( 'property_broker_header_top_text' );
		$property_broker_show_top_header = property_broker_get_option( 'property_broker_show_top_header' );
		$property_broker_header_top_buttonlink = property_broker_get_option( 'property_broker_header_top_buttonlink' );
		$property_broker_header_top_location = property_broker_get_option( 'property_broker_header_top_location');
		$property_broker_header_top_location_link = property_broker_get_option( 'property_broker_header_top_location_link' );
		$property_broker_header_top_email = property_broker_get_option( 'property_broker_header_top_email' );
		$property_broker_header_top_phone_number = property_broker_get_option( 'property_broker_header_top_phone_number' );

		$property_broker_header_top_button_text = property_broker_get_option( 'property_broker_header_top_button_text' );
		$property_broker_header_top_button_link = property_broker_get_option( 'property_broker_header_top_button_link' );
		
		?>
		<div class="top-header">
			<div class="container">
				<?php if ( true === $property_broker_show_top_header ) : ?>
					<div class="row header-top">
						<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 align-self-center d-flex justify-content-between header-top-inner">
							<?php if( !empty($property_broker_header_top_text) ):?>
								<p class="mb-0 topheader-phone"><i class="fa-solid fa-bullhorn me-2"></i></span><?php echo esc_html($property_broker_header_top_text);?></p>
							<?php endif; ?>
							<?php if( !empty($property_broker_header_top_location) ):?>
								<p class="mb-0 topheader-location"><a href="<?php echo esc_url($property_broker_header_top_location_link);?>"><span class="dashicons dashicons-location me-2"></span><?php echo esc_html($property_broker_header_top_location);?></a></p>
							<?php endif; ?>
							<?php if( !empty($property_broker_header_top_email) ):?>
								<p class="mb-0 topheader-mail"><a href="mailto:<?php echo esc_attr($property_broker_header_top_email);?>"><span class="dashicons dashicons-email me-2"></span><?php echo esc_html($property_broker_header_top_email);?></a></p>
							<?php endif; ?>
						</div>
					</div>
				<?php endif; ?>
			</div>
		</div>
		<div id="middle-header" class="py-2">
			<div class="container">
				<div class="row inner-middle">
					<div class="col-xl-2 col-lg-3 col-md-4 col-sm-4 col-12 align-self-center position-relative">
						<div class="site-branding text-sm-start">
							<?php property_broker_the_custom_logo(); ?>
							<?php $property_broker_show_title = property_broker_get_option( 'property_broker_show_title' ); ?>
							<?php $property_broker_show_tagline = property_broker_get_option( 'property_broker_show_tagline' ); ?>
							<?php if ( true === $property_broker_show_title || true === $property_broker_show_tagline ) :  ?>
								<div id="site-identity" class="text-sm-start">
									<?php if ( true === $property_broker_show_title ) :  ?>
										<?php if ( is_front_page() ) : ?>
											<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
									<?php endif; ?>
									<?php if ( true === $property_broker_show_tagline ) :  ?>
										<p class="site-description"><?php bloginfo( 'description' ); ?></p>
									<?php endif; ?>
								</div>
							<?php endif; ?>
						</div>
					</div>
					<div class="col-xl-7 col-lg-6 col-md-4 col-sm-4 col-5 align-self-center text-start">
						<div class="navigation_header">
							<div class="toggle-nav mobile-menu">
								<button onclick="property_broker_openNav()"><i class="fa-solid fa-bars"></i></button>
							</div>
							<div id="mySidenav" class="nav sidenav">
								<nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'property-broker' ); ?>">
									<?php {
										wp_nav_menu(
											array(
												'theme_location' => 'primary',
												'menu_class'     => 'menu', 
												'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
												'fallback_cb' => 'wp_page_menu',
											)
										);
									} ?>
								</nav>
								<a href="javascript:void(0)" class="closebtn mobile-menu" onclick="property_broker_closeNav()"><i class="fas fa-times"></i></a>
							</div>
						</div>
					</div>
					<div class="col-xl-3 col-lg-3 col-md-4 col-sm-4 col-7 align-self-center text-lg-start text-end">
						<?php if( !empty($property_broker_header_top_button_text) || !empty($property_broker_header_top_button_link) ):?>
							<a class="header-button" href="<?php echo esc_url($property_broker_header_top_button_link);?>"><?php echo esc_html($property_broker_header_top_button_text);?><i class="fa-solid fa-phone ms-2"></i></a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	    <?php
	}

endif;

add_action( 'property_broker_action_header', 'property_broker_site_branding' );

/////////////////////////////////// copyright start /////////////////////////////

if ( ! function_exists( 'property_broker_footer_copyright' ) ) :

	/**
	 * Footer copyright
	 *
	 * @since 1.0.0
	 */
	function property_broker_footer_copyright() {

		// Check if footer is disabled.
		$property_broker_footer_status = apply_filters( 'property_broker_filter_footer_status', true );
		if ( true !== $property_broker_footer_status ) {
			return;
		}

		// Copyright content.
		$property_broker_copyright_text = property_broker_get_option( 'property_broker_copyright_text' );
		$property_broker_copyright_text = apply_filters( 'property_broker_filter_copyright_text', $property_broker_copyright_text );
		if ( ! empty( $property_broker_copyright_text ) ) {
			$property_broker_copyright_text = wp_kses_data( $property_broker_copyright_text );
		}

		// Powered by content.
		$property_broker_powered_by_text = sprintf( __( 'Property Broker by %s', 'property-broker' ), '<span>' . __( 'Mizan Themes', 'property-broker' ) . '</span>' );
		?>

		<div class="colophon-inner <?php echo esc_attr( get_theme_mod('property_broker_sticky_copyright_enable', false) ? 'sticky-copyright' : 'close-sticky' ); ?>">
		    <?php if ( ! empty( $property_broker_copyright_text ) ) : ?>
			    <div class="colophon-column">
			    	<div class="copyright">
						<a href="<?php echo esc_url('https://www.mizanthemes.com/products/free-broker-wordpress-theme','property-broker'); ?>"><?php echo $property_broker_copyright_text; ?></a>	
			    	</div><!-- .copyright -->
			    </div><!-- .colophon-column -->
		    <?php endif; ?>

		    <?php if ( ! empty( $property_broker_powered_by_text ) ) : ?>
			    <div class="colophon-column">
			    	<div class="site-info">
						<?php echo $property_broker_powered_by_text; ?>
			    	</div><!-- .site-info -->
			    </div><!-- .colophon-column -->
		    <?php endif; ?>
		</div><!-- .colophon-inner -->
		
	    <?php
	}

endif;

add_action( 'property_broker_action_footer', 'property_broker_footer_copyright', 10 );

// /////////////////////////////////sidebar//////////////////

if ( ! function_exists( 'property_broker_add_sidebar' ) ) :

	/**
	 * Add sidebar.
	 *
	 * @since 1.0.0
	 */
	function property_broker_add_sidebar() {

		global $post;

		$property_broker_global_layout = property_broker_get_option( 'property_broker_global_layout' );
		$property_broker_global_layout = apply_filters( 'property_broker_filter_theme_global_layout', $property_broker_global_layout );

		// Check if single.
		if ( $post && is_singular() ) {
			$property_broker_post_options = get_post_meta( $post->ID, 'property_broker_theme_settings', true );
			if ( isset( $property_broker_post_options['post_layout'] ) && ! empty( $property_broker_post_options['property_broker_post_layout'] ) ) {
				$property_broker_global_layout = $property_broker_post_options['property_broker_post_layout'];
			}
		}

		// Include primary sidebar.
		if ( 'no-sidebar' !== $property_broker_global_layout ) {
			get_sidebar();
		}
		// Include Secondary sidebar.
		switch ( $property_broker_global_layout ) {
			case 'three-columns':
			get_sidebar( 'secondary' );
			break;

			default:
			break;
		}

		// Include Secondary sidebar 1.
		switch ( $property_broker_global_layout ) {
			case 'four-columns':
			get_sidebar( 'secondary' );
			break;

			default:
			break;
		}

	}

endif;

add_action( 'property_broker_action_sidebar', 'property_broker_add_sidebar' );

//////////////////////////////////////// single page


if ( ! function_exists( 'property_broker_add_image_in_single_display' ) ) :

	/**
	 * Add image in single post.
	 *
	 * @since 1.0.0
	 */
	function property_broker_add_image_in_single_display() {

		global $post;

		if ( has_post_thumbnail() ) {

			$values = get_post_meta( $post->ID, 'property_broker_theme_settings', true );
			$property_broker_theme_settings_single_image = isset( $values['property_broker_single_image'] ) ? esc_attr( $values['property_broker_single_image'] ) : '';

			if ( ! $property_broker_theme_settings_single_image ) {
				$property_broker_theme_settings_single_image = property_broker_get_option( 'property_broker_single_image' );
			}

			if ( 'disable' !== $property_broker_theme_settings_single_image ) {
				$args = array(
					'class' => 'alignleft',
				);
				the_post_thumbnail( esc_attr( $property_broker_theme_settings_single_image ), $args );
			}
		}

	}

endif;

add_action( 'property_broker_single_image', 'property_broker_add_image_in_single_display' );

if ( ! function_exists( 'property_broker_footer_goto_top' ) ) :

	/**
	 * Go to top.
	 *
	 * @since 1.0.0
	 */
	function property_broker_footer_goto_top() {
        
        $property_broker_show_scroll_to_top = property_broker_get_option( 'property_broker_show_scroll_to_top' );
        if ( true === $property_broker_show_scroll_to_top ) :
		echo '<a id="scrollToTopBtn" href="#page">
				<svg id="progressCircle" width="50" height="50" aria-hidden="true">
					<circle cx="25" cy="25" r="22" stroke-width="4" fill="none"/>
				</svg>
				<i class="fa-solid fa-arrow-up"></i>
				</a>';
		endif;

	}

endif;

add_action( 'property_broker_action_after', 'property_broker_footer_goto_top', 20 );