<?php
/**
 * Start Elementor.
 *
 */
?>
<!-- Start Elementor -->
<div id="start-panel" class="panel-left visible">
    <div id="property-broker-importer" class="tabcontent open">
        <?php if(!class_exists('Mizan_Importer_ThemeWhizzie')){
            $plugin_ins = Property_Broker_Plugin_Activation_Mizan_Demo_Importor::get_instance();
            $property_broker_actions = $plugin_ins->recommended_actions;
            ?>
            <div class="property-broker-recommended-plugins ">
                <div class="property-broker-action-list">
                    <?php if ($property_broker_actions): foreach ($property_broker_actions as $key => $property_broker_actionValue): ?>
                            <div class="property-broker-action" id="<?php echo esc_attr($property_broker_actionValue['id']);?>">
                                <div class="action-inner plugin-activation-redirect">
                                    <h3 class="action-title"><?php echo esc_html($property_broker_actionValue['title']); ?></h3>
                                    <div class="action-desc"><?php echo esc_html($property_broker_actionValue['desc']); ?></div>
                                    <?php echo wp_kses_post($property_broker_actionValue['link']); ?>
                                </div>
                            </div>
                        <?php endforeach;
                    endif; ?>
                </div>
            </div>
        <?php }else{ ?>
            <div class="tab-outer-box">
                <h3><?php esc_html_e('Welcome to Mizan Themes', 'property-broker'); ?></h3>
                <p class="start-text"><?php esc_html_e('The demo will import after you click the Start Quickly button.', 'property-broker'); ?></p>
                <div class="info-link">
                    <a class="button button-primary" href="<?php echo esc_url( admin_url('admin.php?page=mizandemoimporter-wizard') ); ?>"><?php esc_html_e('Start Quickly', 'property-broker'); ?></a>
                </div>
            </div>
        <?php } ?>
    </div>
</div>
