<?php
/**
 * Help Panel.
 *
 */
?>
<!-- Help file panel -->
<div id="help-panel" class="panel-left">
    <div class="panel-aside">
        <h4><?php esc_html_e( 'Theme Customizer', 'property-broker' ); ?></h4>
        <p><?php esc_html_e( 'To begin customizing your website, start by clicking "Customize"', 'property-broker' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( admin_url('customize.php') ); ?>" title="<?php esc_attr_e( 'Visit the Demo', 'property-broker' ); ?>" target="_blank">
            <?php esc_html_e( 'Customizing', 'property-broker' ); ?>
        </a>
    </div><!-- .panel-aside -->

    <div class="panel-aside">
        <h4><?php esc_html_e( 'Documentation', 'property-broker' ); ?></h4>
        <p><?php esc_html_e( 'Explore the comprehensive guide and instructions for this WordPress Theme. Begin your journey with assurance.', 'property-broker' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( PROPERTY_BROKER_DOCUMENTATION ); ?>" title="<?php esc_attr_e( 'Visit the doc', 'property-broker' ); ?>" target="_blank">
            <?php esc_html_e( 'Documentation', 'property-broker' ); ?>
        </a>
    </div><!-- .panel-aside -->

    <div class="panel-aside">
        <h4><?php esc_html_e( 'Support Ticket', 'property-broker' ); ?></h4>
        <p><?php esc_html_e( 'Our dedicated team is well prepared to help you out in case of queries and doubts regarding our theme', 'property-broker' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( PROPERTY_BROKER_SUPPORT ); ?>" title="<?php esc_attr_e( 'Visit the Support', 'property-broker' ); ?>" target="_blank">
            <?php esc_html_e( 'Contact Support', 'property-broker' ); ?>
        </a>
    </div><!-- .panel-aside -->

    <div class="panel-aside">
        <h4><?php esc_html_e( 'Reviews & Testimonials', 'property-broker' ); ?></h4>
        <p><?php esc_html_e( 'All the features and aspects of this WordPress Theme are phenomenal. I\'d recommend this theme to all.', 'property-broker' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( PROPERTY_BROKER_REVIEW ); ?>" title="<?php esc_attr_e( 'Visit the Demo', 'property-broker' ); ?>" target="_blank">
            <?php esc_html_e( 'Review', 'property-broker' ); ?>
        </a>
    </div><!-- .panel-aside -->
</div>