<?php
/**
 * Customizer partials.
 *
 * @package property_broker
 */

/**
 * Render the site title for the selective refresh partial.
 *
 * @since 1.0.0
 *
 * @return void
 */
function property_broker_customize_partial_blogname() {

	bloginfo( 'name' );

}

/**
 * Render the site title for the selective refresh partial.
 *
 * @since 1.0.0
 *
 * @return void
 */
function property_broker_customize_partial_blogdescription() {

	bloginfo( 'description' );

}

/**
 * Partial for copyright text.
 *
 * @since 1.0.0
 *
 * @return void
 */
function property_broker_render_partial_copyright_text() {

	$property_broker_copyright_text = property_broker_get_option( 'property_broker_copyright_text' );
	$property_broker_copyright_text = apply_filters( 'property_broker_filter_copyright_text', $property_broker_copyright_text );
	if ( ! empty( $property_broker_copyright_text ) ) {
		$property_broker_copyright_text = wp_kses_data( $property_broker_copyright_text );
	}
	echo $property_broker_copyright_text;

}
