<?php
/**
 * Default theme options.
 *
 * @package property_broker
 */

if ( ! function_exists( 'property_broker_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
	function property_broker_get_default_theme_options() {

		$defaults = array();

		// Typography
		$defaults['property_broker_body_font_family']         = '';
		$defaults['property_broker_h1_font_family']          	= '';
		$defaults['property_broker_h1_font_size']         	= '';
		$defaults['property_broker_h2_font_family']          	= '';
		$defaults['property_broker_h2_font_size']         	= '';
		$defaults['property_broker_h3_font_family']          	= '';
		$defaults['property_broker_h3_font_size']         	= '';
		$defaults['property_broker_h4_font_family']          	= '';
		$defaults['property_broker_h4_font_size']         	= '';
		$defaults['property_broker_h5_font_family']          	= '';
		$defaults['property_broker_h5_font_size']         	= '';
		$defaults['property_broker_h6_font_family']          	= '';
		$defaults['property_broker_h6_font_size']         	= '';

		// Site title And tagline Option

		$defaults['property_broker_site_title_font_size']         = '';
		$defaults['property_broker_site_tagline_font_size']         = '';
		$defaults['property_broker_site_title_color'] = '#fff';

		// Global Color
		$defaults['property_broker_first_color']        = '#1B365D';
		$defaults['property_broker_second_color']        = '#E3B505';

		//General Option
        $defaults['property_broker_show_scroll_to_top']          = true;
        $defaults['property_broker_show_preloader_setting']      = false;
		$defaults['property_broker_enable_cursor_dot_outline'] = false;

        //Post Option
        $defaults['property_broker_show_post_date_setting']         		 = true;
        $defaults['property_broker_show_post_heading_setting']      		 = true;
        $defaults['property_broker_show_post_content_setting']       		 = true;
        $defaults['property_broker_show_post_admin_setting']         		 = true;
        $defaults['property_broker_show_post_categories_setting']    		 = true;
        $defaults['property_broker_show_post_comments_setting']    	 	 = true;
        $defaults['property_broker_show_post_featured_image_setting']   	 = true;
        $defaults['property_broker_show_post_tags_setting']    			 = true;
		$defaults['property_broker_enable_post_navigation'] 				= true;
		$defaults['property_broker_show_first_caps']      			= false;

		// Related Post
		$defaults['property_broker_enable_related_post'] 					= true;
		$defaults['property_broker_enable_related_post_image'] 					= true;

		// Header.
		$defaults['property_broker_show_title']            = true;
		$defaults['property_broker_show_tagline']          = false;
		$defaults['property_broker_show_social_icon']      = true;
		$defaults['property_broker_show_top_header']      = true;
	
		// Layout.
		$defaults['property_broker_global_layout']           = 'right-sidebar';
		$defaults['property_broker_archive_layout']          = 'excerpt';
		$defaults['property_broker_archive_image']           = 'large';
		$defaults['property_broker_archive_image_alignment'] = 'none';
		$defaults['property_broker_single_image']            = 'large';

		// Home Page.
		$defaults['property_broker_home_content_status'] = true;

		// Wow Animation
        $defaults['property_broker_animation'] = true;

		// Sticky copyright
        $defaults['property_broker_sticky_copyright_enable'] = false;

		// No Result.
		$defaults['property_broker_no_result_title']  = esc_html__( 'Nothing Found', 'property-broker' );
		$defaults['property_broker_no_result_text']  = esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'property-broker' );

		// Footer.
		$defaults['property_broker_copyright_text']        = esc_html__( 'Copyright &copy; All rights reserved.', 'property-broker' );
		$defaults['property_broker_copyright_background_color'] = '#1B365D';
		$defaults['property_broker_copyright_text_color'] = '#fff';
		
		// Pass through filter.
		$defaults = apply_filters( 'property_broker_filter_default_theme_options', $defaults );
		return $defaults;
	}

endif;
