<?php
/**
 * Core functions.
 *
 * @package property_broker
 */

if ( ! function_exists( 'property_broker_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function property_broker_get_option( $key ) {

		$property_broker_default_options = property_broker_get_default_theme_options();

		if ( empty( $key ) ) {
			return;
		}

		$property_broker_theme_options = (array)get_theme_mod( 'theme_options' );
		$property_broker_theme_options = wp_parse_args( $property_broker_theme_options, $property_broker_default_options );

		$property_broker_value = null;

		if ( isset( $property_broker_theme_options[ $key ] ) ) {
			$property_broker_value = $property_broker_theme_options[ $key ];
		}

		return $property_broker_value;

	}

endif;

if ( ! function_exists( 'property_broker_get_options' ) ) :

	/**
	 * Get all theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Theme options.
	 */
  function property_broker_get_options() {

    $property_broker_default_options = property_broker_get_default_theme_options();
    $property_broker_theme_options = (array)get_theme_mod( 'theme_options' );
    $property_broker_theme_options = wp_parse_args( $property_broker_theme_options, $property_broker_default_options );
    return $property_broker_theme_options;

  }

endif;

if( ! function_exists( 'property_broker_exclude_category_in_blog_page' ) ) :

  /**
   * Exclude category in blog page.
   *
   * @since 1.0
   */
  function property_broker_exclude_category_in_blog_page( $query ) {

    if( $query->is_home && $query->is_main_query()   ) {
      $property_broker_exclude_categories = property_broker_get_option( 'exclude_categories' );
      if ( ! empty( $property_broker_exclude_categories ) ) {
        $cats = explode( ',', $property_broker_exclude_categories );
        $cats = array_filter( $cats, 'is_numeric' );
        $property_broker_string_exclude = '';
        if ( ! empty( $cats ) ) {
          $property_broker_string_exclude = '-' . implode( ',-', $cats);
          $query->set( 'cat', $property_broker_string_exclude );
        }
      }
    }
    return $query;
  }

endif;

add_filter( 'pre_get_posts', 'property_broker_exclude_category_in_blog_page' );
