<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package property_broker
 */

?>
<?php
	/**
	 * Hook - property_broker_action_doctype.
	 *
	 * @hooked property_broker_doctype -  10
	 */
	do_action( 'property_broker_action_doctype' );
?>
<head>
	<?php
	/**
	 * Hook - property_broker_action_head.
	 *
	 * @hooked property_broker_head -  10
	 */
	do_action( 'property_broker_action_head' );
	?>

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php do_action( 'wp_body_open' ); ?>

	<?php
	$property_broker_show_preloader = property_broker_get_option( 'property_broker_show_preloader_setting' );
        if ( true === $property_broker_show_preloader ) : ?>
			<div id="preloader" class="loader-head">
				<div class="preloader">
				    <div class="spinner"></div>
				    <div class="spinner-2"></div>
				</div>
			</div>
	<?php endif; ?>

	<?php
	/**
	 * Hook - property_broker_action_before.
	 *
	 * @hooked property_broker_page_start - 10
	 * @hooked property_broker_skip_to_content - 15
	 */
	do_action( 'property_broker_action_before' );
	?>

    <?php
	  /**
	   * Hook - property_broker_action_before_header.
	   *
	   * @hooked property_broker_header_start - 10
	   */
	  do_action( 'property_broker_action_before_header' );
	?>
		<?php
		/**
		 * Hook - property_broker_action_header.
		 *
		 * @hooked property_broker_site_branding - 10
		 */
		do_action( 'property_broker_action_header' );
		?>
    <?php
	  /**
	   * Hook - property_broker_action_after_header.
	   *
	   * @hooked property_broker_header_end - 10
	   */
	  do_action( 'property_broker_action_after_header' );
	?>

	<?php
	/**
	 * Hook - property_broker_action_before_content.
	 *
	 * @hooked property_broker_content_start - 10
	 */
	do_action( 'property_broker_action_before_content' );
	?>

	<!-- <?php
	  /**
	   * Hook - property_broker_action_content.
	   */
	  do_action( 'property_broker_action_content' );
	?> -->
