<?php
/**
 * Header page.
 *
 * @package     productive-business
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */

wp_body_open();

do_action( 'productive_business_body_open' );

$is_productive_business_has_custom_logo = has_custom_logo();
$productive_business_is_custom_logo_text = '';
if( !$is_productive_business_has_custom_logo ) {
    $productive_business_is_custom_logo_text = 'is_custom_logo_text';
}
$productive_business_customiser_show_search            = productive_business_enable_header_search();
$productive_business_customiser_show_account_icon      = productive_business_enable_header_account();
?>

<header class="site-body-container header-container extra-base-design-01">
        
    <?php do_action( 'productive_business_render_site_announcement' ); ?>
    
    <?php
        if( productive_business_is_productive_forms_active() && PRODUCTIVE_BUSINESS_CUSTOMIZER_header_contact_section_switch_on ) {
            do_action('productive_forms_actn_header_contact_section');
        }
    ?>
    
    <div class="site-body-container_box align-items-center">
        <div class="site-body-container_box_uno relatived">
            
            <div class="productiveminds-alignable-container header-container-box align-items-center align-content-center column-gap-50px <?php echo esc_attr( $productive_business_is_custom_logo_text ); ?>">
                <div class="header-logo header-site-identity productiveminds-alignable-container align-items-center align-content-center">
                    <div class="header-logo-block-container productiveminds-alignable-container align-items-center align-content-center">
                        <div class="header-logo-block-navicon" style="line-height: 0">
                            <?php do_action( 'productive_global_render_theme_navicon_left', 'navicon_mode_dark' ); ?>
                        </div>
                        <div class="header-logo-block-image">
                            <?php if ( ! $is_productive_business_has_custom_logo ) { ?>
                                <a class="logo-text" href="<?php echo esc_url( home_url() ); ?>" >
                                    <span class="logo-text-name"><?php bloginfo( 'name' ); ?></span><span class="logo-text-desc"><?php bloginfo( 'description' ); ?></span>
                                </a>
                            <?php } else { ?>
                                <?php productive_business_the_custom_logo(); ?>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="productiveminds-alignable-container header-container-inner-box flexed align-items-center align-content-center justify-content-flex-end justify-items-end column-gap-20px row-gap-5px">
                    <div class="site-header-menu flexed-autoed hide-below-landscape-mobile">
                        <?php do_action( 'productive_business_display_header_secondary_nav', 'site-header-menu-nav site_header_nav_big_screen' ); ?>
                    </div>
                    <div class="header-icons">
                        <div class="header-icons-items productiveminds-alignable-container flexed flexed-in-a-flexed justify-content-flex-end row-gap-5px column-gap-20px righted">
                            <?php do_action( 'productive_business_display_power_button_title' ); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php
        if( ( (productive_global_is_productive_style_active() || function_exists('pass_addons_is_active')) && PRODUCTIVE_BUSINESS_CUSTOMIZER_breadcrumb_switch_on ) && 'hide_top_banner' == PRODUCTIVE_BUSINESS_CUSTOMIZER_show_top_banner ) {
            do_action('productive_breadcrumb_render');
        }
    ?>
</header>
