<?php
/**
 * @package     productive-business
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */

if ( !function_exists('productive_theme_dashboard_items') ) {
    
    function productive_theme_dashboard_items_cpt() {
        
        $items = array();
        
        if ( productiveminds_is_productive_content_element() ) {
            $content_element = array(
                'singular' => esc_html__( 'Content Element', 'productive-business' ),
                'plural' => esc_html__( 'Content Elements', 'productive-business' ),
                'slug' => 'pro_content_element',
                'content' => esc_html__( 'Various site content elements, breadcrumbs, videos elements, banners, brands slides, among others.', 'productive-business' ),
                'taxonomy_slug' => 'content-element-type',
                'is_active' => productive_business_is_productive_style_active() && productive_style_manage_cpts_content_element_enable(),
                'is_extra' => 0,
            );
            $items['element'] = $content_element;
        }
        
        if ( productiveminds_is_productive_home_slider() ) {
            $home_slider = array(
                'singular' => 'Banner Slider',
                'plural' => 'Banner Sliders',
                'slug' => 'pro_slider',
                'content' => esc_html__( 'Banner slides content with corresponding CTA buttons and customizations for each slide.', 'productive-business' ),
                'taxonomy_slug' => 'pro-slider-type',
                'is_active' => productive_business_is_productive_style_active() && productive_style_manage_cpts_slider_enable(),
                'is_extra' => 0,
            );
            $items['pro_slider'] = $home_slider;
        }
        
        if ( productiveminds_is_productive_team() ) {
            $team = array(
                'singular' => esc_html__( 'Team Member', 'productive-business' ),
                'plural' => esc_html__( 'Team Members', 'productive-business' ),
                'slug' => 'pro_team',
                'content' => esc_html__( 'Create and manage team member profiles and social media preferences.', 'productive-business' ),
                'taxonomy_slug' => 'team-type',
                'is_active' => productive_business_is_productive_style_active() && productive_style_manage_cpts_team_enable(),
                'is_extra' => 1,
            );
            $items['team'] = $team;
        }
        
        if ( productiveminds_is_productive_testimonial() ) {
            $testimonial = array(
                'singular' => esc_html__( 'Testimonial', 'productive-business' ),
                'plural' => esc_html__( 'Testimonials', 'productive-business' ),
                'slug' => 'pro_testimonial',
                'content' => esc_html__( 'Manage testimonials from clients and customize various display options.', 'productive-business' ),
                'taxonomy_slug' => '',
                'is_active' => productive_business_is_productive_style_active() && productive_style_manage_cpts_testimonial_enable(),
                'is_extra' => 1,
            );
            $items['testimonial'] = $testimonial;
        }
        
        if ( productiveminds_is_productive_faq() ) {
            $faq = array(
                'singular' => esc_html__( 'FAQ', 'productive-business' ),
                'plural' => esc_html__( 'FAQs', 'productive-business' ),
                'slug' => 'pro_faq',
                'content' => esc_html__( 'Add and manage content to publish on dedicated a FAQs page.', 'productive-business' ),
                'taxonomy_slug' => 'faq-category',
                'is_active' => productive_business_is_productive_style_active() && productive_style_manage_cpts_faq_enable(),
                'is_extra' => 0,
            );
            $items['faq'] = $faq;
        }
        
        return $items;
    }
    
    
    function productive_theme_dashboard_items_customizer() {
        
        $items = array();
        $is_forms = productive_business_is_productive_forms_active();
        $is_style = productive_business_is_productive_style_active();
        $is_style_extra = productive_business_is_productive_style_extra_active();
        
        $url1 = admin_url( 'customize.php?autofocus[section]=title_tagline' );
        $customizer_1 = array(
            'customizer' => esc_html__( 'Site Identity', 'productive-business' ),
            'slug' => 'identity',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Logo, site name, favicon', 'productive-business' ),
            'url' => $url1,
            'is_extra' => 0,
        );
        $items['identity'] = $customizer_1;
        
        if( $is_style ) {
            $url2a = admin_url( 'customize.php?autofocus[panel]=productive_style_theme_options_homepage' );
        } else {
            $url2a = admin_url( 'customize.php?autofocus[panel]=productive_business_theme_homepage_options' );
        }
        $customizer_2a = array(
            'customizer' => esc_html__( 'Homepage', 'productive-business' ),
            'slug' => 'homepage',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Control banner and content', 'productive-business' ),
            'url' => $url2a,
            'is_extra' => 0,
        );
        $items['homepage'] = $customizer_2a;
        
        $url2b = admin_url( 'customize.php?autofocus[section]=productive_business_homepage_options_banner_background' );
        $customizer_2b = array(
            'customizer' => esc_html__( 'Customize Banner', 'productive-business' ),
            'slug' => 'homepage_banner_switch',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Switch to a different banner design', 'productive-business' ),
            'url' => $url2b,
            'is_extra' => 1,
        );
        $items['homepage_banner_switch'] = $customizer_2b;
        
        $url2c = admin_url( 'customize.php?autofocus[section]=productive_business_homepage_options_slider_options' );
        $customizer_2c = array(
            'customizer' => esc_html__( 'Homepage Slider', 'productive-business' ),
            'slug' => 'homepage_slider_switch',
            'plugin' => 'productive_style',
            'plugin_exists' => true,
            'content' => esc_html__( 'Brand the home slider and slides', 'productive-business' ),
            'url' => $url2c,
            'is_extra' => 0,
        );
        $items['homepage_slider_switch'] = $customizer_2c;
        
        if( $is_style ) {
            $url3a = admin_url( 'customize.php?autofocus[section]=productive_style_all_headings_font_typography_options' );
        } else {
            $url3a = PRODUCTIVE_GLOBAL_PRODUCTIVE_PLUGIN_PASS_ADDONS_REPO_URL;
        }
        $customizer_3a = array(
            'customizer' => esc_html__( 'Headings Typography', 'productive-business' ),
            'slug' => 'typography_headings',
            'plugin' => 'productive_style',
            'plugin_exists' => $is_style,
            'content' => esc_html__( 'Fonts typography for h1, h2, h3, h4...', 'productive-business' ),
            'url' => $url3a,
            'is_extra' => 0,
        );
        $items['typography_headings'] = $customizer_3a;
        
        if( $is_style ) {
            $url3b = admin_url( 'customize.php?autofocus[section]=productive_style_body_font_typography_options' );
        } else {
            $url3b = PRODUCTIVE_GLOBAL_PRODUCTIVE_PLUGIN_PASS_ADDONS_REPO_URL;
        }
        $customizer_3b = array(
            'customizer' => esc_html__( 'Site Body Typography', 'productive-business' ),
            'slug' => 'typography_body',
            'plugin' => 'productive_style',
            'plugin_exists' => $is_style,
            'content' => esc_html__( 'Control site-wide typography', 'productive-business' ),
            'url' => $url3b,
            'is_extra' => 0,
        );
        $items['typography_body'] = $customizer_3b;
        
        $url3c = admin_url( 'customize.php?autofocus[section]=productive_business_color_scheme_options' );
        $customizer_3c = array(
            'customizer' => esc_html__( 'Switch Colour Schemes', 'productive-business' ),
            'slug' => 'colour_scheme',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'With one-click, change all colours', 'productive-business' ),
            'url' => $url3c,
            'is_extra' => 1,
        );
        $items['colour_scheme'] = $customizer_3c;
        
        $url3d = admin_url( 'customize.php?autofocus[section]=productive_business_sitewide_colors_options' );
        $customizer_3d = array(
            'customizer' => esc_html__( 'Individual Colours', 'productive-business' ),
            'slug' => 'sitewide_colors',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Customize specific colour', 'productive-business' ),
            'url' => $url3d,
            'is_extra' => 1,
        );
        $items['sitewide_colors'] = $customizer_3d;
        
        if( $is_style ) {
            $url3_plus_1 = admin_url( 'customize.php?autofocus[section]=productive_style_breadcrumb_options' );
        } else {
            $url3_plus_1 = PRODUCTIVE_GLOBAL_PRODUCTIVE_PLUGIN_PASS_ADDONS_REPO_URL;
        }
        $customizer_3_plus_1 = array(
            'customizer' => esc_html__( 'Breadcrumb Options', 'productive-business' ),
            'slug' => 'breadcrumb',
            'plugin' => 'productive_style',
            'plugin_exists' => $is_style,
            'content' => esc_html__( 'ontrol site-wide Breadcrumbs', 'productive-business' ),
            'url' => $url3_plus_1,
            'is_extra' => 0,
        );
        $items['breadcrumb'] = $customizer_3_plus_1;
        
        if( $is_forms ) {
            $url3_plus_2 = admin_url( 'customize.php?autofocus[section]=productive_forms_newsletter_options' );
        } else {
            $url3_plus_2 = PRODUCTIVE_BUSINESS_PRODUCTIVE_PLUGIN_FORMS_REPO_URL;
        }
        $customizer_3_plus_2 = array(
            'customizer' => esc_html__( 'Newsletter Opt Ins', 'productive-business' ),
            'slug' => 'newsletter',
            'plugin' => 'productive_forms',
            'plugin_exists' => $is_forms,
            'content' => esc_html__( 'Activate newsletter opt-ins', 'productive-business' ),
            'url' => $url3_plus_2,
            'is_extra' => 0,
        );
        $items['newsletter'] = $customizer_3_plus_2;
        
        if( $is_forms ) {
            $url3_plus_3 = admin_url( 'customize.php?autofocus[section]=productive_forms_header_contact_section_options' );
        } else {
            $url3_plus_3 = PRODUCTIVE_BUSINESS_PRODUCTIVE_PLUGIN_FORMS_REPO_URL;
        }
        $customizer_3_plus_3 = array(
            'customizer' => esc_html__( 'Header Contact Section', 'productive-business' ),
            'slug' => 'header_contact_section',
            'plugin' => 'productive_forms',
            'plugin_exists' => $is_forms,
            'content' => esc_html__( 'Body color and background', 'productive-business' ),
            'url' => $url3_plus_3,
            'is_extra' => 0,
        );
        $items['header_contact_section'] = $customizer_3_plus_3;
        
        $url4 = admin_url( 'customize.php?autofocus[section]=productive_business_layout_options' );
        $customizer_4 = array(
            'customizer' => esc_html__( 'Website Layout', 'productive-business' ),
            'slug' => 'layout',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( '1 column, left or right sidebars, 3 columns', 'productive-business' ),
            'url' => $url4,
            'is_extra' => 0,
        );
        $items['layout'] = $customizer_4;
        
        if( productive_business_is_woocommerce_activated() ) {
            /*
            $url5 = admin_url( 'customize.php?autofocus[section]=productive_business_theme_commerce_product_page' );
            $customizer_5 = array(
                'customizer' => esc_html__( 'Product Page', 'productive-business' ),
                'slug' => 'woo_product_page',
                'plugin' => 'in_theme',
                'plugin_exists' => true,
                'content' => esc_html__( 'Customize Product Page', 'productive-business' ),
                'url' => $url5,
                'is_extra' => 1,
            );
            $items['woo_product_page'] = $customizer_5;
            */
            
            $url6a = admin_url( 'customize.php?autofocus[section]=productive_business_theme_commerce_categories' );
            $customizer_6a = array(
                'customizer' => esc_html__( 'Product Archives', 'productive-business' ),
                'slug' => 'woo_product_archive',
                'plugin' => 'in_theme',
                'plugin_exists' => true,
                'content' => esc_html__( 'Shop and Product categories', 'productive-business' ),
                'url' => $url6a,
                'is_extra' => 1,
            );
            $items['woo_product_archive'] = $customizer_6a;

            $url6b = admin_url( 'customize.php?autofocus[section]=productive_business_theme_commerce_generic' );
            $customizer_6b = array(
                'customizer' => esc_html__( 'WooCommerce Options', 'productive-business' ),
                'slug' => 'woo_generic_options',
                'plugin' => 'in_theme',
                'plugin_exists' => true,
                'content' => esc_html__( 'General WooCommerce options', 'productive-business' ),
                'url' => $url6b,
                'is_extra' => 0,
            );
            $items['woo_generic_options'] = $customizer_6b;

            $url6c = admin_url( 'customize.php?autofocus[section]=productive_business_theme_commerce_payment_methods' );
            $customizer_6c = array(
                'customizer' => esc_html__( 'Payment Methods', 'productive-business' ),
                'slug' => 'woo_payment_method_options',
                'plugin' => 'in_theme',
                'plugin_exists' => true,
                'content' => esc_html__( 'Accepted payment method logos', 'productive-business' ),
                'url' => $url6c,
                'is_extra' => 1,
            );
            $items['woo_payment_method_options'] = $customizer_6c;
        }
        
        $url7a = admin_url( 'customize.php?autofocus[section]=productive_business_theme_header' );
        $customizer_7a = array(
            'customizer' => esc_html__( 'Header Option', 'productive-business' ),
            'slug' => 'header',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Website header  style and content', 'productive-business' ),
            'url' => $url7a,
            'is_extra' => 0,
        );
        $items['header'] = $customizer_7a;
        
        $url7b = admin_url( 'customize.php?autofocus[section]=productive_business_theme_header' );
        $customizer_7b = array(
            'customizer' => esc_html__( 'Switch Header Design', 'productive-business' ),
            'slug' => 'header_design',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Change design and colour mode', 'productive-business' ),
            'url' => $url7b,
            'is_extra' => 1,
        );
        $items['header_design'] = $customizer_7b;
        
        $url7c = admin_url( 'customize.php?autofocus[section]=productive_business_localization_options' );
        $customizer_7c = array(
            'customizer' => esc_html__( 'Localization', 'productive-business' ),
            'slug' => 'header_localisation',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Language & Currency switcher options', 'productive-business' ),
            'url' => $url7c,
            'is_extra' => 1,
        );
        $items['header_localisation'] = $customizer_7c;
        
        $url8a = admin_url( 'customize.php?autofocus[section]=productive_business_footer_options' );
        $customizer_8a = array(
            'customizer' => esc_html__( 'Footer Options', 'productive-business' ),
            'slug' => 'footer',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Website footer style and content', 'productive-business' ),
            'url' => $url8a,
            'is_extra' => 0,
        );
        $items['footer'] = $customizer_8a;
        
        $url8b = admin_url( 'customize.php?autofocus[section]=productive_business_footer_options' );
        $customizer_8b = array(
            'customizer' => esc_html__( 'Switch Footer Design', 'productive-business' ),
            'slug' => 'footer_design',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Change design and colour mode', 'productive-business' ),
            'url' => $url8b,
            'is_extra' => 1,
        );
        $items['footer_design'] = $customizer_8b;
        
        $url8c = admin_url( 'customize.php?autofocus[section]=productive_business_footer_copyright_options' );
        $customizer_8c = array(
            'customizer' => esc_html__( 'Switch Copyright Design', 'productive-business' ),
            'slug' => 'copyright_design',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Change copyright section design', 'productive-business' ),
            'url' => $url8c,
            'is_extra' => 1,
        );
        $items['copyright_design'] = $customizer_8c;
        
        $url9 = admin_url( 'customize.php?autofocus[section]=productive_business_404_options' );
        $customizer_9 = array(
            'customizer' => esc_html__( '404 Page', 'productive-business' ),
            'slug' => 'page_404',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Make page 404 interesting', 'productive-business' ),
            'url' => $url9,
            'is_extra' => 0,
        );
        $items['page_404'] = $customizer_9;
        
        $url12 = admin_url( 'customize.php?autofocus[section]=productive_business_homepage_blog_options' );
        $customizer_12 = array(
            'customizer' => esc_html__( 'Blog Archive', 'productive-business' ),
            'slug' => 'blog_archive',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Content and controls options', 'productive-business' ),
            'url' => $url12,
            'is_extra' => 0,
        );
        $items['blog_archive'] = $customizer_12;
        
        $url13 = admin_url( 'customize.php?autofocus[section]=productive_business_homepage_blog_single_options' );
        $customizer_13 = array(
            'customizer' => esc_html__( 'Blog Page', 'productive-business' ),
            'slug' => 'blog_signle',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Content and controls options', 'productive-business' ),
            'url' => $url13,
            'is_extra' => 0,
        );
        $items['blog_signle'] = $customizer_13;
        
        $url13b = admin_url( 'customize.php?autofocus[section]=productive_business_homepage_blog_single_options' );
        $customizer_13b = array(
            'customizer' => esc_html__( 'Blog Page Width', 'productive-business' ),
            'slug' => 'blog_signle_extra',
            'plugin' => 'in_theme',
            'plugin_exists' => true,
            'content' => esc_html__( 'Be specific about blog page width', 'productive-business' ),
            'url' => $url13b,
            'is_extra' => 1,
        );
        $items['blog_signle_extra'] = $customizer_13b;
        
        return $items;
    }
    
}
