<?php
/**
 * Theme Customiser
 *
 * @package     productive-business
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */

if ( ! defined( 'ABSPATH' ) ) {
    die();
}


if ( ! class_exists( 'Productive_Theme_Customiser_Homepage_Banner_And_Slider_Options' ) ) {
    
    /**
     * Productive_Theme_Customiser_Homepage_Banner_And_Slider_Options
     * Theme Customiser Class
     */
    class Productive_Theme_Customiser_Homepage_Banner_And_Slider_Options extends Productive_Theme_Customiser_Common {
        
        /**
         * Register the customizer
         *
         * @param WP_Customize_Manager $wp_customise param.
         */
        public static function register( $wp_customise ) {
            
            // See common for Panels
            // 
            // Section
            $panel = 'productive_business_theme_homepage_options';
            $title = esc_html__( 'Home Banner Options', 'productive-business' );
            if ( function_exists('pass_addons_is_active') ) {
                $panel = 'pass_addons_theme_options_homepage';
                $title = esc_html__( 'Banner & Slider Options', 'productive-business' );
            } else if ( productive_business_is_productive_style_active() ) {
                $panel = 'productive_style_theme_options_homepage';
                $title = esc_html__( 'Banner & Slider Options', 'productive-business' );
            }
            $wp_customise->add_section(
                'productive_business_homepage_options_banner_background',
                array(
                    'title' => $title,
                    'description' => '',
                    'panel' => $panel,
                    'priority' => 10,
                    'capability' => 'edit_theme_options',
                )
                );
            
            $enable_title = esc_html__( 'Enable Home Banner', 'productive-business' );
            $enable_blog_posts_title = esc_html__( 'Enable Banner on Blog Posts Home', 'productive-business' );
            if ( productive_business_is_productive_style_active() || function_exists('pass_addons_is_active') ) {
                $enable_title = esc_html__( 'Enable Home Banner & Slider', 'productive-business' );
                $enable_blog_posts_title = esc_html__( 'Enable Banner & Slider on Blog Posts Home', 'productive-business' );
            }
            $wp_customise->add_setting(
                'productive_business_is_homepage_banner_enable',
                array(
                    'type' => 'theme_mod',
                    'default' => true,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_checkbox'),
                )
                );
            $wp_customise->add_control(
                'productive_business_is_homepage_banner_enable',
                array(
                    'type' => 'checkbox',
                    'priority' => 10,
                    'section' => 'productive_business_homepage_options_banner_background',
                    'label' => $enable_title,
                    'description' => esc_html__( 'Untick the box to hide the home banner and slider', 'productive-business' ),
                    // 'active_callback' => 'is_front_page',
                )
                );
            
            $wp_customise->add_setting(
                'productive_business_is_blog_posts_home_banner_enable',
                array(
                    'type' => 'theme_mod',
                    'default' => true,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_checkbox'),
                )
                );
            $wp_customise->add_control(
                'productive_business_is_blog_posts_home_banner_enable',
                array(
                    'type' => 'checkbox',
                    'priority' => 20,
                    'section' => 'productive_business_homepage_options_banner_background',
                    'label' => $enable_blog_posts_title,
                    'description' => esc_html__( 'Untick the box to hide the banner and slider on Blog Posts Home. Only applies when "Reading Settings" options is set to "A Static Page"', 'productive-business' ),
                    // 'active_callback' => 'is_front_page',
                )
                );
            
            $wp_customise->add_setting(
                'productive_business_homepage_banner_type',
                array(
                    'type' => 'theme_mod',
                    'default' => productive_business_get_default_homepage_hero_type(),
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_select'),
                )
            );
            $productive_business_homepage_banner_type_options = array(
                'hero_theme_default_option'     => esc_html__( 'Default Hero Option', 'productive-business' ),
                'hero_image_design_1'     => esc_html__( 'Image Banner - Standard', 'productive-business' ),
                'hero_image_design_2'     => esc_html__( 'Image Banner - Double Columns', 'productive-business' ),
                'hero_image_design_3'     => esc_html__( 'Image Banner - Double Rows', 'productive-business' ),
            );
            if ( productive_business_is_productive_style_active() || function_exists('pass_addons_is_active') ) {
                $productive_business_homepage_banner_type_options['hero_slider_design_1'] = esc_html__( 'Slider', 'productive-business' );
            }
            $wp_customise->add_control(
                'productive_business_homepage_banner_type',
                array(
                    'type' => 'select',
                    'priority' => 30,
                    'section' => 'productive_business_homepage_options_banner_background',
                    'label' => esc_html__( 'Hero Type', 'productive-business' ),
                    'description' => '',
                    'choices' => $productive_business_homepage_banner_type_options,
                )
            );
            
            if( 'hero_image_design_2' == productive_business_homepage_banner_type() || 'hero_image_design_3' == productive_business_homepage_banner_type() ) {
                
                $wp_customise->add_setting(
                    'productive_business_homepage_banner_and_slides_small_banner_num_of_smalls',
                    array(
                        'type' => 'theme_mod',
                        'default' => 2,
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_float'),
                    )
                );
                $wp_customise->add_control(
                    'productive_business_homepage_banner_and_slides_small_banner_num_of_smalls',
                    array(
                        'type' => 'number',
                        'priority' => 40,
                        'section' => 'productive_business_homepage_options_banner_background',
                        'label' => esc_html__( 'Number of Small Banner Boxes', 'productive-business' ),
                        'description' => '',
                        'input_attrs' => array(
                            'min' => 1,
                            'max' => 5,
                            'step' => 1,
                        ),
                    )
                );

                // add a setting for productive_business_homepage_small_banner_elements_text_color control, below.
                $wp_customise->add_setting(
                    'productive_business_homepage_small_banner_elements_text_color',
                    array(
                        'type' => 'theme_mod',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'default'              => '#3a465e',
                        'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_color'),
                    )
                );
                $wp_customise->add_control(
                    new WP_Customize_Color_Control(
                        $wp_customise,
                        'productive_business_homepage_small_banner_elements_text_color',
                        array(
                            'priority' => 60,
                            'label' => esc_html__( 'Small Banner Boxes Text Colour', 'productive-business' ),
                            'section' => 'productive_business_homepage_options_banner_background',
                        )
                    )
                );
            }
            
            if( 'hero_image_design_3' == productive_business_homepage_banner_type() ) {
                
                $wp_customise->add_setting(
                    'productive_business_homepage_small_banner_container_height',
                    array(
                        'type' => 'theme_mod',
                        'default' => 250,
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_absint'),
                    )
                );
                $wp_customise->add_control(
                    'productive_business_homepage_small_banner_container_height',
                    array(
                        'type' => 'number',
                        'priority' => 80,
                        'section' => 'productive_business_homepage_options_banner_background',
                        'label' => esc_html__( 'Small Banner Boxes MInimum Height (px)', 'productive-business' ),
                        'description' => '',
                        'input_attrs' => array(
                            'min' => 50,
                            'max' => 500,
                            'step' => 5,
                        ),
                    )
                );
                
                $wp_customise->add_setting(
                    'productive_business_homepage_small_banner_section_max_width',
                    array(
                        'type' => 'theme_mod',
                        'default' => 800,
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_absint'),
                    )
                );
                $wp_customise->add_control(
                    'productive_business_homepage_small_banner_section_max_width',
                    array(
                        'type' => 'number',
                        'priority' => 90,
                        'section' => 'productive_business_homepage_options_banner_background',
                        'label' => esc_html__( 'Small Banners Boxes Width (px)', 'productive-business' ),
                        'description' => '',
                        'input_attrs' => array(
                            'min' => 50,
                            'max' => 1200,
                            'step' => 5,
                        ),
                    )
                );
                
            }
            
            $wp_customise->add_setting(
                'productive_business_homepage_banner_width',
                array(
                    'type' => 'theme_mod',
                    'default' => 'full_width_page_banner',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_select'),
                )
            );
            $wp_customise->add_control(
                'productive_business_homepage_banner_width',
                array(
                    'type' => 'select',
                    'priority' => 100,
                    'section' => 'productive_business_homepage_options_banner_background',
                    'label' => esc_html__( 'Full Width Banner/Slider?', 'productive-business' ),
                    'description' => '',
                    'choices' => array(
                        'full_width_page_banner' => esc_html__( 'Yes, Full Width', 'productive-business' ),
                        'page_width_page_banner' => esc_html__( 'No, Fit Page Content', 'productive-business' ),
                    ),
                )
            );
            
            $default_banner_height = PRODUCTIVE_BUSINESS_DEFAULT_BANNER_HEIGHT_IMAGE;
            if ( productive_business_is_productive_style_active() || function_exists('pass_addons_is_active') ) {
                $default_banner_height = PRODUCTIVE_BUSINESS_DEFAULT_BANNER_HEIGHT_SLIDER;
            }
            $wp_customise->add_setting(
                'productive_business_homepage_banner_height',
                array(
                    'type' => 'theme_mod',
                    'default' => $default_banner_height,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_absint'),
                )
            );
            $wp_customise->add_control(
                'productive_business_homepage_banner_height',
                array(
                    'type' => 'number',
                    'priority' => 110,
                    'section' => 'productive_business_homepage_options_banner_background',
                    'label' => esc_html__( 'Main Banner/Slider Height (px)', 'productive-business' ),
                    'description' => '',
                    'input_attrs' => array(
                        'min' => PRODUCTIVE_BUSINESS_THE_BANNER_HEIGHT_MIN,
                        'max' => PRODUCTIVE_BUSINESS_THE_BANNER_HEIGHT_MAX,
                        'step' => 10,
                    ),
                )
            );
            
            $wp_customise->add_setting(
                'productive_business_homepage_banner_and_slides_content_width',
                array(
                    'type' => 'theme_mod',
                    'default' => 700,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_absint'),
                )
            );
            $wp_customise->add_control(
                'productive_business_homepage_banner_and_slides_content_width',
                array(
                    'type' => 'number',
                    'priority' => 120,
                    'section' => 'productive_business_homepage_options_banner_background',
                    'label' => esc_html__( 'Main Banner/Slider Content Width (px)', 'productive-business' ),
                    'description' => esc_html__( 'The width of the area container copy and CTAs', 'productive-business' ),
                    'input_attrs' => array(
                        'min' => 300,
                        'max' => 1000,
                        'step' => 10,
                    ),
                )
            );
            
            $wp_customise->add_setting(
                'productive_business_homepage_banner_and_slides_overlay_color',
                array(
                    'type' => 'theme_mod',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'default'              => '#000000',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_color'),
                )
                );
            
            $wp_customise->add_control(
                new WP_Customize_Color_Control(
                    $wp_customise,
                    'productive_business_homepage_banner_and_slides_overlay_color',
                    array(
                        'priority' => 130,
                        'label' => esc_html__( 'Main Banner/Slider Overlay Color', 'productive-business' ),
                        'section' => 'productive_business_homepage_options_banner_background',
                    )
                    )
                );
            
            $wp_customise->add_setting(
                'productive_business_homepage_banner_and_slides_overlay_opacity',
                array(
                    'type' => 'theme_mod',
                    'default' => 0.001,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_float'),
                )
            );
            $wp_customise->add_control(
                'productive_business_homepage_banner_and_slides_overlay_opacity',
                array(
                    'type' => 'number',
                    'priority' => 140,
                    'section' => 'productive_business_homepage_options_banner_background',
                    'label' => esc_html__( 'Banner & Slides Overlay Opacity', 'productive-business' ),
                    'description' => '',
                    'input_attrs' => array(
                        'min' => 0,
                        'max' => 1,
                        'step' => 0.01,
                    ),
                )
            );
            
            $wp_customise->add_setting(
                'productive_business_homepage_banner_border_color',
                array(
                    'type' => 'theme_mod',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'default'              => '#c9c9c9',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_color'),
                )
                );
            
            $wp_customise->add_control(
                new WP_Customize_Color_Control(
                    $wp_customise,
                    'productive_business_homepage_banner_border_color',
                    array(
                        'priority' => 150,
                        'label' => esc_html__( 'Banner Border Color', 'productive-business' ),
                        'section' => 'productive_business_homepage_options_banner_background',
                    )
                    )
                );
            
            if( !strpos( productive_business_homepage_banner_type(), 'slider' ) !== false ) {
                $wp_customise->add_setting(
                    'productive_business_homepage_banner_alignment_v',
                    array(
                        'type' => 'theme_mod',
                        'default' => 'align-content-center',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_select'),
                    )
                );
                $wp_customise->add_control(
                    'productive_business_homepage_banner_alignment_v',
                    array(
                        'type' => 'select',
                        'priority' => 160,
                        'section' => 'productive_business_homepage_options_banner_background',
                        'label' => esc_html__( 'Banner Content Vertical Alignment', 'productive-business' ),
                        'description' => '',
                        'choices' => productive_global_get_vertical_align_content_options(),
                    )
                );

                $wp_customise->add_setting(
                    'productive_business_homepage_banner_alignment_h',
                    array(
                        'type' => 'theme_mod',
                        'default' => 'justify-items-start',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_select'),
                    )
                );
                $wp_customise->add_control(
                    'productive_business_homepage_banner_alignment_h',
                    array(
                        'type' => 'select',
                        'priority' => 170,
                        'section' => 'productive_business_homepage_options_banner_background',
                        'label' => esc_html__( 'Banner Content Horizontal Alignment', 'productive-business' ),
                        'description' => '',
                        'choices' => productive_global_get_horizontal_justify_items_options(),
                    )
                );
            }
            
        }
    } // End of class.
    
    // add hook for the class.
    add_action( 'customize_register', array( 'Productive_Theme_Customiser_Homepage_Banner_And_Slider_Options', 'register' ) );
    
} // End of if class exists


/**
 * Method productive_business_is_homepage_banner_enable.
 *
 * @param string $class ''.
 */
function productive_business_is_homepage_banner_enable( $class = '' ) {
    return get_theme_mod( 'productive_business_is_homepage_banner_enable', true );
}

/**
 * Method productive_business_is_blog_posts_home_banner_enable.
 *
 * @param string $class ''.
 */
function productive_business_is_blog_posts_home_banner_enable( $class = '' ) {
    return get_theme_mod( 'productive_business_is_blog_posts_home_banner_enable', true );
}

/**
 * Method productive_business_homepage_banner_type.
 *
 * @param string $class ''.
 */
function productive_business_homepage_banner_type( $class = '' ) {
    return get_theme_mod( 'productive_business_homepage_banner_type', productive_business_get_default_homepage_hero_type() );
}

/**
 * Method productive_business_homepage_banner_and_slides_small_banner_num_of_smalls.
 *
 * @param string $class ''.
 */
function productive_business_homepage_banner_and_slides_small_banner_num_of_smalls( $class = '' ) {
    return get_theme_mod( 'productive_business_homepage_banner_and_slides_small_banner_num_of_smalls', 2 );
}

/**
 * Method productive_business_homepage_small_banner_elements_text_color.
 *
 * @param string $class ''.
 */
function productive_business_homepage_small_banner_elements_text_color( $class = '' ) {
    return get_theme_mod( 'productive_business_homepage_small_banner_elements_text_color', '#3a465e' );
}

/**
 * Method productive_business_homepage_small_banner_container_height.
 *
 * @param string $class ''.
 */
function productive_business_homepage_small_banner_container_height( $class = '' ) {
    return get_theme_mod( 'productive_business_homepage_small_banner_container_height', 250 );
}

/**
 * Method productive_business_homepage_small_banner_section_max_width.
 *
 * @param string $class ''.
 */
function productive_business_homepage_small_banner_section_max_width( $class = '' ) {
    return get_theme_mod( 'productive_business_homepage_small_banner_section_max_width', 800 );
}

/**
 * Method productive_business_homepage_banner_width.
 *
 * @param string $class ''.
 */
function productive_business_homepage_banner_width( $class = '' ) {
    return get_theme_mod( 'productive_business_homepage_banner_width', 'full_width_page_banner' );
}

/**
 * Method productive_business_homepage_banner_height.
 *
 * @param string $class ''.
 */
function productive_business_homepage_banner_height( $class = '' ) {
    $default_banner_height = PRODUCTIVE_BUSINESS_DEFAULT_BANNER_HEIGHT_IMAGE;
    if ( productive_business_is_productive_style_active() || function_exists('pass_addons_is_active') ) {
        $default_banner_height = PRODUCTIVE_BUSINESS_DEFAULT_BANNER_HEIGHT_SLIDER;
    }
    return get_theme_mod( 'productive_business_homepage_banner_height', $default_banner_height );
}

/**
 * Method productive_business_homepage_banner_and_slides_content_width.
 *
 * @param string $class ''.
 */
function productive_business_homepage_banner_and_slides_content_width( $class = '' ) {
    return get_theme_mod( 'productive_business_homepage_banner_and_slides_content_width', 700 );
}

/**
 * Method productive_business_homepage_banner_and_slides_overlay_color.
 *
 * @param string $class ''.
 */
function productive_business_homepage_banner_and_slides_overlay_color( $class = '' ) {
    return get_theme_mod( 'productive_business_homepage_banner_and_slides_overlay_color', '#000000' );
}

/**
 * Method productive_business_homepage_banner_and_slides_overlay_opacity.
 *
 * @param string $class ''.
 */
function productive_business_homepage_banner_and_slides_overlay_opacity( $class = '' ) {
    return get_theme_mod( 'productive_business_homepage_banner_and_slides_overlay_opacity', 0.001 );
}

/**
 * Method productive_business_homepage_banner_border_color.
 *
 * @param string $class ''.
 */
function productive_business_homepage_banner_border_color( $class = '' ) {
    return get_theme_mod( 'productive_business_homepage_banner_border_color', '#c9c9c9' );
}

/**
 * Method productive_business_homepage_banner_alignment_v.
 *
 * @param string $class ''.
 */
function productive_business_homepage_banner_alignment_v( $class = '' ) {
    return get_theme_mod( 'productive_business_homepage_banner_alignment_v', 'align-content-center' );
}

/**
 * Method productive_business_homepage_banner_alignment_h.
 *
 * @param string $class ''.
 */
function productive_business_homepage_banner_alignment_h( $class = '' ) {
    return get_theme_mod( 'productive_business_homepage_banner_alignment_h', 'justify-items-start' );
}

