<?php
/**
 * Theme Customiser
 *
 * @package     productive-business
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */

if ( ! defined( 'ABSPATH' ) ) {
    die();
}


if ( ! class_exists( 'Productive_Theme_Customiser_Global_Popup' ) ) {
    
    /**
     * Productive_Theme_Customiser_Global_Popup
     * Theme Customiser Class
     */
    class Productive_Theme_Customiser_Global_Popup extends Productive_Theme_Customiser_Common {
        
        /**
         * Register the customizer
         *
         * @param WP_Customize_Manager $wp_customise param.
         */
        public static function register( $wp_customise ) {
            
            // See common for Panels
            // 
            // Section
            $wp_customise->add_section(
                'productive_business_theme_global_popup',
                array(
                    'title' => esc_html__( 'Off Canvas Options', 'productive-business' ),
                    'description' => esc_html__( 'Off Canvas Options', 'productive-business' ),
                    'panel' => 'productive_business_theme_options',
                    'priority' => 20,
                    'capability' => 'edit_theme_options',
                )
                );
            
            $wp_customise->add_setting(
                'productive_business_off_canvas_logo',
                array(
                    'type' => 'theme_mod',
                    'default' => false,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_image'),
                )
                );
            
            // add control.
            $wp_customise->add_control(
                new WP_Customize_Media_Control(
                    $wp_customise,
                    'productive_business_off_canvas_logo',
                    array(
                        'priority' => 55,
                        'section' => 'productive_business_theme_global_popup',
                        'label' => esc_html__( 'Off Canvas Logo', 'productive-business' ),
                    )
                    )
                );
                
            $wp_customise->add_setting(
                'productive_business_off_canvas_logo_size',
                array(
                    'type' => 'theme_mod',
                    'default' => 40,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_absint'),
                )
            );
            $wp_customise->add_control(
                'productive_business_off_canvas_logo_size',
                array(
                    'type' => 'number',
                    'priority' => 56,
                    'section' => 'productive_business_theme_global_popup',
                    'label' => esc_html__( 'Off Canvas Logo Width (px)', 'productive-business' ),
                    'description' => esc_html__( 'Increases or decreases width in px - height adjusts automatically.', 'productive-business' ),
                    'input_attrs' => array(
                        'min' => 25,
                        'max' => 200,
                        'step' => 5,
                    ),
                )
            );
            
            // add a setting for productive_business_enable_global_popup_search control, below.
            $wp_customise->add_setting(
                'productive_business_enable_global_popup_search',
                array(
                    'type' => 'theme_mod',
                    'default' => true,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_checkbox'),
                )
                );
            // add control..
            $wp_customise->add_control(
                'productive_business_enable_global_popup_search',
                array(
                    'type' => 'checkbox',
                    'priority' => 60,
                    'section' => 'productive_business_theme_global_popup',
                    'label' => esc_html__( 'Display Search Box?', 'productive-business' ),
                    'description' => '',
                    // 'active_callback' => 'is_front_page',
                )
                );
            
            // add a setting for productive_business_enable_global_popup_account control, below.
            $wp_customise->add_setting(
                'productive_business_enable_global_popup_account',
                array(
                    'type' => 'theme_mod',
                    'default' => true,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_checkbox'),
                )
                );
            // add control..
            $wp_customise->add_control(
                'productive_business_enable_global_popup_account',
                array(
                    'type' => 'checkbox',
                    'priority' => 70,
                    'section' => 'productive_business_theme_global_popup',
                    'label' => esc_html__( 'Display My Account Icon?', 'productive-business' ),
                    'description' => '',
                    // 'active_callback' => 'is_front_page',
                )
                );

            // add a setting for productive_business_enable_global_popup_cart control, below.
            $wp_customise->add_setting(
                'productive_business_enable_global_popup_cart',
                array(
                    'type' => 'theme_mod',
                    'default' => true,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_checkbox'),
                )
            );
            // add control..
            $wp_customise->add_control(
                'productive_business_enable_global_popup_cart',
                array(
                    'type' => 'checkbox',
                    'priority' => 80,
                    'section' => 'productive_business_theme_global_popup',
                    'label' => esc_html__( 'Display Mini-Cart Icon?', 'productive-business' ),
                    'description' => esc_html__( 'Display Cart icon in the header', 'productive-business' ),
                    // 'active_callback' => 'is_front_page',
                )
                );

                // add a setting for productive_business_enable_global_popup_wishlist control, below.
            $wp_customise->add_setting(
                    'productive_business_enable_global_popup_wishlist',
                    array(
                        'type' => 'theme_mod',
                        'default' => true,
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_checkbox'),
                    )
            );
            // add control..
            $wp_customise->add_control(
                    'productive_business_enable_global_popup_wishlist',
                    array(
                        'type' => 'checkbox',
                        'priority' => 90,
                        'section' => 'productive_business_theme_global_popup',
                        'label' => esc_html__('Display Wishlist Icon?', 'productive-business'),
                        'description' => esc_html__('Display Wishlist icon in the header', 'productive-business'),
                    // 'active_callback' => 'is_front_page',
                    )
            );

            // add a setting for productive_business_enable_global_popup_compare control, below.
            $wp_customise->add_setting(
                    'productive_business_enable_global_popup_compare',
                    array(
                        'type' => 'theme_mod',
                        'default' => true,
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_checkbox'),
                    )
            );
            // add control..
            $wp_customise->add_control(
                    'productive_business_enable_global_popup_compare',
                    array(
                        'type' => 'checkbox',
                        'priority' => 100,
                        'section' => 'productive_business_theme_global_popup',
                        'label' => esc_html__('Display Compare Icon?', 'productive-business'),
                        'description' => esc_html__('Display product compare icon in the header', 'productive-business'),
                    // 'active_callback' => 'is_front_page',
                    )
            );

            if ( function_exists( 'productiveminds_theme_extra_is_active' ) || productive_business_power_button_required() ) {
                $wp_customise->add_setting(
                        'productive_business_enable_global_popup_power_button',
                        array(
                            'type' => 'theme_mod',
                            'default' => true,
                            'theme_supports' => '',
                            'transport' => 'refresh',
                            'capability' => 'edit_theme_options',
                            'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_checkbox'),
                        )
                );
                // add control..
                $wp_customise->add_control(
                        'productive_business_enable_global_popup_power_button',
                        array(
                            'type' => 'checkbox',
                            'priority' => 110,
                            'section' => 'productive_business_theme_global_popup',
                            'label' => esc_html__('Display Power Button?', 'productive-business'),
                            'description' => esc_html__('Note, this option is only effective, if power button is part of the current header design.', 'productive-business'),
                        // 'active_callback' => 'is_front_page',
                        )
                );
            }
            
            // add a setting for productive_business_enable_global_popup_fullscreen control, below.
            $wp_customise->add_setting(
                'productive_business_enable_global_popup_fullscreen',
                array(
                    'type' => 'theme_mod',
                    'default' => 'default_height',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_business_sanitize_select'),
                )
            );
            $wp_customise->add_control(
                'productive_business_enable_global_popup_fullscreen',
                array(
                    'type' => 'select',
                    'priority' => 200,
                    'section' => 'productive_business_theme_global_popup',
                    'label' => esc_html__( 'Popup Height', 'productive-business' ),
                    'description' => esc_html__( 'Select the preferred height of the popup.', 'productive-business' ),
                    'choices' => array(
                        'default_height' => esc_html__( 'Default Height', 'productive-business' ),
                        'fullscreen_height' => esc_html__( 'Fullscreen Height', 'productive-business' ),
                    ),
                )
            );
            
        }
        
        
    } // End of class.
    
    // add hook for the class.
    add_action( 'customize_register', array( 'Productive_Theme_Customiser_Global_Popup', 'register' ) );
    
} // End of if class exists



/**
 * Method productive_business_global_popup_style.
 *
 * @param string $class ''.
 */
function productive_business_global_popup_style( $class = '' ) {
    return get_theme_mod( 'productive_business_global_popup_style', PRODUCTIVE_BUSINESS_CURRENT_THEME_TEXT_DOMAIN );
}

/**
 * Method productive_business_global_popup_colour_mode.
 *
 * @param string $class ''.
 */
function productive_business_global_popup_colour_mode( $class = '' ) {
    return get_theme_mod( 'productive_business_global_popup_colour_mode', 'global_popup_colour_mode_dark' );
}

/**
 * Method productive_business_off_canvas_logo.
 *
 * @param string $class ''.
 */
function productive_business_off_canvas_logo() {
    return get_theme_mod( 'productive_business_off_canvas_logo', false );
}

function productive_business_render_off_canvas_logo( $class = '' ) {
    $thumbnail_id = productive_business_off_canvas_logo();
    if ( is_numeric($thumbnail_id) && intval($thumbnail_id) ) {
        $thumbnail_url = productive_global_get_attachment_url_by_attachment_id( $thumbnail_id, '' );
        $logo_size = productive_business_off_canvas_logo_size();
        ?>
        <div class="<?php echo $class; ?>">
            <a href="<?php echo esc_url( home_url() ); ?>">
                <img class="custom-logo" src="<?php echo esc_url( $thumbnail_url ); ?>" width="<?php echo esc_attr($logo_size); ?>px" height="auto" alt="<?php echo get_bloginfo( 'name', 'display' ); ?>" />
            </a>
        </div>
        <?php 
    } else {
        productive_business_the_custom_logo();
    }
}
add_action( 'productive_business_display_off_canvas_logo', 'productive_business_render_off_canvas_logo' );

/**
 * 
 * Method productive_business_off_canvas_logo_size.
 *
 * @param string $class ''.
 */
function productive_business_off_canvas_logo_size( $class = '' ) {
    return get_theme_mod( 'productive_business_off_canvas_logo_size', 40 );
}

/**
 * Method productive_business_enable_global_popup_search.
 *
 * @param string $class ''.
 */
function productive_business_enable_global_popup_search( $class = '' ) {
    return get_theme_mod( 'productive_business_enable_global_popup_search', true );
}
add_action( 'productive_business_display_enable_global_popup_search', 'productive_business_enable_global_popup_search' );

/**
 * Method productive_business_enable_global_popup_account.
 *
 * @param string $class ''.
 */
function productive_business_enable_global_popup_account( $class = '' ) {
    return get_theme_mod( 'productive_business_enable_global_popup_account', true );
}

/**
 * Method productive_business_enable_global_popup_cart.
 *
 * @param string $class ''.
 */
function productive_business_enable_global_popup_cart( $class = '' ) {
    return get_theme_mod( 'productive_business_enable_global_popup_cart', true );
}

/**
 * Method productive_business_enable_global_popup_wishlist.
 *
 * @param string $class ''.
 */
function productive_business_enable_global_popup_wishlist( $class = '' ) {
    return get_theme_mod( 'productive_business_enable_global_popup_wishlist', true );
}

/**
 * Method productive_business_enable_global_popup_compare.
 *
 * @param string $class ''.
 */
function productive_business_enable_global_popup_compare( $class = '' ) {
    return get_theme_mod( 'productive_business_enable_global_popup_compare', true );
}

/**
 * Method productive_business_enable_global_popup_power_button.
 *
 * @param string $class ''.
 */
function productive_business_enable_global_popup_power_button( $class = '' ) {
    if( productive_business_dispaly_power_button_in_global_popup() ) {
        return get_theme_mod( 'productive_business_enable_global_popup_power_button', true );
    } else {
        return false;
    }
}

/**
 * Method productive_business_enable_switch_language_global_popup.
 *
 * @param string $class ''.
 */
function productive_business_enable_switch_language_global_popup( $class = '' ) {
    return get_theme_mod( 'productive_business_enable_switch_language_global_popup', true );
}

/**
 * Method productive_business_enable_switch_currency_global_popup.
 *
 * @param string $class ''.
 */
function productive_business_enable_switch_currency_global_popup( $class = '' ) {
    return get_theme_mod( 'productive_business_enable_switch_currency_global_popup', true );
}

/**
 * Method productive_business_enable_global_popup_fullscreen.
 *
 * @param string $class ''.
 */
function productive_business_enable_global_popup_fullscreen( $class = '' ) {
    return get_theme_mod( 'productive_business_enable_global_popup_fullscreen', 'default_height' );
}