<?php 
/**
 * Template part for displaying Featured Classes Section
 *
 * @package Prime Yoga Classes
 */

$prime_yoga_classes_classes = get_theme_mod( 'prime_yoga_classes_classes_setting',false );
$prime_yoga_classes_section_title = get_theme_mod( 'prime_yoga_classes_section_title' );
$prime_yoga_classes_section_text = get_theme_mod( 'prime_yoga_classes_section_text' );
$prime_yoga_classes_hot_products_cat = get_theme_mod('prime_yoga_classes_hot_products_cat');
?>
<?php if ( $prime_yoga_classes_classes ){?>
<div class="our-classes">
    <div class="container">
        <?php if ( $prime_yoga_classes_section_title ){?>
            <h3 class="mb-0"><?php echo esc_html( $prime_yoga_classes_section_title );?></h3>
        <?php } ?>
        <?php if ( $prime_yoga_classes_section_text ){?>
            <p><?php echo esc_html( $prime_yoga_classes_section_text );?></p>
        <?php } ?>
        <?php if(class_exists('woocommerce')){ ?>
        <div class="owl-carousel">
            <?php
            $args = array(
              'post_type' => 'product',
              'posts_per_page' => 50,
              'product_cat' => get_theme_mod('prime_yoga_classes_hot_products_cat'),
              'order' => 'ASC'
            );
            $loop = new WP_Query( $args );
            while ( $loop->have_posts() ) : $loop->the_post(); global $product;
              $prime_yoga_classes_regular_price = $product->get_regular_price();
              $prime_yoga_classes_sale_price = $product->get_sale_price();
              ?>
                  <div class="product-image">
                    <?php
                      if (has_post_thumbnail($loop->post->ID)) {
                          echo get_the_post_thumbnail($loop->post->ID, 'shop_catalog');
                      } else {
                          echo '<img src="' . esc_url(wc_placeholder_img_src()) . '" alt="" />';
                      }
                    ?>
                    <div class="box-content text-center">
                      <h3 class="product-text">
                        <a href="<?php echo esc_url(get_permalink( $loop->post->ID )); ?>">
                          <?php the_title(); ?>
                        </a>
                      </h3>
                      <div class="price mb-2"><?php echo $product->get_price_html(); ?></div>
                      <div class="addcartbtn mb-2">
                        <?php
                          if( $product->is_type( 'simple' ) ){
                            // Simple "Add to Cart" button
                            echo apply_filters( 'woocommerce_loop_add_to_cart_link',
                              sprintf( '<a href="%s" data-quantity="%s" class="button product_type_simple add_to_cart_button">%s</a>',
                                esc_url( $product->add_to_cart_url() ),
                                esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
                                esc_html__( 'Add to Cart', 'prime-yoga-classes' )
                              ),
                            $product );
                            // View Cart button (hidden by default)
                            echo sprintf( '<a href="%s" class="button wc-forward view-cart-button" style="display:none;">%s</a>',
                                esc_url( wc_get_cart_url() ),
                                esc_html__( 'View Cart', 'prime-yoga-classes' )
                            );
                          }
                        ?>
                      </div>
                    </div>
                  </div>
            <?php endwhile; 
            wp_reset_postdata(); ?>
        </div>
        <?php }?>
    </div>
</div>
<?php } ?>