<?php
/**
 * Help Panel.
 *
 * @package prime_yoga_classes
 */
?>

<div id="help-panel" class="panel-left visible">

    <div class="panel-aside active">
        <h4><?php printf( esc_html__( ' DEMO CONTENT IMPORTER', 'prime-yoga-classes' )); ?></h4>
        <p><?php esc_html_e( 'Your journey to a powerful and stylish website begins here. Let’s get everything set up in just a few clicks!', 'prime-yoga-classes' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url(admin_url('themes.php?page=primeyogaclasses-wizard')); ?>" title="<?php esc_attr_e( 'Demo Importer', 'prime-yoga-classes' ); ?>" target="_blank">
            <?php esc_html_e( 'DEMO IMPORTER', 'prime-yoga-classes' ); ?>
        </a>
    </div>

    <div class="panel-aside">
        <h4><?php printf( esc_html__( ' VISIT FREE DOCUMENTATION', 'prime-yoga-classes' )); ?></h4>
        <p><?php esc_html_e( 'Are you a newcomer to the WordPress universe? Our comprehensive and user-friendly documentation guide is designed to assist you in effortlessly building a captivating and interactive website, even if you lack any coding expertise or prior experience. Follow our step-by-step instructions to create a visually appealing and engaging online presence.', 'prime-yoga-classes' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( 'https://demo.themeignite.com/documentation/prime-yoga-classes-free/' ); ?>" title="<?php esc_attr_e( 'Visit the Documentation', 'prime-yoga-classes' ); ?>" target="_blank">
            <?php esc_html_e( 'FREE DOCUMENTATION', 'prime-yoga-classes' ); ?>
        </a>
    </div>

    <div class="panel-aside">
        <h4><?php esc_html_e( 'REVIEW', 'prime-yoga-classes' ); ?></h4>
        <p><?php esc_html_e( 'If you are passionate about the Prime Yoga Classes theme, we would love to hear your thoughts and feedback regarding our theme. Your review will be highly valuable to us as we strive to enhance and improve our theme based on the needs and preferences of our users. Your opinion matters, and we sincerely appreciate your time and effort in sharing your experience with the Prime Yoga Classes theme.', 'prime-yoga-classes' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( 'https://wordpress.org/support/theme/prime-yoga-classes/reviews/#new-post' ); ?>" title="<?php esc_attr_e( 'Visit the Review', 'prime-yoga-classes' ); ?>" target="_blank">
            <?php esc_html_e( 'REVIEW', 'prime-yoga-classes' ); ?>
        </a>
    </div>
    
    <div class="panel-aside">
        <h4><?php esc_html_e( 'CONTACT SUPPORT', 'prime-yoga-classes' ); ?></h4>
        <p>
            <?php esc_html_e( 'Thank you for choosing Prime Yoga Classes! We appreciate your interest in our theme and are here to assist you with any support you may need.', 'prime-yoga-classes' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( 'https://wordpress.org/support/theme/prime-yoga-classes/' ); ?>" title="<?php esc_attr_e( 'Visit the Support', 'prime-yoga-classes' ); ?>" target="_blank">
            <?php esc_html_e( 'CONTACT SUPPORT', 'prime-yoga-classes' ); ?>
        </a>
    </div>
</div>