<?php
/**
 * Prime Yoga Classes Theme Customizer.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package prime_yoga_classes
 */

if( ! function_exists( 'prime_yoga_classes_customize_register' ) ):  
/**
 * Add postMessage support for site title and description for the Theme Customizer.F
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function prime_yoga_classes_customize_register( $wp_customize ) {
    require get_parent_theme_file_path('/inc/controls/changeable-icon.php');

    require get_parent_theme_file_path('/inc/controls/sortable-control.php');
    
    //Register the sortable control type.
    $wp_customize->register_control_type( 'Prime_Yoga_Classes_Control_Sortable' ); 

    if ( version_compare( get_bloginfo('version'),'4.9', '>=') ) {
        $wp_customize->get_section( 'static_front_page' )->title = __( 'Static Front Page', 'prime-yoga-classes' );
    }
	
    /* Option list of all post */	
    $prime_yoga_classes_options_posts = array();
    $prime_yoga_classes_options_posts_obj = get_posts('posts_per_page=-1');
    $prime_yoga_classes_options_posts[''] = esc_html__( 'Choose Post', 'prime-yoga-classes' );
    foreach ( $prime_yoga_classes_options_posts_obj as $prime_yoga_classes_posts ) {
    	$prime_yoga_classes_options_posts[$prime_yoga_classes_posts->ID] = $prime_yoga_classes_posts->post_title;
    }
    
    /* Option list of all categories */
    $prime_yoga_classes_args = array(
	   'type'                     => 'post',
	   'orderby'                  => 'name',
	   'order'                    => 'ASC',
	   'hide_empty'               => 1,
	   'hierarchical'             => 1,
	   'taxonomy'                 => 'category'
    ); 
    $prime_yoga_classes_option_categories = array();
    $prime_yoga_classes_category_lists = get_categories( $prime_yoga_classes_args );
    $prime_yoga_classes_option_categories[''] = esc_html__( 'Choose Category', 'prime-yoga-classes' );
    foreach( $prime_yoga_classes_category_lists as $prime_yoga_classes_category ){
        $prime_yoga_classes_option_categories[$prime_yoga_classes_category->term_id] = $prime_yoga_classes_category->name;
    }
    
    /** Default Settings */    
    $wp_customize->add_panel( 
        'wp_default_panel',
         array(
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => esc_html__( 'Default Settings', 'prime-yoga-classes' ),
            'description' => esc_html__( 'Default section provided by wordpress customizer.', 'prime-yoga-classes' ),
        ) 
    );
    
    $wp_customize->get_section( 'title_tagline' )->panel                  = 'wp_default_panel';
    $wp_customize->get_section( 'colors' )->panel                         = 'wp_default_panel';
    $wp_customize->get_section( 'header_image' )->panel                   = 'wp_default_panel';
    $wp_customize->get_section( 'background_image' )->panel               = 'wp_default_panel';
    $wp_customize->get_section( 'static_front_page' )->panel              = 'wp_default_panel';
    
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    
    /** Default Settings Ends */
    
    /** Site Title control */
    $wp_customize->add_setting( 
        'header_site_title', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_site_title',
        array(
            'label'       => __( 'Show / Hide Site Title', 'prime-yoga-classes' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    /** Tagline control */
    $wp_customize->add_setting( 
        'header_tagline', 
        array(
            'default'           => false,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_tagline',
        array(
            'label'       => __( 'Show / Hide Tagline', 'prime-yoga-classes' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('logo_width', array(
        'sanitize_callback' => 'absint', 
    ));

    // Add a control for logo width
    $wp_customize->add_control('logo_width', array(
        'label' => __('Logo Width', 'prime-yoga-classes'),
        'section' => 'title_tagline',
        'type' => 'number',
        'input_attrs' => array(
            'min' => '50', 
            'max' => '500', 
            'step' => '5', 
    ),
        'default' => '100', 
    ));

    $wp_customize->add_setting( 'prime_yoga_classes_site_title_size', array(
        'default'           => 30, // Default font size in pixels
        'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
    ) );

    // Add control for site title size
    $wp_customize->add_control( 'prime_yoga_classes_site_title_size', array(
        'type'        => 'number',
        'section'     => 'title_tagline', // You can change this section to your preferred section
        'label'       => __( 'Site Title Font Size (px)', 'prime-yoga-classes' ),
        'input_attrs' => array(
            'min'  => 10,
            'max'  => 100,
            'step' => 1,
        ),
    ) );

    /** Responsive Media settings */
    
    $wp_customize->add_section(
        'prime_yoga_classes_responsive_media_section',
        array(
            'title' => esc_html__( 'Responsive Media Settings', 'prime-yoga-classes' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_yoga_classes_home_general_settings',
        )
    );

    /** Scroll to top Responsive control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_resp_scroll_top', 
        array(
            'default' => 1,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_resp_scroll_top',
        array(
            'label'       => __( 'Show Scroll To Top', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_responsive_media_section',
            'type'        => 'checkbox',
        )
    );

        /** Scroll to top Responsive control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_resp_loader', 
        array(
            'default' => 0,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_resp_loader',
        array(
            'label'       => __( 'Show Preloader', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_responsive_media_section',
            'type'        => 'checkbox',
        )
    );

    /** Responsive Media Ends */

    //Global Color
    $wp_customize->add_section(
        'prime_yoga_classes_global_color',
        array(
            'title' => esc_html__( 'Global Color Settings', 'prime-yoga-classes' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_yoga_classes_home_general_settings',
        )
    );

    $wp_customize->add_setting('prime_yoga_classes_primary_color', array(
        'default'           => '#e11b58',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'prime_yoga_classes_primary_color', array(
        'label'    => __('Theme Primary Color', 'prime-yoga-classes'),
        'section'  => 'prime_yoga_classes_global_color',
        'settings' => 'prime_yoga_classes_primary_color',
    )));    

    $wp_customize->add_setting('prime_yoga_classes_second_color', array(
        'default'           => '#00E7D7',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'prime_yoga_classes_second_color', array(
        'label'    => __('Theme Secondary Color', 'prime-yoga-classes'),
        'section'  => 'prime_yoga_classes_global_color',
        'settings' => 'prime_yoga_classes_second_color',
    )));

    /** Post & Pages Settings */
    $wp_customize->add_panel( 
        'prime_yoga_classes_home_post_settings',
         array(
            'priority' => 40,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Post & Pages Settings', 'prime-yoga-classes' ),
            'description' => esc_html__( 'Customize Post & Pages Settings', 'prime-yoga-classes' ),
        ) 
    );
    
    /** Post Layouts */
    
    $wp_customize->add_section(
        'prime_yoga_classes_post_layout_section',
        array(
            'title' => esc_html__( 'Post Layout Settings', 'prime-yoga-classes' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_yoga_classes_home_post_settings',
        )
    );

    $wp_customize->add_setting('prime_yoga_classes_post_layout_setting', array(
        'default'           => 'right-sidebar',
        'sanitize_callback' => 'prime_yoga_classes_sanitize_post_layout',
    ));

    $wp_customize->add_control('prime_yoga_classes_post_layout_setting', array(
        'label'    => __('Post Column Settings', 'prime-yoga-classes'),
        'section'  => 'prime_yoga_classes_post_layout_section',
        'settings' => 'prime_yoga_classes_post_layout_setting',
        'type'     => 'select',
        'choices'  => array(
            'one-column'   => __('One Column', 'prime-yoga-classes'),
            'right-sidebar'   => __('Right Sidebar', 'prime-yoga-classes'),
            'left-sidebar'   => __('Left Sidebar', 'prime-yoga-classes'),
            'three-column'   => __('Three Columns', 'prime-yoga-classes'),
            'four-column'   => __('Four Columns', 'prime-yoga-classes'),
        ),
    ));

    $wp_customize->add_setting('prime_yoga_classes_archive_pagination_alignment',array(
        'default' => 'left-align',
        'sanitize_callback' => 'prime_yoga_classes_sanitize_pagination_alignment'
    ));
    $wp_customize->add_control('prime_yoga_classes_archive_pagination_alignment',array(
        'type' => 'select',
        'label' => __('Pagination Alignment','prime-yoga-classes'),
        'section' => 'prime_yoga_classes_post_layout_section',
        'choices' => array(
            'right-align' => __('Right Alignment','prime-yoga-classes'),
            'center-align' => __('Center Alignment','prime-yoga-classes'),
            'left-align' => __('Left Alignment','prime-yoga-classes'),
        ),
    ) );

     /** Post Layouts Ends */

    /** Post Settings */
    $wp_customize->add_section(
        'prime_yoga_classes_post_settings',
        array(
            'title' => esc_html__( 'Post Settings', 'prime-yoga-classes' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_yoga_classes_home_post_settings',
        )
    );

    /** Post Heading control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_post_heading_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_post_heading_setting',
        array(
            'label'       => __( 'Show / Hide Post Heading', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Meta control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Post Meta', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Image control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_post_image_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_post_image_setting',
        array(
            'label'       => __( 'Show / Hide Post Image', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Content control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Post Content', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_post_settings',
            'type'        => 'checkbox',
        )
    );
    /** Post ReadMore control */
     $wp_customize->add_setting( 'prime_yoga_classes_read_more_setting', array(
        'default'           => true,
        'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
    ) );

    $wp_customize->add_control( 'prime_yoga_classes_read_more_setting', array(
        'type'        => 'checkbox',
        'section'     => 'prime_yoga_classes_post_settings', 
        'label'       => __( 'Display Read More Button', 'prime-yoga-classes' ),
    ) );

        $wp_customize->add_setting('prime_yoga_classes_single_post_align',array(
        'default' => 'left-align',
        'sanitize_callback' => 'prime_yoga_classes_sanitize_single_post_align'
    ));
    $wp_customize->add_control('prime_yoga_classes_single_post_align',array(
        'type' => 'select',
        'label' => __('Post Content Alignment','prime-yoga-classes'),
        'section' => 'prime_yoga_classes_post_settings',
        'choices' => array(
            'left-align' => __('Left Alignment','prime-yoga-classes'),
            'right-align' => __('Right Alignment','prime-yoga-classes'),
            'center-align' => __('Center Alignment','prime-yoga-classes'),
        ),
    ) );

    $wp_customize->add_setting('prime_yoga_classes_blog_meta_order', array(
        'default' => array('heading', 'author', 'featured-image', 'content','button'),
        'sanitize_callback' => 'prime_yoga_classes_sanitize_sortable',
    ));
    $wp_customize->add_control(new Prime_Yoga_Classes_Control_Sortable($wp_customize, 'prime_yoga_classes_blog_meta_order', array(
        'label' => esc_html__('Post Meta Ordering', 'prime-yoga-classes'),
        'description' => __('Drag & drop post items to rearrange the ordering ( this control will not function by post format )', 'prime-yoga-classes') ,
        'section' => 'prime_yoga_classes_post_settings',
        'choices' => array(
            'heading' => __('heading', 'prime-yoga-classes') ,
            'author' => __('author', 'prime-yoga-classes') ,
            'featured-image' => __('featured-image', 'prime-yoga-classes') ,
            'content' => __('content', 'prime-yoga-classes') ,
            'button' => __('button', 'prime-yoga-classes') ,
        ) ,
    )));

    /** Post Settings Ends */

     /** Single Post Settings */
    $wp_customize->add_section(
        'prime_yoga_classes_single_post_settings',
        array(
            'title' => esc_html__( 'Single Post Settings', 'prime-yoga-classes' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_yoga_classes_home_post_settings',
        )
    );

    /** Single Post Meta control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_single_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_single_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Meta', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Content control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_single_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_single_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Content', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Settings Ends */

         // Typography Settings Section
    $wp_customize->add_section('prime_yoga_classes_typography_settings', array(
        'title'      => esc_html__('Typography Settings', 'prime-yoga-classes'),
        'priority'   => 30,
        'capability' => 'edit_theme_options',
        'panel' => 'prime_yoga_classes_home_general_settings',
    ));

    // Array of fonts to choose from
    $font_choices = array(
        ''               => __('Select', 'prime-yoga-classes'),
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Roboto'         => 'Roboto, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
        'Libre Baskerville' => 'Libre Baskerville',
    );

    // Heading Font Setting
    $wp_customize->add_setting('prime_yoga_classes_heading_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'prime_yoga_classes_sanitize_choicess',
    ));
    $wp_customize->add_control('prime_yoga_classes_heading_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Heading', 'prime-yoga-classes'),
        'section' => 'prime_yoga_classes_typography_settings',
    ));

    // Body Font Setting
    $wp_customize->add_setting('prime_yoga_classes_body_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'prime_yoga_classes_sanitize_choicess',
    ));
    $wp_customize->add_control('prime_yoga_classes_body_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Body', 'prime-yoga-classes'),
        'section' => 'prime_yoga_classes_typography_settings',
    ));

    /** Typography Settings Section End */

    /** General Settings */
    $wp_customize->add_panel( 
        'prime_yoga_classes_home_general_settings',
         array(
            'priority' => 40,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'General Settings', 'prime-yoga-classes' ),
            'description' => esc_html__( 'Customize General Settings', 'prime-yoga-classes' ),
        ) 
    );

    /** General Settings */
    $wp_customize->add_section(
        'prime_yoga_classes_general_settings',
        array(
            'title' => esc_html__( 'Loader Settings', 'prime-yoga-classes' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_yoga_classes_home_general_settings',
        )
    );

    /** Preloader control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_header_preloader', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_header_preloader',
        array(
            'label'       => __( 'Show Preloader', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_general_settings',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('prime_yoga_classes_theme_width',array(
        'default' => 'full-width',
        'sanitize_callback' => 'prime_yoga_classes_sanitize_theme_width'
    ));
    $wp_customize->add_control('prime_yoga_classes_theme_width',array(
        'type' => 'select',
        'label' => __('Theme Width Option','prime-yoga-classes'),
        'section' => 'prime_yoga_classes_general_settings',
        'choices' => array(
            'full-width' => __('Fullwidth','prime-yoga-classes'),
            'container' => __('Container','prime-yoga-classes'),
            'container-fluid' => __('Container Fluid','prime-yoga-classes'),
        ),
    ) );

    /** Header Section Settings */
    $wp_customize->add_section(
        'prime_yoga_classes_header_section_settings',
        array(
            'title' => esc_html__( 'Header Section Settings', 'prime-yoga-classes' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_yoga_classes_home_page_settings',
        )
    );

    /** Header Section control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_header_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_header_setting',
        array(
            'label'       => __( 'Show Header', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_header_section_settings',
            'type'        => 'checkbox',
        )
    );

     /** Phone */
    $wp_customize->add_setting(
        'prime_yoga_classes_header_phone',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_yoga_classes_header_phone',
        array(
            'label' => esc_html__( 'Add Phone', 'prime-yoga-classes' ),
            'section' => 'prime_yoga_classes_header_section_settings',
            'type' => 'text',
        )
    );
    $wp_customize->add_setting('prime_yoga_classes_phone_icon',array(
        'default'   => 'fas fa-phone-volume',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Prime_Yoga_Classes_Changeable_Icon(
        $wp_customize,'prime_yoga_classes_phone_icon',array(
        'label' => __('Phone Icon','prime-yoga-classes'),
        'transport' => 'refresh',
        'section'   => 'prime_yoga_classes_header_section_settings',
        'type'      => 'icon'
    )));

     /** Email */
    $wp_customize->add_setting(
        'prime_yoga_classes_header_email',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_yoga_classes_header_email',
        array(
            'label' => esc_html__( 'Add Email', 'prime-yoga-classes' ),
            'section' => 'prime_yoga_classes_header_section_settings',
            'type' => 'text',
        )
    );

    $wp_customize->add_setting('prime_yoga_classes_mail_icon',array(
        'default'   => 'fas fa-envelope',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Prime_Yoga_Classes_Changeable_Icon(
        $wp_customize,'prime_yoga_classes_mail_icon',array(
        'label' => __('Mail Icon','prime-yoga-classes'),
        'transport' => 'refresh',
        'section'   => 'prime_yoga_classes_header_section_settings',
        'type'      => 'icon'
    )));

    /**  TIMING */
    $wp_customize->add_setting(
        'prime_yoga_classes_header_location',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_yoga_classes_header_location',
        array(
            'label' => esc_html__( 'Add Timming', 'prime-yoga-classes' ),
            'section' => 'prime_yoga_classes_header_section_settings',
            'type' => 'text',
        )
    );

    $wp_customize->add_setting('prime_yoga_classes_marker_icon',array(
        'default'   => 'far fa-clock',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Prime_Yoga_Classes_Changeable_Icon(
        $wp_customize,'prime_yoga_classes_marker_icon',array(
        'label' => __('Timming Icon','prime-yoga-classes'),
        'transport' => 'refresh',
        'section'   => 'prime_yoga_classes_header_section_settings',
        'type'      => 'icon'
    )));

    /** Sticky Header control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_sticky_header', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_sticky_header',
        array(
            'label'       => __( 'Show Sticky Header', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_header_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Add Setting for Menu Font Weight
    $wp_customize->add_setting( 'prime_yoga_classes_menu_font_weight', array(
        'default'           => '500',
        'sanitize_callback' => 'prime_yoga_classes_sanitize_font_weight',
    ) );

    // Add Control for Menu Font Weight
    $wp_customize->add_control( 'prime_yoga_classes_menu_font_weight', array(
        'label'    => __( 'Menu Font Weight', 'prime-yoga-classes' ),
        'section'  => 'prime_yoga_classes_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            '100' => __( '100 - Thin', 'prime-yoga-classes' ),
            '200' => __( '200 - Extra Light', 'prime-yoga-classes' ),
            '300' => __( '300 - Light', 'prime-yoga-classes' ),
            '400' => __( '400 - Normal', 'prime-yoga-classes' ),
            '500' => __( '500 - Medium', 'prime-yoga-classes' ),
            '600' => __( '600 - Semi Bold', 'prime-yoga-classes' ),
            '700' => __( '700 - Bold', 'prime-yoga-classes' ),
            '800' => __( '800 - Extra Bold', 'prime-yoga-classes' ),
            '900' => __( '900 - Black', 'prime-yoga-classes' ),
        ),
    ) );

    // Add Setting for Menu Text Transform
    $wp_customize->add_setting( 'prime_yoga_classes_menu_text_transform', array(
        'default'           => 'capitalize',
        'sanitize_callback' => 'prime_yoga_classes_sanitize_text_transform',
    ) );

    // Add Control for Menu Text Transform
    $wp_customize->add_control( 'prime_yoga_classes_menu_text_transform', array(
        'label'    => __( 'Menu Text Transform', 'prime-yoga-classes' ),
        'section'  => 'prime_yoga_classes_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            'none'       => __( 'None', 'prime-yoga-classes' ),
            'capitalize' => __( 'Capitalize', 'prime-yoga-classes' ),
            'uppercase'  => __( 'Uppercase', 'prime-yoga-classes' ),
            'lowercase'  => __( 'Lowercase', 'prime-yoga-classes' ),
        ),
    ) );

    // Menu Hover Style	
    $wp_customize->add_setting('prime_yoga_classes_menus_style',array(
        'default' => '',
        'sanitize_callback' => 'prime_yoga_classes_sanitize_choices'
	));
	$wp_customize->add_control('prime_yoga_classes_menus_style',array(
        'type' => 'select',
		'label' => __('Menu Hover Style','prime-yoga-classes'),
		'section' => 'prime_yoga_classes_header_section_settings',
		'choices' => array(
         'None' => __('None','prime-yoga-classes'),
         'Zoom In' => __('Zoom In','prime-yoga-classes'),
      ),
	));

    /** Home Page Settings */
    $wp_customize->add_panel( 
        'prime_yoga_classes_home_page_settings',
         array(
            'priority' => 9,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Home Page Settings', 'prime-yoga-classes' ),
            'description' => esc_html__( 'Customize Home Page Settings', 'prime-yoga-classes' ),
        ) 
    );

    /** Slider Section Settings */
    $wp_customize->add_section(
        'prime_yoga_classes_slider_section_settings',
        array(
            'title' => esc_html__( 'Slider Section Settings', 'prime-yoga-classes' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_yoga_classes_home_page_settings',
        )
    );

    /** Slider Section control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_slider_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_slider_setting',
        array(
            'label'       => __( 'Show Slider', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_slider_section_settings',
            'type'        => 'checkbox',
        )
    );
    
    $categories = get_categories();
        $cat_posts = array();
            $i = 0;
            $cat_posts[]='Select';
        foreach($categories as $category){
            if($i==0){
            $default = $category->slug;
            $i++;
        }
        $cat_posts[$category->slug] = $category->name;
    }

    $wp_customize->add_setting(
        'prime_yoga_classes_blog_slide_category',
        array(
            'default'   => 'select',
            'sanitize_callback' => 'prime_yoga_classes_sanitize_choices',
        )
    );
    $wp_customize->add_control(
        'prime_yoga_classes_blog_slide_category',
        array(
            'type'    => 'select',
            'choices' => $cat_posts,
            'label' => __('Select Category to display Latest Post','prime-yoga-classes'),
            'section' => 'prime_yoga_classes_slider_section_settings',
        )
    );

    /** Classes Section Settings */
    $wp_customize->add_section(
        'prime_yoga_classes_classes_section_settings',
        array(
            'title' => esc_html__( 'Product Section Settings', 'prime-yoga-classes' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_yoga_classes_home_page_settings',
        )
    );

    /** Classes Section control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_classes_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_classes_setting',
        array(
            'label'       => __( 'Show product Section', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_classes_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Section Title
    $wp_customize->add_setting(
        'prime_yoga_classes_section_title', 
        array(
            'default'           => '',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',    
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'prime_yoga_classes_section_title', 
        array(
            'label'       => __('Section Title', 'prime-yoga-classes'),
            'section'     => 'prime_yoga_classes_classes_section_settings',
            'settings'    => 'prime_yoga_classes_section_title',
            'type'        => 'text'
        )
    );

    // Section Text
    $wp_customize->add_setting(
        'prime_yoga_classes_section_text', 
        array(
            'default'           => '',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',    
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'prime_yoga_classes_section_text', 
        array(
            'label'       => __('Section Text', 'prime-yoga-classes'),
            'section'     => 'prime_yoga_classes_classes_section_settings',
            'settings'    => 'prime_yoga_classes_section_text',
            'type'        => 'text'
        )
    );

    $args = array(
        'type'                     => 'product',
        'child_of'                 => 0,
        'parent'                   => '',
        'orderby'                  => 'term_group',
        'order'                    => 'ASC',
        'hide_empty'               => false,
        'hierarchical'             => 1,
        'number'                   => '',
        'taxonomy'                 => 'product_cat',
        'pad_counts'               => false
    );
    $categories = get_categories($args);
    $cat_posts = array();
    $m = 0;
    $cat_posts[]='Select';
    foreach($categories as $category){
        if($m==0){
            $default = $category->slug;
            $m++;
        }
        $cat_posts[$category->slug] = $category->name;
    }

    $wp_customize->add_setting('prime_yoga_classes_hot_products_cat',array(
        'default'   => 'select',
        'sanitize_callback' => 'prime_yoga_classes_sanitize_choices',
    ));
    $wp_customize->add_control('prime_yoga_classes_hot_products_cat',array(
        'type'    => 'select',
        'choices' => $cat_posts,
        'label' => __('Select category to display products ','prime-yoga-classes'),
        'section' => 'prime_yoga_classes_classes_section_settings',
    ));
    
    /** Home Page Settings Ends */
    
    /** Footer Section */
    $wp_customize->add_section(
        'prime_yoga_classes_footer_section',
        array(
            'title' => __( 'Footer Settings', 'prime-yoga-classes' ),
            'priority' => 70,
            'panel' => 'prime_yoga_classes_home_page_settings',
        )
    );

    /** Footer Widget Columns */
    $wp_customize->add_setting('prime_yoga_classes_footer_widget_areas', array(
        'default'           => 4,
        'sanitize_callback' => 'prime_yoga_classes_sanitize_choices',
    ));

    $wp_customize->add_control('prime_yoga_classes_footer_widget_areas', array(
        'label'    => __('Footer Widget Columns', 'prime-yoga-classes'),
        'section'  => 'prime_yoga_classes_footer_section',
        'settings' => 'prime_yoga_classes_footer_widget_areas',
        'type'     => 'select',
        'choices'  => array(
		   '1'     => __('One', 'prime-yoga-classes'),
		   '2'     => __('Two', 'prime-yoga-classes'),
		   '3'     => __('Three', 'prime-yoga-classes'),
		   '4'     => __('Four', 'prime-yoga-classes')
        ),
    ));

    /** Footer Copyright control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_footer_setting', 
        array(
            'default' => true,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_footer_setting',
        array(
            'label'       => __( 'Show Footer Copyright', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_footer_section',
            'type'        => 'checkbox',
        )
    );
    
    /** Copyright Text */
    $wp_customize->add_setting(
        'prime_yoga_classes_footer_copyright_text',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'prime_yoga_classes_footer_copyright_text',
        array(
            'label' => __( 'Copyright Info', 'prime-yoga-classes' ),
            'section' => 'prime_yoga_classes_footer_section',
            'type' => 'text',
        )
    );  
$wp_customize->add_setting('prime_yoga_classes_footer_background_image',
        array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
        )
    );


    $wp_customize->add_control(
         new WP_Customize_Cropped_Image_Control($wp_customize, 'prime_yoga_classes_footer_background_image',
            array(
                'label' => esc_html__('Footer Background Image', 'prime-yoga-classes'),
                'description' => sprintf(esc_html__('Recommended Size %1$s px X %2$s px', 'prime-yoga-classes'), 1024, 800),
                'section' => 'prime_yoga_classes_footer_section',
                'width' => 1024,
                'height' => 800,
                'flex_width' => true,
                'flex_height' => true,
            )
        )
    );

    /** Footer Background Image Attachment */
    $wp_customize->add_setting('prime_yoga_classes_background_attachment', array(
        'default'           => 'scroll',
        'sanitize_callback' => 'prime_yoga_classes_sanitize_choices',
    ));

    $wp_customize->add_control('prime_yoga_classes_background_attachment', array(
        'label'    => __('Footer Background Attachment', 'prime-yoga-classes'),
        'section'  => 'prime_yoga_classes_footer_section',
        'settings' => 'prime_yoga_classes_background_attachment',
        'type'     => 'select',
        'choices'  => array(
            'fixed' => __('fixed','prime-yoga-classes'),
            'scroll' => __('scroll','prime-yoga-classes'),
        ),
    ));

    /* Footer Background Color*/
    $wp_customize->add_setting(
        'prime_yoga_classes_footer_background_color',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'prime_yoga_classes_footer_background_color',
            array(
                'label' => __('Footer Widget Area Background Color', 'prime-yoga-classes'),
                'section' => 'prime_yoga_classes_footer_section',
                'type' => 'color',
            )
        )
    );

    /** Scroll to top control */
    $wp_customize->add_setting( 
        'prime_yoga_classes_scroll_to_top', 
        array(
            'default' => 1,
            'sanitize_callback' => 'prime_yoga_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_yoga_classes_scroll_to_top',
        array(
            'label'       => __( 'Show Scroll To Top', 'prime-yoga-classes' ),
            'section'     => 'prime_yoga_classes_footer_section',
            'type'        => 'checkbox',
        )
    );

     $wp_customize->add_setting('prime_yoga_classes_scroll_icon',array(
        'default'   => 'fas fa-arrow-up',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Prime_Yoga_Classes_Changeable_Icon(
        $wp_customize,'prime_yoga_classes_scroll_icon',array(
        'label' => __('Scroll Top Icon','prime-yoga-classes'),
        'transport' => 'refresh',
        'section'   => 'prime_yoga_classes_footer_section',
        'type'      => 'icon'
    )));

    $wp_customize->add_setting('prime_yoga_classes_scroll_top_alignment',array(
        'default' => 'right-align',
        'sanitize_callback' => 'prime_yoga_classes_sanitize_scroll_top_alignment'
    ));
    $wp_customize->add_control('prime_yoga_classes_scroll_top_alignment',array(
        'type' => 'select',
        'label' => __('Scroll Top Alignment','prime-yoga-classes'),
        'section' => 'prime_yoga_classes_footer_section',
        'choices' => array(
            'right-align' => __('Right Alignment','prime-yoga-classes'),
            'center-align' => __('Center Alignment','prime-yoga-classes'),
            'left-align' => __('Left Alignment','prime-yoga-classes'),
        ),
    ) );

    /** Scroll to top button shape */
    $wp_customize->add_setting('prime_yoga_classes_scroll_to_top_radius', array(
        'default'           => 'curved-box',
        'sanitize_callback' => 'prime_yoga_classes_sanitize_choices',
    ));

    $wp_customize->add_control('prime_yoga_classes_scroll_to_top_radius', array(
        'label'    => __('Scroll Top Button Shape', 'prime-yoga-classes'),
        'section'  => 'prime_yoga_classes_footer_section',
        'settings' => 'prime_yoga_classes_scroll_to_top_radius',
        'type'     => 'select',
        'choices'  => array(
            'box'        => __( 'Box', 'prime-yoga-classes' ),
            'curved-box' => __( 'Curved Box', 'prime-yoga-classes' ),
            'circle'     => __( 'Circle', 'prime-yoga-classes' ),
        ),
    ));

    // 404 PAGE SETTINGS
    $wp_customize->add_section(
        'prime_yoga_classes_404_section',
        array(
            'title' => __( '404 Page Settings', 'prime-yoga-classes' ),
            'priority' => 70,
            'panel' => 'prime_yoga_classes_home_general_settings',
        )
    );
   
    $wp_customize->add_setting('404_page_image', array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'esc_url_raw', // Sanitize as URL
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, '404_page_image', array(
        'label' => __('404 Page Image', 'prime-yoga-classes'),
        'section' => 'prime_yoga_classes_404_section',
        'settings' => '404_page_image',
    )));

    $wp_customize->add_setting('404_pagefirst_header', array(
        'default' => __('404', 'prime-yoga-classes'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_pagefirst_header', array(
        'type' => 'text',
        'label' => __('Heading', 'prime-yoga-classes'),
        'section' => 'prime_yoga_classes_404_section',
    ));

    // Setting for 404 page header
    $wp_customize->add_setting('404_page_header', array(
        'default' => __('Sorry, that page can\'t be found!', 'prime-yoga-classes'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_page_header', array(
        'type' => 'text',
        'label' => __('Heading', 'prime-yoga-classes'),
        'section' => 'prime_yoga_classes_404_section',
    ));
}
add_action( 'customize_register', 'prime_yoga_classes_customize_register' );
endif;

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function prime_yoga_classes_customize_preview_js() {
    // Use minified libraries if SCRIPT_DEBUG is false
    $prime_yoga_classes_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $prime_yoga_classes_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_script( 'prime_yoga_classes_customizer', get_template_directory_uri() . '/js' . $prime_yoga_classes_build . '/customizer' . $prime_yoga_classes_suffix . '.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'prime_yoga_classes_customize_preview_js' );