<?php
/**
 * Template part for displaying Slider Section
 *
 * @package prime-software-company
 */

$prime_software_company_data_slick_speed = prime_software_company_get_option('data_slick_speed');
$prime_software_company_data_slick_infinite = prime_software_company_get_option('data_slick_infinite');
$prime_software_company_data_slick_dots = prime_software_company_get_option('data_slick_dots');
$prime_software_company_data_slick_autoplay = prime_software_company_get_option('data_slick_autoplay');
$prime_software_company_data_slick_draggable = prime_software_company_get_option('data_slick_draggable');
$prime_software_company_data_slick_fade = prime_software_company_get_option('data_slick_fade');
$prime_software_company_featured_slider_content_type = prime_software_company_get_option('featured_slider_content_type');
$prime_software_company_number_of_featured_slider_items = prime_software_company_get_option('number_of_featured_slider_items');

    $prime_software_company_featured_slider_section_heading          = prime_software_company_get_option( 'featured_slider_section_heading' );

?>


<?php
// Convert numeric options to boolean strings for slick carousel
$prime_software_company_data_slick_infinite = $prime_software_company_data_slick_infinite ? 'true' : 'false';
$prime_software_company_data_slick_dots = $prime_software_company_data_slick_dots ? 'true' : 'false';
$prime_software_company_data_slick_autoplay = $prime_software_company_data_slick_autoplay ? 'true' : 'false';
$prime_software_company_data_slick_draggable = $prime_software_company_data_slick_draggable ? 'true' : 'false';
$prime_software_company_data_slick_fade = $prime_software_company_data_slick_fade ? 'true' : 'false';
?>

<div id="featured-slider">
    <div class="section-content"
        data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": <?php echo esc_attr($prime_software_company_data_slick_infinite); ?>, "speed": <?php echo esc_attr($prime_software_company_data_slick_speed); ?>, "dots": <?php echo esc_attr($prime_software_company_data_slick_dots); ?>, "autoplay": <?php echo esc_attr($prime_software_company_data_slick_autoplay); ?>, "draggable": <?php echo esc_attr($prime_software_company_data_slick_draggable); ?>, "fade": <?php echo esc_attr($prime_software_company_data_slick_fade); ?> }'>

        <?php
        $prime_software_company_number_of_featured_slider_items = absint(get_theme_mod('number_of_featured_slider_items', 5)); // Ensure the value is an integer
        
        // Ensure the number of posts starts from 1, and not showing any extras
        if ($prime_software_company_number_of_featured_slider_items < 1) {
            $prime_software_company_number_of_featured_slider_items = 1; // Ensure minimum value is 1
        }

        ?> <?php $prime_software_company_slider_pages = array();
         for ($prime_software_company_count = 1; $prime_software_company_count <= 4; $prime_software_company_count++) {
             $prime_software_company_mod = intval(get_theme_mod('select_post_slider' . $prime_software_company_count));
             if ('page-none-selected' != $prime_software_company_mod) {
                 $prime_software_company_slider_pages[] = $prime_software_company_mod;
             }
         }
         if (!empty($prime_software_company_slider_pages)):
             $prime_software_company_args = array(
                 'post_type' => 'post',
                 'post__in' => $prime_software_company_slider_pages,
                 'posts_per_page' => $prime_software_company_number_of_featured_slider_items,
                 'orderby' => 'post__in'
             );
             $prime_software_company_catquery = new WP_Query($prime_software_company_args);

             $prime_software_company_catquery_counter = 0; // Initialize counter
             while ($prime_software_company_catquery->have_posts() && $prime_software_company_catquery_counter < $prime_software_company_number_of_featured_slider_items):
                 $prime_software_company_catquery->the_post();
                 $prime_software_company_catquery_counter++;
                 ?>
                <article>
                    <div class="opbg">
                        <div class="slide-inner slide-bg-image">
                            <div class="sliderimg">
                                <?php if (has_post_thumbnail()): ?>
                                    <?php $prime_software_company_total_slider_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); ?>
                                    <img class="slide-mainimg" alt="<?php echo esc_attr(get_the_title()); ?>"
                                        src="<?php echo esc_url($prime_software_company_total_slider_image[0]); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="row d-flex align-items-center">
                                <div class="slider-inner-mainbox">
                                    <?php if (get_theme_mod('featured_slider_overlayimg_enable', true)): ?>
                                        <!-- Additional content if enabled -->
                                    <?php endif; ?>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 leftcontentbox <?php echo esc_attr(get_theme_mod('prime_software_company_featured_slider_onload_effects', 'wow zoomIn')); ?>"
                                        data-wow-duration="2s">


                                        <div class="wrapper animated <?php echo esc_attr(get_theme_mod('prime_software_company_featured_slider_onload_effects', 'wow Bounce In Up')); ?>"
                                            data-wow-duration="2s">
                                            <div class="entry-container">
                                                <header class="entry-header header">
                                                    <h3><?php echo ($prime_software_company_featured_slider_section_heading); ?></h3>
                                                    <div class="read-more">
                                                        <h2 class="entry-title"
                                                            style="text-transform : <?php if (get_theme_mod('featured_slider_title_case', 'None') == 'None') { ?> None <?php } elseif (get_theme_mod('featured_slider_title_case', 'Capitalize') == 'Capitalize') { ?> Capitalize <?php } elseif (get_theme_mod('featured_slider_title_case', 'Lowercase') == 'Lowercase') { ?> Lowercase <?php } elseif (get_theme_mod('featured_slider_title_case', 'Uppercase') == 'Uppercase') { ?> Uppercase <?php } ?>">
                                                            <?php the_title(); ?>
                                                        </h2>
                                                    </div>
                                                </header>
                                                <div class="sliderparaimg">
                                                    <div class="row">
                                                        <div class="col-sm-12 entry-content content">
                                                            <?php $prime_software_company_excerpt = prime_software_company_the_excerpt(25);
                                                            echo wp_kses_post(wpautop($prime_software_company_excerpt)); ?>

                                                            <div class="py-3">
                                                                <div class="sliderbut1 animated flipInY d-flex">
                                                                    
                                                                <a href="<?php echo esc_url(get_theme_mod('prime_software_company_button1_url', '#')); ?>" class="btn1 btn-custom1 rounded1">
                                                                    <?php echo esc_html(get_theme_mod('prime_software_company_button1_text', 'Contact Us Today')); ?>
                                                                </a>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div><!-- .entry-container -->
                                            </div><!-- .wrapper -->
                                        </div><!-- .leftcontentbox -->


                                    </div><!-- .slider-inner-mainbox -->
                                </div><!-- .row -->
                            </div><!-- .slide-inner -->
                        </div><!-- .opbg -->
                </article>
            <?php endwhile; ?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
    </div><!-- .section-content -->
</div>
