<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package prime-software-company
 */

?>

<div class="maincontent">
    <div class="post-item">
        <div class="featured-image" style="height: <?php echo esc_attr(get_theme_mod('featured_posts_image_height', '337')); ?>px;">
            <a href="<?php echo esc_url(get_permalink()); ?>">
                <?php if (has_post_thumbnail()): ?>
                    <img src="<?php echo esc_url(get_the_post_thumbnail_url(null, 'full')); ?>" alt="<?php the_title_attribute(); ?>" />
                <?php else: ?>
                    <img src="<?php echo esc_url(get_template_directory_uri() . "/assets/images/no-images.jpg"); ?>" alt="No image available" />
                <?php endif; ?>
            </a>

          
  <div class="entry-container">
            <header class="pb-1">
                <h2 class="page-title mb-0">
                    <a href="<?php echo esc_url(get_permalink()); ?>">
                        <?php echo esc_html(get_the_title()); ?>
                    </a>
                </h2>
                 <h4 class="post-date">
                    <a href="<?php the_permalink(); ?>"><?php echo esc_html(get_the_date('j, F, Y')); ?></a>
                </h4>
            </header>
               
        </div>

        </div>

      
    </div>
</div>
