<?php

/**
 * Header Theme Options
 *
 * @package prime-software-company
 */
$wp_customize->add_section('prime_software_company_header_section', array(

	'title'      => esc_html__('Header Section', 'prime-software-company'),
	'capability' => 'edit_theme_options',
	'panel' => 'prime_software_company_theme_section_panel'

));

////////// Button

$wp_customize->add_setting('prime_software_company_header_btntext', 
    array(
    'default'           => __('Enquire Now', 'prime-software-company'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('prime_software_company_header_btntext', 
    array(
    'label'       => __('Button Text', 'prime-software-company'),
    'section'     => 'prime_software_company_header_section',   
    'settings'    => 'prime_software_company_header_btntext',           
    'type'        => 'text'
    )
);
// Button URL
$wp_customize->add_setting( 'prime_software_company_header_btnlink', array(
    'default'           => 'Enter the Button URL',
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control( 'prime_software_company_header_btnlink', array(
    'label'       => __( 'Button URL', 'prime-software-company' ),
    'section'     => 'prime_software_company_header_section',
    'settings'    => 'prime_software_company_header_btnlink',
    'type'        => 'url',
));


// ///////// Menu Bg Color
$wp_customize->add_setting('menu_bg_color', array(
    'default'   => 'transparent',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'menu_bg_color', array(
    'section' => 'prime_software_company_header_section',
    'label'      => esc_html__('Menu Bg Color', 'prime-software-company'),
    )));

    // ///////// Menu Text Color
$wp_customize->add_setting('header_menu_text_color', array(
    'default'   => '#fff',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_menu_text_color', array(
    'section' => 'prime_software_company_header_section',
    'label'      => esc_html__('Menu Text Color', 'prime-software-company'),
    )));

    // ///////// Button Bg Color
$wp_customize->add_setting('header_button_bg_color', array(
    'default'   => '#ffffff',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_button_bg_color', array(
    'section' => 'prime_software_company_header_section',
    'label'      => esc_html__('Header Button Bg Color', 'prime-software-company'),
    )));

    // ///////// Button Text Color
$wp_customize->add_setting('header_button_text_color', array(
    'default'   => '#1F2B37',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_button_text_color', array(
    'section' => 'prime_software_company_header_section',
    'label'      => esc_html__('Header Button Text Color', 'prime-software-company'),
    )));

    
    //Image
$wp_customize->add_setting( 'prime_software_company_header_image1', array(  
        'sanitize_callback' => 'prime_software_company_sanitise_custom_url'
        ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'prime_software_company_header_image1', array(
            'label'      => __( 'Section Image', 'prime-software-company' ),
            'section'    => 'prime_software_company_header_section',
            'settings'   => 'prime_software_company_header_image1',
    )));
