<?php 
/**
 * Home Section
 *
 * @package prime-software-company
 */

$prime_software_company_default = prime_software_company_get_default_theme_options();

/** Slider Info section */
$wp_customize->add_section(
    'primesoftwarecompany_featured_slider_info_section',
    array(
        'title'    => __( 'Slider Info', 'prime-software-company' ),      
        'priority' => 1,
        'panel'      => 'prime_software_company_section_panel',       	
    )
);


// /// effects
$wp_customize->add_setting('prime_software_company_featured_slider_onload_effects',array(
    'default' => 'Bounce In Up',
    'sanitize_callback' => 'prime_software_company_sanitize_choices',
));
$wp_customize->add_control('prime_software_company_featured_slider_onload_effects',array(
    'type' => 'select',
    'label' => __('Box Onload Transition Effects','prime-software-company'),
    'choices' => array (
        'wow bounceInLeft' => __('Bounce In Left','prime-software-company'),
        'wow bounceInRight' => __('Bounce In Right','prime-software-company'),
        'wow bounceInUp' => __('Bounce In Up','prime-software-company'),
        'wow bounceInDown' => __('Bounce In Down','prime-software-company'),
        'wow zoomIn' => __('Zoom In','prime-software-company'),
        'wow zoomOut' => __('Zoom Out','prime-software-company'),
        'wow fadeInDown' => __('Fade In Down','prime-software-company'),            
        'wow fadeInUp' => __('Fade In Up','prime-software-company'),
        'wow fadeInLeft' => __('Fade In Left','prime-software-company'),
        'wow fadeInRight' => __('Fade In Right','prime-software-company'),
        'flip-up' => __('Flip Up','prime-software-company')
    ),
    'section' => 'primesoftwarecompany_featured_slider_info_section',
)); 

// Items
// Number of Slider Items
$wp_customize->add_setting('number_of_featured_slider_items', array(
    'default'           => 3, // Set default number of items
    'sanitize_callback' => 'absint', // Ensure it's a valid integer
));

$wp_customize->add_control('number_of_featured_slider_items', array(
    'label'    => __('Number Of Slider To Show', 'prime-software-company'),
    'section'  => 'primesoftwarecompany_featured_slider_info_section', // The section where this control will appear
    'type'     => 'number',
    'input_attrs' => array(
        'min' => 1, // Minimum value
        'max' => 10, // Maximum value
        'step' => 1, // Increment step
    ),
));

$prime_software_company_slider_list = array();
$prime_software_company_args = array('post_type' => 'post'); // Fetch posts, not pages
$prime_software_company_posts = get_posts( $prime_software_company_args ); 
foreach($prime_software_company_posts as $prime_software_company_post) {
    $prime_software_company_slider_list[$prime_software_company_post->ID] = $prime_software_company_post->post_title; // Use post ID as key and title as value
}

for ( $prime_software_company_count = 1; $prime_software_company_count <= 3; $prime_software_company_count++ ) {
    $wp_customize->add_setting( 'select_post_slider' . $prime_software_company_count, array(
        'default'           => '',
        'sanitize_callback' => 'prime_software_company_sanitize_post_dropdown'
    ));
    $wp_customize->add_control( 'select_post_slider' . $prime_software_company_count, array(
        'label'   => __( 'Select A Post Page', 'prime-software-company' ),
        'section' => 'primesoftwarecompany_featured_slider_info_section',
        'type'    => 'select', // Use 'select' for custom post list
        'choices' => $prime_software_company_slider_list // Populate choices with posts
    ));
}

$wp_customize->add_setting('theme_options[featured_slider_section_heading]', 
	array(
	'default'           => $prime_software_company_default['featured_slider_section_heading'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_slider_section_heading]', 
	array(
	'label'       => __('Heading', 'prime-software-company'),
	'section'     => 'primesoftwarecompany_featured_slider_info_section',   
	'settings'    => 'theme_options[featured_slider_section_heading]',		
	'type'        => 'text'
	)
);

////////// Button

$wp_customize->add_setting('prime_software_company_button1_text', 
    array(
    'default'           => __('Contact Us Today', 'prime-software-company'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('prime_software_company_button1_text', 
    array(
    'label'       => __('Button Text', 'prime-software-company'),
    'section'     => 'primesoftwarecompany_featured_slider_info_section',   
    'settings'    => 'prime_software_company_button1_text',           
    'type'        => 'text'
    )
);
// Button URL
$wp_customize->add_setting( 'prime_software_company_button1_url', array(
    'default'           => 'Enter the Button URL',
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control( 'prime_software_company_button1_url', array(
    'label'       => __( 'Button URL', 'prime-software-company' ),
    'section'     => 'primesoftwarecompany_featured_slider_info_section',
    'settings'    => 'prime_software_company_button1_url',
    'type'        => 'url',
));
