<?php
/**
 * About Section options.
 *
 * @package prime-software-company
 */

$prime_software_company_default = prime_software_company_get_default_theme_options();


$wp_customize->add_section(
    'primesoftwarecompany_featured_services_info_section',
    array(
        'title' => __('Service Info', 'prime-software-company'),
        'priority' => 3,
        'panel' => 'prime_software_company_section_panel',
    )
);

// Enable Section
$wp_customize->add_setting('primesoftwarecompany_enable_featured_services_section', 
	array(
	'default' 			=> $prime_software_company_default['primesoftwarecompany_enable_featured_services_section'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'prime_software_company_sanitize_switch'
	)
);

$wp_customize->add_control('primesoftwarecompany_enable_featured_services_section', 
	array(		
	'label' 	=> __('Enable Section', 'prime-software-company'),
	'section' 	=> 'primesoftwarecompany_featured_services_info_section',
	'settings'  => 'primesoftwarecompany_enable_featured_services_section',
	'type' 		=> 'checkbox',	
	)
);


// /// effects
$wp_customize->add_setting('prime_software_company_featured_services_onload_effects', array(
    'default' => 'zoom-in',
    'sanitize_callback' => 'prime_software_company_sanitize_choices',
));
$wp_customize->add_control('prime_software_company_featured_services_onload_effects', array(
    'type' => 'select',
    'label' => __('Box Onload Transition Effects', 'prime-software-company'),
    'choices' => array(
        'wow bounceInLeft' => __('Bounce In Left', 'prime-software-company'),
        'wow bounceInRight' => __('Bounce In Right', 'prime-software-company'),
        'wow bounceInUp' => __('Bounce In Up', 'prime-software-company'),
        'wow bounceInDown' => __('Bounce In Down', 'prime-software-company'),
        'wow zoomIn' => __('Zoom In', 'prime-software-company'),
        'wow zoomOut' => __('Zoom Out', 'prime-software-company'),
        'wow fadeInDown' => __('Fade In Down', 'prime-software-company'),
        'wow fadeInUp' => __('Fade In Up', 'prime-software-company'),
        'wow fadeInLeft' => __('Fade In Left', 'prime-software-company'),
        'wow fadeInRight' => __('Fade In Right', 'prime-software-company'),
        'flip-up' => __('Flip Up', 'prime-software-company')
    ),
    'section' => 'primesoftwarecompany_featured_services_info_section',
));

// Section Title
$wp_customize->add_setting(
    'theme_options[featured_services_section_maintaitle]',
    array(
        'default' => $prime_software_company_default['featured_services_section_maintaitle'],
        'type' => 'theme_mod',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    'theme_options[featured_services_section_maintaitle]',
    array(
        'label' => __('Heading', 'prime-software-company'),
        'section' => 'primesoftwarecompany_featured_services_info_section',
        'settings' => 'theme_options[featured_services_section_maintaitle]',
        'type' => 'text'
    )
);

// Section Sub-Title
$wp_customize->add_setting(
    'theme_options[featured_services_section_subtitle]',
    array(
        'default' => $prime_software_company_default['featured_services_section_subtitle'],
        'type' => 'theme_mod',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    'theme_options[featured_services_section_subtitle]',
    array(
        'label' => __('Sub Heading 1', 'prime-software-company'),
        'section' => 'primesoftwarecompany_featured_services_info_section',
        'settings' => 'theme_options[featured_services_section_subtitle]',
        'type' => 'text'
    )
);

$wp_customize->add_setting('featured_services_page_1', array(
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'featured_services_page_1', array(
    'label' => __('Select Page 1', 'prime-software-company'),
    'section' => 'primesoftwarecompany_featured_services_info_section',
    'type' => 'dropdown-pages',
)));

$wp_customize->add_setting('featured_services_page_2', array(
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'featured_services_page_2', array(
    'label' => __('Select Page 2', 'prime-software-company'),
    'section' => 'primesoftwarecompany_featured_services_info_section',
    'type' => 'dropdown-pages',
)));

$wp_customize->add_setting('featured_services_page_3', array(
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'featured_services_page_3', array(
    'label' => __('Select Page 3', 'prime-software-company'),
    'section' => 'primesoftwarecompany_featured_services_info_section',
    'type' => 'dropdown-pages',
)));

// $wp_customize->add_setting('featured_services_page_4', array(
//     'sanitize_callback' => 'absint',
// ));
// $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'featured_services_page_4', array(
//     'label' => __('Select Page 4', 'prime-software-company'),
//     'section' => 'primesoftwarecompany_featured_services_info_section',
//     'type' => 'dropdown-pages',
// )));
