<?php
/**
 * About Section options.
 *
 * @package prime-software-company
 */

$prime_software_company_default = prime_software_company_get_default_theme_options();

/** About Info section */
$wp_customize->add_section(
    'primesoftwarecompany_featured_about_info_section',
    array(
        'title'    => __( 'About Info', 'prime-software-company' ),      
        'priority' => 2,
        'panel'      => 'prime_software_company_section_panel',       	
    )
);

// Enable Section
$wp_customize->add_setting('primesoftwarecompany_enable_featured_about_section', 
	array(
	'default' 			=> $prime_software_company_default['primesoftwarecompany_enable_featured_about_section'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'prime_software_company_sanitize_switch'
	)
);

$wp_customize->add_control('primesoftwarecompany_enable_featured_about_section', 
	array(		
	'label' 	=> __('Enable Section', 'prime-software-company'),
	'section' 	=> 'primesoftwarecompany_featured_about_info_section',
	'settings'  => 'primesoftwarecompany_enable_featured_about_section',
	'type' 		=> 'checkbox',	
	)
);

$wp_customize->add_setting('prime_software_company_featured_about_onload_effects', array(
    'default' => 'wow zoomIn',
    'sanitize_callback' => 'prime_software_company_sanitize_choices',
));

$wp_customize->add_control('prime_software_company_featured_about_onload_effects', array(
    'label' => __('Box Onload Transition Effects', 'prime-software-company'),
    'section' => 'primesoftwarecompany_featured_about_info_section',
    'settings' => 'prime_software_company_featured_about_onload_effects',
    'type' => 'select',
    'choices' => array(
        'wow bounceInLeft' => __('Bounce In Left', 'prime-software-company'),
        'wow bounceInRight' => __('Bounce In Right', 'prime-software-company'),
        'wow bounceInUp' => __('Bounce In Up', 'prime-software-company'),
        'wow bounceInDown' => __('Bounce In Down', 'prime-software-company'),
        'wow zoomIn' => __('Zoom In', 'prime-software-company'),
        'wow zoomOut' => __('Zoom Out', 'prime-software-company'),
        'wow fadeInDown' => __('Fade In Down', 'prime-software-company'),
        'wow fadeInUp' => __('Fade In Up', 'prime-software-company'),
        'wow fadeInLeft' => __('Fade In Left', 'prime-software-company'),
        'wow fadeInRight' => __('Fade In Right', 'prime-software-company'),
        'flip-up' => __('Flip Up', 'prime-software-company'),
    ),
));

// main about image 1
$wp_customize->add_setting('prime_software_company_about_image1', array(
	  'sanitize_callback' => 'esc_url_raw',
));
$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'prime_software_company_about_image1', array(
	'label' => __('About Image 1', 'prime-software-company'),
	'description' => __('Size 392px x 908x', 'prime-software-company'),
	'section' => 'primesoftwarecompany_featured_about_info_section',
	'settings' => 'prime_software_company_about_image1',
)));

// main about image 2
$wp_customize->add_setting('prime_software_company_about_image2', array(
    'sanitize_callback' => 'esc_url_raw',
));
$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'prime_software_company_about_image2', array(
    'label'       => __('About Image 2', 'prime-software-company'),
    'description' => __('Size 392px x 908x', 'prime-software-company'),
    'section'     => 'primesoftwarecompany_featured_about_info_section',
    'settings'    => 'prime_software_company_about_image2',
)));


// Section img Text 1
$wp_customize->add_setting(
	'theme_options[featured_about_section_imagetitle1]',
	array(
		'default' => $prime_software_company_default['featured_about_section_imagetitle1'],
		'type' => 'theme_mod',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control(
	'theme_options[featured_about_section_imagetitle1]',
	array(
		'label' => __('Image Upper Text', 'prime-software-company'),
		'section' => 'featured_about_info_section',
		'settings' => 'theme_options[featured_about_section_imagetitle1]',
		'type' => 'text'
	)
);

// Section img Text 1
$wp_customize->add_setting(
	'theme_options[featured_about_section_imagetitle2]',
	array(
		'default' => $prime_software_company_default['featured_about_section_imagetitle2'],
		'type' => 'theme_mod',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control(
	'theme_options[featured_about_section_imagetitle2]',
	array(
		'label' => __('Image Below Text', 'prime-software-company'),
		'section' => 'featured_about_info_section',
		'settings' => 'theme_options[featured_about_section_imagetitle2]',
		'type' => 'text'
	)
);



// Section Title
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_subheading]', 
    array(
        'default'           => $prime_software_company_default['featured_about_section_aboutus_subheading'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_subheading]', 
    array(
        'label'       => __('Heading', 'prime-software-company'),
        'section'     => 'primesoftwarecompany_featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_section_aboutus_subheading]',		
        'type'        => 'text'
    )
);


// // Section Title
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_heading]', 
	array(
	'default'           => $prime_software_company_default['featured_about_section_aboutus_heading'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_heading]', 
	array(
	'label'       => __('Sub Heading', 'prime-software-company'),
	'section'     => 'primesoftwarecompany_featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_aboutus_heading]',		
	'type'        => 'text'
	)
);

// // Section Title
// $wp_customize->add_setting('theme_options[featured_about_section_aboutus_heading1]', 
// 	array(
// 	'default'           => $prime_software_company_default['featured_about_section_aboutus_heading1'],
// 	'type'              => 'theme_mod',
// 	'capability'        => 'edit_theme_options',	
// 	'sanitize_callback' => 'sanitize_text_field'
// 	)
// );
// $wp_customize->add_control('theme_options[featured_about_section_aboutus_heading1]', 
// 	array(
// 	'label'       => __('Heading 2', 'prime-software-company'),
// 	'section'     => 'primesoftwarecompany_featured_about_info_section',   
// 	'settings'    => 'theme_options[featured_about_section_aboutus_heading1]',		
// 	'type'        => 'text'
// 	)
// );

// // Section description
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_description]', 
	array(
	'default'           => $prime_software_company_default['featured_about_section_aboutus_description'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_description]', 
	array(
	'label'       => __('Description', 'prime-software-company'),
	'section'     => 'primesoftwarecompany_featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_aboutus_description]',		
	'type'        => 'text'
	)
);


	$wp_customize->add_setting('theme_options[featured_icon_about1]', array(
		'default'           => 'fas fa-comment-dots',
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	));
	
	$wp_customize->add_control('theme_options[featured_icon_about1]', array(
		'label'    => __('Plan Icon 1', 'prime-software-company'),
		'section'  => 'primesoftwarecompany_featured_about_info_section',
		'settings' => 'theme_options[featured_icon_about1]',
		'type'     => 'text',
	));
	

// Section Sub Title
$wp_customize->add_setting(
	'theme_options[featured_about_section_bxtitle1]',
	array(
		'default' => $prime_software_company_default['featured_about_section_bxtitle1'],
		'type' => 'theme_mod',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control(
	'theme_options[featured_about_section_bxtitle1]',
	array(
		'label' => __('Plan Title 1', 'prime-software-company'),
		'section' => 'primesoftwarecompany_featured_about_info_section',
		'settings' => 'theme_options[featured_about_section_bxtitle1]',
		'type' => 'text'
	)
);
$wp_customize->add_setting('theme_options[featured_icon_about2]', array(
	'default'           => 'fas fa-cloud',
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('theme_options[featured_icon_about2]', array(
	'label'    => __('Plan Icon 1', 'prime-software-company'),
	'section'  => 'primesoftwarecompany_featured_about_info_section',
	'settings' => 'theme_options[featured_icon_about2]',
	'type'     => 'text',
));
// Section Sub Title
$wp_customize->add_setting(
	'theme_options[featured_about_section_bxtitle2]',
	array(
		'default' => $prime_software_company_default['featured_about_section_bxtitle2'],
		'type' => 'theme_mod',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control(
	'theme_options[featured_about_section_bxtitle2]',
	array(
		'label' => __('Plan Title 2', 'prime-software-company'),
		'section' => 'primesoftwarecompany_featured_about_info_section',
		'settings' => 'theme_options[featured_about_section_bxtitle2]',
		'type' => 'text'
	)
);
$wp_customize->add_setting('theme_options[featured_icon_about3]', array(
	'default'           => 'fas fa-video',
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('theme_options[featured_icon_about3]', array(
	'label'    => __('Plan Icon 1', 'prime-software-company'),
	'section'  => 'primesoftwarecompany_featured_about_info_section',
	'settings' => 'theme_options[featured_icon_about3]',
	'type'     => 'text',
));
// Section Sub Text
$wp_customize->add_setting(
	'theme_options[featured_about_section_bxtitle3]',
	array(
		'default' => $prime_software_company_default['featured_about_section_bxtitle3'],
		'type' => 'theme_mod',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control(
	'theme_options[featured_about_section_bxtitle3]',
	array(
		'label' => __('Plan Title 1', 'prime-software-company'),
		'section' => 'primesoftwarecompany_featured_about_info_section',
		'settings' => 'theme_options[featured_about_section_bxtitle3]',
		'type' => 'text'
	)
);

// Button Text Setting
$wp_customize->add_setting(
    'theme_options[featured_about_section_buttontext]',
    array(
        'default'           => $prime_software_company_default['featured_about_section_buttontext'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'theme_options[featured_about_section_buttontext]',
    array(
        'label'    => __('Button Text', 'prime-software-company'),
        'section'  => 'primesoftwarecompany_featured_about_info_section',
        'settings' => 'theme_options[featured_about_section_buttontext]',
        'type'     => 'text',
    )
);

// Button URL Setting
$wp_customize->add_setting(
    'theme_options[featured_about_section_buttonurl]',
    array(
        'default'           => '#',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    'theme_options[featured_about_section_buttonurl]',
    array(
        'label'    => __('Button URL', 'prime-software-company'),
        'section'  => 'primesoftwarecompany_featured_about_info_section',
        'settings' => 'theme_options[featured_about_section_buttonurl]',
        'type'     => 'url',
    )
);

