<?php
/**
 * Default theme options.
 *
 * @package prime-software-company
 */

if ( ! function_exists( 'prime_software_company_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0
	 *
	 * @return array Default theme options.
	 */
function prime_software_company_get_default_theme_options() {

	$prime_software_company_defaults = array();
	

    // Front Page Content
	$prime_software_company_defaults['enable_frontpage_content'] 		= true;

	// Slider Section	
	$prime_software_company_defaults['enable_featured_slider_section']		    	= true;
	//$prime_software_company_defaults['show_slider_colors']		    			= false;	
	$prime_software_company_defaults['featured_slider_content_type']		    	= 'featured_slider_page';
	$prime_software_company_defaults['featured_slider_category_readmore_text']		= esc_html__('Read More','prime-software-company');
	$prime_software_company_defaults['featured_slider_section_heading']		= esc_html__('Welcome To Software Company','prime-software-company');
	$prime_software_company_defaults['data_slick_speed']					    	= 1000;
	$prime_software_company_defaults['data_slick_infinite']				    	= 1;
	$prime_software_company_defaults['data_slick_dots']					    	= 1;
	$prime_software_company_defaults['data_slick_autoplay']				    	= 1;
	$prime_software_company_defaults['data_slick_draggable']				    	= 1;
	$prime_software_company_defaults['data_slick_fade']					    	= 1;
	$prime_software_company_defaults['number_of_featured_slider_items']	    	= 6;

	// Features Section
	$prime_software_company_defaults['enable_featured_features_section']			= true;
	//$prime_software_company_defaults['show_feature_colors']						= false;
	$prime_software_company_defaults['number_of_featured_features_items']			= 6;
	$prime_software_company_defaults['featured_features_column']					= 3;
	$prime_software_company_defaults['featured_features_content_type']				= 'featured_features_page';
	$prime_software_company_defaults['feture_section_excerpt']						= 25;
	

	// About Section	
	$prime_software_company_defaults['primesoftwarecompany_enable_featured_about_section']						= true;
    $prime_software_company_defaults['about_image_show'] 									= true;
	$prime_software_company_defaults['featured_about_section_aboutus_subheading']							= esc_html__('Who We Are And What We Do', 'prime-software-company' );
	$prime_software_company_defaults['featured_about_section_aboutus_heading']							= esc_html__('We Provide The Best Software Company', 'prime-software-company' );
	// $prime_software_company_defaults['featured_about_section_aboutus_heading1']							= esc_html__('Our Operations Around The World And Across Various Carpenter Sectors', 'prime-software-company' );
	$prime_software_company_defaults['featured_about_section_aboutus_description']							= esc_html__("There are many variations of passages of Lorem Ipsum available, but the randomised words which don't don't look even slightly believable.", 'prime-software-company' );

$prime_software_company_defaults['featured_about_section_imagetitle1']	    		= esc_html__( '25+', 'prime-software-company' );
$prime_software_company_defaults['featured_about_section_imagetitle2']	    		= esc_html__( 'Happily Active Client’s', 'prime-software-company' );

	$prime_software_company_defaults['featured_about_section_bxtitle1']	    	    = esc_html__( 'Live Chat Are Many Variations Of Passages Words Slightly Believable.', 'prime-software-company' );
	$prime_software_company_defaults['featured_about_section_bxtitle3']	    	    = esc_html__( 'Video Call Are Many Variations Of Passages Words Slightly Believable.', 'prime-software-company' );
	$prime_software_company_defaults['featured_about_section_bxtitle2']	    	    = esc_html__( 'Cloud Services Are Many Variations Of Passages Words Slightly Believable.', 'prime-software-company' );

	$prime_software_company_defaults['featured_icon_about1']					    = esc_html__( 'fas fa-comment-dots', 'prime-software-company' );
	$prime_software_company_defaults['featured_icon_about2']					    = esc_html__( 'fas fa-cloud', 'prime-software-company' );
	$prime_software_company_defaults['featured_icon_about3']					    = esc_html__( 'fas fa-video', 'prime-software-company' );

	$prime_software_company_defaults['featured_about_section_buttontext']	    	= esc_html__( 'Read More', 'prime-software-company' );

	// service Section	

	$prime_software_company_defaults['primesoftwarecompany_enable_featured_services_section']			= true;
	$prime_software_company_defaults['featured_services_section_maintaitle']	    = esc_html__( 'Our Services', 'prime-software-company' );
	$prime_software_company_defaults['featured_services_section_subtitle']	    	= esc_html__( 'We Provide The Best Software Company', 'prime-software-company' );
	$prime_software_company_defaults['services_excerpt_mainpagelength']			= 11;




	// Inner Blog Page	
	$prime_software_company_defaults['featured_bloginn_botton_text']				= esc_html__( 'Read More', 'prime-software-company' );

	return $prime_software_company_defaults;

}

endif;

/**
*  Get theme options
*/
if ( ! function_exists( 'prime_software_company_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function prime_software_company_get_option( $key ) {

		$default_options = prime_software_company_get_default_theme_options();
		if ( empty( $key ) ) {
			return;
		}

		$theme_options = (array)get_theme_mod( 'theme_options' );
		$theme_options = wp_parse_args( $theme_options, $default_options );

		$value = null;

		if ( isset( $theme_options[ $key ] ) ) {
			$value = $theme_options[ $key ];
		}

		return $value;

	}

endif;
