<?php
/**
 * prime-software-company Theme Customizer
 *
 * @package prime-software-company
 */

 // Custom Controls.
require get_template_directory() . '/inc/custom-control/custom-control.php';

// Sanitize callback.
require get_template_directory() . '/inc/customizer/sanitize-callback.php';

// Default
require get_template_directory() . '/inc/customizer/default.php';

// Load customize sanitize.
include get_template_directory() . '/inc/customizer/active-callback.php';


// Theme section.
// require get_template_directory() . '/inc/customizer/theme-section.php';

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function prime_software_company_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'prime_software_company_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'prime_software_company_customize_partial_blogdescription',
			)
		);
	}
	// Front Page Link
	require get_template_directory() . '/inc/customizer/home-section.php';

	require get_template_directory() . '/inc/customizer/section-pro.php';

	// Theme Page Link
	require get_template_directory() . '/inc/customizer/theme-options.php';
}
add_action( 'customize_register', 'prime_software_company_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function prime_software_company_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function prime_software_company_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function prime_software_company_customize_preview_js() {
	wp_enqueue_script( 'prime_software_company_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), PRIME_SOFTWARE_COMPANY_S_VERSION, true );
}
add_action( 'customize_preview_init', 'prime_software_company_customize_preview_js' );

/**
 *
 */
function prime_software_company_customize_backend_scripts() {

	wp_enqueue_style( 'prime-software-company-fontawesome-all', get_template_directory_uri() . '/assets/css/all.css' );

	wp_enqueue_style( 'prime-software-company-main-css', get_template_directory_uri() . '/assets/css/output.css' );

	wp_enqueue_style( 'prime-software-company-admin-customizer-style', get_template_directory_uri() . '/inc/customizer/css/customizer-style.css' );

	// Enqueue main customizer JS
	wp_enqueue_script(
		'prime-software-company-admin-customizer',
		get_template_directory_uri() . '/inc/customizer/js/customizer-script.js',
		array( 'jquery', 'customize-controls' ),
		'20151215',
		true
	);

	// Enqueue the controls script
	wp_enqueue_script(
		'prime-software-company-admin-customizer-control',
		get_template_directory_uri() . '/inc/customizer/js/customize-controls.js',
		array( 'jquery', 'customize-controls' ),
		'1.0',
		true
	);

	// Fix: Localize the customizer params for use in JS
	wp_localize_script(
		'prime-software-company-admin-customizer-control',
		'prime_software_company_customizer_params',
		array(
			'ajaxurl' => admin_url( 'admin-ajax.php' ),
		)
	);
}
add_action( 'customize_controls_enqueue_scripts', 'prime_software_company_customize_backend_scripts', 10 );

/**
 * Enqueue the stylesheet.
 */
function prime_software_company_customizer_stylesheet() {

    wp_register_style( 'prime-software-company-admin-css', get_template_directory_uri() . '/inc/customizer/css/customize-controls.css', NULL, NULL, 'all' );
    wp_enqueue_style( 'prime-software-company-admin-css' );
}
add_action( 'customize_controls_print_styles', 'prime_software_company_customizer_stylesheet' );

///////////////////////////// customize  color 


function prime_software_company_customize_css() {
    $custom_css = "
        .slider-inner-mainbox .slider-socialicon .socialicon {
            color: " . esc_html(get_theme_mod('social_icon_color')) . ";
        }
        #featured-slider .entry-container h4 {
            color: " . esc_html(get_theme_mod('slider_title_color')) . ";
        }
        #featured-slider .entry-container .content {
            color: " . esc_html(get_theme_mod('slider_subtitle_color')) . ";
        }
        #primary-menu, .custom-menu-wrapper{
            background-color: " . esc_html(get_theme_mod('menu_bg_color')) . ";
        }
        #site-navigation ul li a{
            color: " . esc_html(get_theme_mod('header_menu_text_color')) . ";
        }
        #site-navigation .btn a{
            color: " . esc_html(get_theme_mod('header_button_text_color')) . ";
        }
        #site-navigation .headerbtn a{
            background-color: " . esc_html(get_theme_mod('header_button_bg_color')) . ";
        }        
        #site-navigation .headerbtn a{
            color: " . esc_html(get_theme_mod('header_button_text_color')) . ";
        }
        .widget .wp-block-heading{
            color: " . esc_html(get_theme_mod('heading_text_color')) . ";
        }
        #featured-slider .content a,
        #featured-slider code,
        .wp-block-buttons .wp-block-button__link,
        .singlepage #submit {
            background: " . esc_html(get_theme_mod('slider_readmore_color')) . ";
            color: " . esc_html(get_theme_mod('slider_readmoretxt_color')) . " !important;
        }
        #featured-slider .slick-dots li {
            background: " . esc_html(get_theme_mod('slider_slickdot_color')) . ";
        }
        #featured-slider .slick-dots li.slick-active {
            background: " . esc_html(get_theme_mod('slider_activeslickdot_color')) . ";
        }
        #featured-slider .sliderbut1 a {
            color: " . esc_html(get_theme_mod('slider_buttontext1_color')) . ";
        }
        #featured-slider .sliderbut1 {
            background: " . esc_html(get_theme_mod('slider_buttonbg1_color')) . ";
        }
        #featured-slider .sliderbut2 a {
            color: " . esc_html(get_theme_mod('slider_buttontext2_color')) . ";
        }
        #featured-slider .sliderbut2 {
            background: " . esc_html(get_theme_mod('slider_buttonbg2_color')) . ";
        }
        .featured-whatweoffer {
            background: " . esc_html(get_theme_mod('whatweoffer_background_color')) . ";
        }
        .featured-whatweoffer .head-title {
            color: " . esc_html(get_theme_mod('whatweoffer_title_color')) . ";
        }
        .featured-whatweoffer .head-subtitle {
            color: " . esc_html(get_theme_mod('whatweoffer_subtitle_color')) . ";
        }
        .featured-whatweoffer .title a {
            color: " . esc_html(get_theme_mod('whatweoffer_cardtitle_color')) . ";
        }
    ";

    // Ensure the main stylesheet is enqueued first
    wp_enqueue_style('prime-software-company-style', get_stylesheet_uri());

    // Add inline CSS to it
    wp_add_inline_style('prime-software-company-style', $custom_css);
}
add_action('wp_enqueue_scripts', 'prime_software_company_customize_css');
