<?php
get_header();

if (is_front_page() && is_home()) { ?>
<?php
    /**
     * Template Name: Custom Front Page
     */

get_header(); ?>
<main id="primary" class="site-main front">
    <?php 
        $prime_software_company_header_image1 = get_theme_mod('prime_software_company_header_image1');                    
        if(!empty($prime_software_company_header_image1)) {  ?>
    <div class="banner-head" style="background-image: url('<?php echo esc_url($prime_software_company_header_image1)?>');">
        <div class="center-div">
            <h1><?php esc_html_e('Posts', 'prime-software-company'); ?></h1>
        </div>
    </div>;
    <?php } else{?>
    <div class="banner-head"
        style="background-image: url('<?php echo esc_url( get_template_directory_uri() . '/assets/images/copyrightimg.png' ); ?>');">
        
        <div class="center-div">
            <h1><?php esc_html_e('Posts', 'prime-software-company'); ?></h1>
        </div>
    </div>;
    <?php }?>
    <div class="blog-div container p-2 mt-3" id="primaryid">       
            <div class="row">
                <div class="col-lg-8 col-md-8 col-12 front-post">
                    <?php
                    if (have_posts()) :

                        if (is_home() && !is_front_page()) :
                            ?>
                    <header>
                        <h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
                    </header>
                    <?php
                endif;?>
                    <div class="row mainrow">
                        <?php 
                        while (have_posts()) :
                            the_post();
                            ?>

                        <div class="col-lg-6 col-md-6 col-12 box gap-10">
                            <?php
                            get_template_part( 'template-parts/maincontent', get_post_type() );
                        ?>
                        </div>

                        <?php
                            		
                          endwhile;
                          the_posts_pagination(array(
                            'mid_size'  => __('2', 'prime-software-company'), 
                            'prev_text' => __('« Previous', 'prime-software-company'),
                            'next_text' => __('Next »', 'prime-software-company'),
                          ));
                    
                    else :

                        get_template_part('template-parts/content', 'none');

                    endif;
                    ?>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-12 sidebar-col ">
                    <div class="sidebar-div mx-3">
                        <?php                        
                        if (is_active_sidebar('sidebar-1')) {
                            dynamic_sidebar('sidebar-1');                            
                        } else {
                            get_sidebar();
                        }
                        ?>
                    </div>
                </div>
            </div>
       

    </div>
</main>

<?php get_footer(); ?>

<?php } elseif (is_front_page() && !is_home()) { ?>
<main id="primary" class="site-main">
    <?php
        get_template_part('template-parts/section/section', 'featured-slider');    
        
        get_template_part('template-parts/section/section', 'featured-about');    

        get_template_part('template-parts/section/section', 'featured-services');


        ?>
</main><!-- #main -->
<?php }

get_footer();
?>