<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package prime-software-company
 */

?>

<footer id="colophon" class="site-footer">
    <div class="footer-bgoverlay"></div>
    <div class="footer-widgets-area mt-4 container-fluid p-0">
        <?php 
    $footer_sidebar_data = prime_software_company_footer_sidebar_class();
    $footer_sidebar = $footer_sidebar_data['active_sidebar'];
    $footer_class = $footer_sidebar_data['class'];

    if ( ! empty( $footer_sidebar ) ) : ?>
        <div class="<?php echo esc_attr( $footer_class ); ?>">
            <?php foreach ( $footer_sidebar as $sidebar ) : ?>
            <div class="hentry">
                <?php dynamic_sidebar( $sidebar ); ?>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        
    </div>

    <div class="site-info mt-4 mb-3 d-flex">


         <ul class="d-flex">
    <li>
        <a href="<?php echo esc_html(get_theme_mod('prime_software_company_featured_icon_url_footer1', ' ')); ?>">
            <i class="<?php echo esc_html(get_theme_mod('prime_software_company_foot_featured_icon_footer1', 'fa-brands fa-facebook-f')) ?>"></i>
        </a>
    </li>
    <li>
        <a href="<?php echo esc_html(get_theme_mod('prime_software_company_featured_icon_url_footer2', ' ')); ?>">
            <i class="<?php echo esc_html(get_theme_mod('prime_software_company_foot_featured_icon_footer2', 'fa-brands fa-twitter')) ?>"></i>
        </a>
    </li>
    <li>
        <a href="<?php echo esc_html(get_theme_mod('prime_software_company_featured_icon_url_footer3', ' ')); ?>">
            <i class="<?php echo esc_html(get_theme_mod('prime_software_company_foot_featured_icon_footer3', 'fa-brands fa-instagram')) ?>"></i>
        </a>
    </li>
    <li>
        <a href="<?php echo esc_html(get_theme_mod('prime_software_company_featured_icon_url_footer4', ' ')); ?>">
            <i class="<?php echo esc_html(get_theme_mod('prime_software_company_foot_featured_icon_footer4', 'fa-brands fa-youtube')) ?>"></i>
        </a>
    </li>
</ul>



            <div class="copy-right">
                <p>
            <?php
            
            printf(
                esc_html__('%1$s', 'prime-software-company'),
                esc_html(get_theme_mod('prime_software_company_foot_themename', '- All Rights Reserved -')),
            );
                          ?>
                          </p>
            </div>
        </div><!-- .site-info -->

    <!-- Scroll to Top Button -->
    <?php if(get_theme_mod('featured_scrooltopbtn_on_off',true) == true ){  ?>
    <div class="scroll-to-top">
        <a href="#" id="scroll-to-top">
            <!-- <i class="fas fa-caret-up"></i> -->
             <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/copyrightimg.png' ); ?>" alt="footer Image" />
        </a>
    </div>
    <?php } ?>
</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>