<?php 
/**
 * Template part for displaying Featured About Section
 *
 * @package Prime Kindergarten
 */

$prime_kindergarten_about = get_theme_mod( 'prime_kindergarten_about_setting',false );
$prime_kindergarten_featured_mission_section_title = get_theme_mod( 'prime_kindergarten_featured_mission_section_title' );
$prime_kindergarten_featured_mission_posts[] = get_theme_mod( 'prime_kindergarten_featured_mission_post_' );

?>
<?php if ( $prime_kindergarten_about ){?>
<div id="about-section" class="section-content py-5">
    <div class="container">        
        <?php $args = array (
            'post_type'     => 'page',
            'posts_per_page' => 1,
            'post__in'      => $prime_kindergarten_featured_mission_posts,
            'orderby'       =>'post__in',
            'ignore_sticky_posts' => true,
        );?>
        <?php
        $loop = new WP_Query($args);
        if ( $loop->have_posts() ) :
            while ($loop->have_posts()) : $loop->the_post(); ?>
            <div class="featured-mission-box">
                <div class="row">                    
                    <div class="col-lg-7 col-md-7 align-self-center">
                        <header class="entry-header">
                            <?php if( !empty($prime_kindergarten_featured_mission_section_title) ): ?>
                                <div class="section-title">
                                    <h3><?php echo esc_html($prime_kindergarten_featured_mission_section_title); ?></h3>
                                </div>
                            <?php endif; ?>
                            <h4 class="entry-title"><?php the_title();?></h4>
                        </header>
                        <div class="entry-content">
                            <p class="mb-0"><?php echo wp_trim_words( get_the_content(), 100 ); ?></p>
                        </div>

                        <div class="btn-green my-4">
                            <a href="<?php the_permalink(); ?>">
                                <?php esc_html_e('More About Us','prime-kindergarten'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-5 col-md-5 align-self-center">
                        <?php if (has_post_thumbnail( $post->ID ) ): ?>
                        <div class="image-container">
                            <?php the_post_thumbnail(); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
    </div>
</div>
<?php } ?>