<?php

add_action( 'after_setup_theme', 'prime_kindergarten_after_setup_theme' );
function prime_kindergarten_after_setup_theme() {
    add_theme_support( 'title-tag' );
    add_theme_support( 'automatic-feed-links' );
    add_theme_support( "responsive-embeds" );
    add_theme_support( 'align-wide' );
    add_theme_support( 'post-thumbnails' );
    add_image_size( 'prime-kindergarten-featured-image', 2000, 1200, true );
    add_image_size( 'prime-kindergarten-thumbnail-avatar', 100, 100, true );

    // Set the default content width.
    $GLOBALS['content_width'] = 525;

    // Add theme support for Custom Logo.
    add_theme_support( 'custom-logo' , array(
        'height'        =>45,
        'width'         =>45,
        'flex-height'   =>true, 
        'flex-width'    =>true,
    ));

    add_theme_support( 'custom-background', array(
        'default-color' => 'ffffff'
    ) );

    add_theme_support( 'html5', array('comment-form','comment-list','gallery','caption',) );

    add_editor_style( array( 'assets/css/editor-style.css') );
}

// enqueue styles for child theme
function prime_kindergarten_enqueue_styles() {
    // enqueue parent styles
    wp_enqueue_style('prime-playschool-classes-style', get_template_directory_uri() .'/style.css');
    
    // enqueue child styles
    wp_enqueue_style('prime-kindergarten-child-style', get_stylesheet_directory_uri() .'/style.css', array('prime-playschool-classes-style'));

    wp_enqueue_script( 'comment-reply', '/wp-includes/js/comment-reply.min.js', array(), false, true );

    require get_theme_file_path( '/css_custom.php' );
    wp_add_inline_style( 'prime-playschool-classes-style',$prime_kindergarten_custom_css );
}
add_action('wp_enqueue_scripts', 'prime_kindergarten_enqueue_styles');

if ( ! function_exists( 'prime_playschool_classes_footer_section' ) ) :

  /**
   * Footer copyright
   *
   * @since 1.0.0
   */
  function prime_playschool_classes_footer_section() { ?>
     <?php
    $footer_setting  = prime_playschool_classes_get_option( 'prime_playschool_classes_footer_setting' );
     if ( $footer_setting ){ ?>
      <div class="site-info">
        <?php 
          $copyright_footer = prime_playschool_classes_get_option('copyright_text'); 
          if ( ! empty( $copyright_footer ) ) {
            $copyright_footer = wp_kses_data( $copyright_footer );
          }
        ?>
        <div class="wrapper">
           <span class="copy-right"><?php echo esc_html($copyright_footer);?></span>
        </div><!-- .wrapper --> 
      </div> <!-- .site-info -->
    <?php } ?>

    <?php
    $scroll_top  = prime_playschool_classes_get_option( 'header_donate_scroll_to_top', true );
     if ( $scroll_top ){ ?>
        <a id="button"><i class="fas fa-arrow-up"></i></a>
    <?php } ?>
    
  <?php }

endif;
add_action( 'prime_playschool_classes_action_footer', 'prime_playschool_classes_footer_section', 20 );


if ( ! function_exists( 'prime_kindergarten_dropdown_pages' ) ) :
    function prime_kindergarten_dropdown_pages( $page_id, $setting ) {
        // Ensure $input is an absolute integer.
        $page_id = absint( $page_id );
      
        // If $page_id is an ID of a published page, return it; otherwise, return the default.
        return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
    }
endif;

function prime_kindergarten_customize_register( $wp_customize ) {
  
    /** About Section Settings */
    
    $wp_customize->add_section( 'prime_kindergarten_section_featured_about',
        array(
        'title'      => __( 'About Us Section', 'prime-kindergarten' ),
        'priority'   => 110,
        'capability' => 'edit_theme_options',
        'panel'      => 'prime_playschool_classes_home_page_settings',
        )
    );

    /** About Section control */
    $wp_customize->add_setting( 
        'prime_kindergarten_about_setting', 
        array(
            'default'           => false,
            'sanitize_callback' => 'prime_playschool_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_kindergarten_about_setting',
        array(
            'label'       => __( 'Show / Hide About', 'prime-kindergarten' ),
            'section'     => 'prime_kindergarten_section_featured_about',
            'type'        => 'checkbox',
        )
    );

    // Section Title
    $wp_customize->add_setting('prime_kindergarten_featured_mission_section_title', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('prime_kindergarten_featured_mission_section_title', 
        array(
        'label'       => __('Section Title', 'prime-kindergarten'),
        'section'     => 'prime_kindergarten_section_featured_about',   
        'settings'    => 'prime_kindergarten_featured_mission_section_title',
        'type'        => 'text'
        )
    );

    // Post
    $wp_customize->add_setting('prime_kindergarten_featured_mission_post_', 
        array(
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'prime_kindergarten_dropdown_pages'
        )
    );

    $wp_customize->add_control('prime_kindergarten_featured_mission_post_', 
        array(
        'label'       => __('Page #', 'prime-kindergarten'),
        'section'     => 'prime_kindergarten_section_featured_about',   
        'settings'    => 'prime_kindergarten_featured_mission_post_',
        'type'        => 'dropdown-pages',
        )
    );

    $wp_customize->add_setting('prime_kindergarten_tertiary_color', array(
        'default'           => '#18c0cb',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'prime_kindergarten_tertiary_color', array(
        'label'    => __('Theme Tertiary Color', 'prime-kindergarten'),
        'section'  => 'prime_playschool_classes_global_color',
        'settings' => 'prime_kindergarten_tertiary_color',
    )));
    
}
add_action( 'customize_register', 'prime_kindergarten_customize_register' );

function prime_kindergarten_customize_remove_settings( $wp_customize ) {
    // Remove a control by its ID
    $wp_customize->remove_control( 'prime_playschool_classes_blog_meta_order' );

    // Optionally, remove the associated setting by its ID
    $wp_customize->remove_setting( 'prime_playschool_classes_blog_meta_order' );
}
add_action( 'customize_register', 'prime_kindergarten_customize_remove_settings', 20 );


/**
 * Display the admin notice unless dismissed.
 */
function prime_playschool_classes_dashboard_notice_child() {
    // Check if the notice is dismissed
    $dismissed = get_user_meta( get_current_user_id(), 'prime_playschool_classes_dismissable_notice', true );

    // Display the notice only if not dismissed
    if ( ! $dismissed ) {

        // Get the theme name dynamically
        $theme_name = wp_get_theme()->get( 'Name' );
        ?>
        <div class="updated notice notice-success is-dismissible notice-get-started-class" data-notice="get-start">
            <div class="notice-details">
                <div class="notice-content">
                    <h2>
                        <?php 
                        /* translators: %s: Theme name */
                        printf(
                            esc_html__( 'Thank you for installing %s.', 'prime-playschool-classes' ),
                            '<strong>' . esc_html( $theme_name ) . '</strong>'
                        );
                        ?>
                    </h2>
                    <p><?php echo esc_html__( 'Your journey to a powerful and stylish website begins here. Let’s get everything set up in just a few clicks!', 'prime-playschool-classes' ); ?></p>
                    <div class="notice-btns">
                        <a style="margin-bottom: 15px; padding: 8px 15px;" class="button button-primary getstart"
                           href="<?php echo esc_url( admin_url( 'themes.php?page=prime-playschool-classes' ) ); ?>">
                           <?php esc_html_e( 'Getting Started', 'prime-playschool-classes' ); ?>
                        </a>
                        <a style="margin-left: 30px; margin-bottom: 15px; padding: 8px 15px;" class="button button-primary import"
                           href="<?php echo esc_url(admin_url('themes.php?page=primekindergarten-wizard')); ?>"><?php esc_html_e('Demo Importer', 'prime-playschool-classes') ?></a>                        
                        <a style="margin-left: 30px; padding: 8px 15px;" class="button button-primary premium"
                           target="_blank" href="<?php echo esc_url( 'https://themeignite.com/products/prime-classes-wordpress-theme' ); ?>">
                           <?php esc_html_e( 'Go To Premium', 'prime-playschool-classes' ); ?>
                        </a>
                    </div>
                </div>
                <div class="notice-img">
                    <img src="<?php echo esc_url( get_template_directory_uri() . '/images/notice.png' ); ?>" alt="<?php echo esc_attr( $theme_name ); ?>">
                </div>  
            </div>
        </div>
        <?php
    }
}

function prime_kindergarten_template_setup() {

if ( ! defined( 'PRIME_PLAYSCHOOL_CLASSES_URL' ) ) {
    define( 'PRIME_PLAYSCHOOL_CLASSES_URL', esc_url( 'https://www.themeignite.com/products/kindergarten-wordpress-theme', 'prime-kindergarten') );
}
if ( ! defined( 'PRIME_PLAYSCHOOL_CLASSES_TEXT' ) ) {
    define( 'PRIME_PLAYSCHOOL_CLASSES_TEXT', __( 'Prime Kindergarten PRO','prime-kindergarten' ));
}
if ( ! defined( 'PRIME_PLAYSCHOOL_CLASSES_FOOTER_URL' ) ) {
  define( 'PRIME_PLAYSCHOOL_CLASSES_FOOTER_URL', esc_url( 'https://www.themeignite.com/products/free-kindergarten-wordpress-theme', 'prime-kindergarten') );
}
if ( ! defined( 'PRIME_PLAYSCHOOL_CLASSES_FREE_DOC_URL' ) ) {
    define( 'PRIME_PLAYSCHOOL_CLASSES_FREE_DOC_URL', esc_url( 'https://demo.themeignite.com/documentation/prime-kindergarten-free/', 'prime-kindergarten') );
}
if ( ! defined( 'PRIME_PLAYSCHOOL_CLASSES_DOC_URL' ) ) {
    define( 'PRIME_PLAYSCHOOL_CLASSES_DOC_URL', esc_url( 'https://demo.themeignite.com/documentation/prime-kindergarten-free/', 'prime-kindergarten') );
}
if ( ! defined( 'PRIME_PLAYSCHOOL_CLASSES_PRO_DOC_URL' ) ) {
    define( 'PRIME_PLAYSCHOOL_CLASSES_PRO_DOC_URL', esc_url( 'https://demo.themeignite.com/documentation/prime-kindergarten-pro/', 'prime-kindergarten') );
}
if ( ! defined( 'PRIME_PLAYSCHOOL_CLASSES_DEMO_URL' ) ) {
    define( 'PRIME_PLAYSCHOOL_CLASSES_DEMO_URL', esc_url( 'https://demo.themeignite.com/prime-kindergarten/', 'prime-kindergarten') );
}
if ( ! defined( 'PRIME_PLAYSCHOOL_CLASSES_REVIEW_URL' ) ) {
    define( 'PRIME_PLAYSCHOOL_CLASSES_REVIEW_URL', esc_url( 'https://www.wordpress.org/support/theme/prime-kindergarten/reviews/#new-post', 'prime-kindergarten') );
}
if ( ! defined( 'PRIME_PLAYSCHOOL_CLASSES_SUPPORT_URL' ) ) {
    define( 'PRIME_PLAYSCHOOL_CLASSES_SUPPORT_URL', esc_url( 'https://www.wordpress.org/support/theme/prime-kindergarten', 'prime-kindergarten') );
}

/**
 * Setup Wizard
 */
if (is_child_theme() && wp_get_theme()->get('Name') === 'Prime Kindergarten') {
    require get_theme_file_path() . '/theme-wizard/config.php';

// Hook to display the notice
add_action( 'admin_notices', 'prime_playschool_classes_dashboard_notice_child' );
}

}
add_action('after_setup_theme', 'prime_kindergarten_template_setup');