<?php 
/**
 * Template part for displaying Slider Section
 *
 * @package prime-industry
 */

$data_slick_speed = prime_industry_get_option('data_slick_speed');
$data_slick_infinite = prime_industry_get_option('data_slick_infinite');
$data_slick_dots = prime_industry_get_option('data_slick_dots');
$data_slick_autoplay = prime_industry_get_option('data_slick_autoplay');
$data_slick_draggable = prime_industry_get_option('data_slick_draggable');
$data_slick_fade = prime_industry_get_option('data_slick_fade');
$featured_slider_content_type = prime_industry_get_option('featured_slider_content_type');
$prime_industry_number_of_featured_slider_items = prime_industry_get_option('number_of_featured_slider_items');
// $slider_enable_section               = get_theme_mod('slider_enable_section', 'on');

?>
<?php if (!get_theme_mod('slider_enable_section', true)) {
    return;
} ?>

<?php
// Convert numeric options to boolean strings for slick carousel
$data_slick_infinite = $data_slick_infinite ? 'true' : 'false';
$data_slick_dots = $data_slick_dots ? 'true' : 'false';
$data_slick_autoplay = $data_slick_autoplay ? 'true' : 'false';
$data_slick_draggable = $data_slick_draggable ? 'true' : 'false';
$data_slick_fade = $data_slick_fade ? 'true' : 'false';
?>

<div id="featured-slider">
    <div class="section-content"
        data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": <?php echo esc_attr($data_slick_infinite); ?>, "speed": <?php echo esc_attr($data_slick_speed); ?>, "dots": <?php echo esc_attr($data_slick_dots); ?>, "autoplay": <?php echo esc_attr($data_slick_autoplay); ?>, "draggable": <?php echo esc_attr($data_slick_draggable); ?>, "fade": <?php echo esc_attr($data_slick_fade); ?> }'>

        <?php
           $prime_industry_number_of_featured_slider_items = absint( get_theme_mod('number_of_featured_slider_items', 5) ); // Ensure the value is an integer

           // Ensure the number of posts starts from 1, and not showing any extras
           if ($prime_industry_number_of_featured_slider_items < 1) {
               $prime_industry_number_of_featured_slider_items = 1; // Ensure minimum value is 1
           }
        
           ?> <?php $prime_industry_slider_pages = array(); 
			    for ( $count = 1; $count <= 4; $count++ ) {
			        $mod = intval( get_theme_mod( 'select_post_slider'. $count ));
			        if ( 'page-none-selected' != $mod ) {
			          $prime_industry_slider_pages[] = $mod;
			        }
			    }
		      	if( !empty($prime_industry_slider_pages) ) :
			        $args = array(
			          	'post_type' => 'post',
			          	'post__in' => $prime_industry_slider_pages,
                        'posts_per_page' => $prime_industry_number_of_featured_slider_items,
			          	'orderby' => 'post__in'
			        );
		        	$prime_industry_catquery = new WP_Query( $args );
        
           $prime_industry_catquery_counter = 0; // Initialize counter
           while ($prime_industry_catquery->have_posts() && $prime_industry_catquery_counter < $prime_industry_number_of_featured_slider_items) : $prime_industry_catquery->the_post();
           $prime_industry_catquery_counter++;

               $featured_slider_section_heading  = prime_industry_get_option( 'featured_slider_section_heading' );
    ?>
        <article>
            <div class="opbg">
                <div class="slide-inner slide-bg-image">
                    <div class="sliderimg">
                        <img class="d-block w-100" src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>">
                    </div>
                    <div class="row d-flex align-items-left">
                        <div class="slider-inner-mainbox">
                            <?php if (get_theme_mod('featured_slider_overlayimg_enable', true)) : ?>
                            <!-- Additional content if enabled -->
                            <?php endif; ?>
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 leftcontentbox <?php echo esc_attr(get_theme_mod('prime_industry_featured_slider_onload_effects', 'wow zoomIn')); ?>"
                                data-wow-duration="2s">
                                <div class="wrapper animated <?php echo esc_attr(get_theme_mod('prime_industry_featured_slider_onload_effects','wow Bounce In Up')); ?>"
                                    data-wow-duration="2s">
                                    <div class="entry-container" style="text-align: left">
                                    <div class="mt-4 content">
                                            <h3
                                                style="text-transform : <?php if(get_theme_mod('featured_slider_subtitle_case','None') == 'None'){ ?> none <?php } elseif(get_theme_mod('featured_slider_subtitle_case','Lowercase') == 'Lowercase'){ ?> lowercase <?php } elseif(get_theme_mod('featured_slider_subtitle_case','Capitalize') == 'Capitalize'){ ?> capitalize <?php } elseif(get_theme_mod('featured_slider_subtitle_case','Uppercase') == 'Uppercase'){ ?> uppercase <?php } ?>">
                                                <!-- </?php the_title(); ?></?php
                                                $content_limit = 2;               
                                                echo wp_trim_words(get_the_content(), $content_limit,'');                                     -->
                                               <?php echo ($featured_slider_section_heading);?>
                                        </h3>

                                        </div>
                                        <h2 class="entry-title"
                                            style="text-transform : <?php if(get_theme_mod('featured_slider_title_case','None') == 'None'){ ?> none <?php } elseif(get_theme_mod('featured_slider_title_case','Lowercase') == 'Lowercase'){ ?> lowercase <?php } elseif(get_theme_mod('featured_slider_title_case','Capitalize') == 'Capitalize'){ ?> capitalize <?php } elseif(get_theme_mod('featured_slider_title_case','Uppercase') == 'Uppercase'){ ?> uppercase <?php } ?>;  text-align: Left ">
                                            <?php the_title(); ?></h2>
                                       
                                        <div class="entry-content animated flipInY" style="text-align : <?php if(get_theme_mod('featured_slider_box_align','Left') == 'Left'){ ?> Left <?php } elseif(get_theme_mod('featured_slider_box_align','Center') == 'Center'){ ?> Center <?php } elseif(get_theme_mod('featured_slider_box_align','Right') == 'Right'){ ?> right <?php } ?> ">
                                                            <?php
                                                                $excerpt = prime_industry_the_excerpt( 19 );
                                                                echo wp_kses_post( wpautop( $excerpt ) );
                                                            ?>
                                                        </div><!-- .entry-content -->
                                        <div
                                            class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                            <div class="d-flex">
                                                <!-- <div class="">
                                                    <div class="sliderbut1 animated flipInY me-2">
                                                        <a href="#"
                                                            class="btn1 btn-custom1 rounded1"></?php echo esc_html(get_theme_mod('prime_industry_button1_text','PROJECTS')); ?></a>
                                                    </div>
                                                </div> -->
                                                <div class="sliderbutton">
                                                    <div class="sliderbut2 animated flipInY mx-2">
                                                        <a href="#"
                                                            class="btn2 btn-custom2 rounded2"><?php echo esc_html(get_theme_mod('prime_industry_button2_text','CONTACT US')); ?></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- .entry-container -->
                                </div><!-- .wrapper -->
                            </div><!-- .leftcontentbox -->
                        </div><!-- .slider-inner-mainbox -->
                    </div><!-- .row -->
                </div><!-- .slide-inner -->
            </div><!-- .opbg -->
        </article>
        <?php endwhile; ?>
        <?php endif;?>
        <?php wp_reset_postdata(); ?>
    </div><!-- .section-content -->
</div>