<?php
/**
 * Template part for displaying Featured Features Section
 * @package prime-industry
 */

if (!get_theme_mod('enable_featured_features_section', true)) {
    return;
}

$featured_features_column = 3;

// $featured_features_title1 = prime_industry_get_option('featured_features_title1');
// $featured_features_text1 = prime_industry_get_option('featured_features_text1');
// $featured_icon_features1 = prime_industry_get_option('featured_icon_features1');

$featured_features_title1 = prime_industry_get_option('featured_features_title1') ?: 'Buildings';
$featured_features_text1  = prime_industry_get_option('featured_features_text1') ?: "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or";
$featured_icon_features1  = prime_industry_get_option('featured_icon_features1') ?: 'fas fa-user-graduate';

$featured_features_title2 = prime_industry_get_option('featured_features_title2') ?: 'Civil Infrastructure';
$featured_features_text2  = prime_industry_get_option('featured_features_text2') ?: "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or";
$featured_icon_features2  = prime_industry_get_option('featured_icon_features2') ?: 'fas fas fa-city';

$featured_features_title3 = prime_industry_get_option('featured_features_title3') ?: 'Multipurpose';
$featured_features_text3  = prime_industry_get_option('featured_features_text3') ?: "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or";
$featured_icon_features3  = prime_industry_get_option('featured_icon_features3') ?: 'fas fa-user-graduate';


// $featured_features_title2 = prime_industry_get_option('featured_features_title2');
// $featured_features_text2 = prime_industry_get_option('featured_features_text2');
// $featured_icon_features2 = prime_industry_get_option('featured_icon_features2');

// $featured_features_title3 = prime_industry_get_option('featured_features_title3');
// $featured_features_text3 = prime_industry_get_option('featured_features_text3');
// $featured_icon_features3 = prime_industry_get_option('featured_icon_features3');
?>

<div id="featured-features">
    <div class="feature-overlay"></div>
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div
                    class="section-content grid gap-12 xl:grid-cols-<?php echo esc_attr($featured_features_column); ?> lg:grid-cols-<?php echo esc_attr($featured_features_column); ?> md:grid-cols-2 sm:grid-cols-1 grid-cols-1">

                    <!-- Feature 1 -->
                    <article
                        class="features-block <?php echo esc_attr(get_theme_mod('prime_industry_featured_features_onload_effects', 'wow zoomIn')); ?>"
                        data-wow-duration="2s">
                        <div class="featuresbox">
                            <div class="featuretextcontainer">
                                <h4 class="features-title"><a><?php echo esc_html($featured_features_title1); ?></a>
                                </h4>
                                <div class="features-details">
                                    <p><?php echo esc_html($featured_features_text1); ?></p>
                                </div>
                                <div class="features-icon"><i
                                        class="<?php echo esc_attr($featured_icon_features1); ?>"></i>
                                </div>
                            </div>
                        </div>
                    </article>

                    <!-- Feature 2 -->
                    <article
                        class="features-block <?php echo esc_attr(get_theme_mod('prime_industry_featured_features_onload_effects', 'wow zoomIn')); ?>"
                        data-wow-duration="2s">
                        <div class="featuresbox">
                            <div class="featuretextcontainer">
                                <h4 class="features-title"><a><?php echo esc_html($featured_features_title2); ?></a>
                                </h4>
                                <div class="features-details">
                                    <p><?php echo esc_html($featured_features_text2); ?></p>
                                </div>
                                <div class="features-icon"><i
                                        class="<?php echo esc_attr($featured_icon_features2); ?>"></i>
                                </div>
                            </div>
                        </div>
                    </article>

                    <!-- Feature 3 -->
                    <article
                        class="features-block <?php echo esc_attr(get_theme_mod('prime_industry_featured_features_onload_effects', 'wow zoomIn')); ?>"
                        data-wow-duration="2s">
                        <div class="featuresbox">
                            <div class="featuretextcontainer">
                                <h4 class="features-title"><a><?php echo esc_html($featured_features_title3); ?></a> 
                                </h4>
                                <div class="features-details">
                                    <p><?php echo esc_html($featured_features_text3); ?></p>
                                </div>
                                <div class="features-icon"><i
                                        class="<?php echo esc_attr($featured_icon_features3); ?>"></i>
                                </div>
                            </div>
                        </div>
                    </article>

                </div>
            </div>
        </div>
    </div>
</div>