<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package prime-industry
 */

?>
<div class="maincontent">
    <div class="post-item">
        <?php 				
		// Wrap the thumbnail in an anchor tag linking to the post
			echo '<a href="' . get_permalink() . '">';
		?>
        <div class="featured-image">
            <div class="entry-meta d-flex">
                <div>
                    <h4 class="post-date">
                        <i class="fa-solid fa-calendar-days me-2"></i> <a
                            href="<?php the_permalink();?>"><?php echo esc_html(get_the_date('F j Y')); ?></a>
                    </h4>
                </div>

                <div class="post-comment">
                    <i class="fa-regular fa-comments me-2"></i><a href="javascript:void(0);" class="">Comment
                        (<?php echo esc_html(get_comments_number()); ?>) </a>
                </div>

            </div><!-- .entry-meta -->
        </div>
        <?php
			echo '</a>';
				
		?>
        <div class="entry-container">
            <header class="pb-3">
                <h2 class="page-title mb-0">
                    <?php
				// Wrap the post title in an anchor tag linking to the post
				echo '<a href="' . esc_url(get_permalink()) . '">' . esc_html(get_the_title()) . '</a>';
				?>
                </h2>
                <!-- <div class="post-details mt-2">
                    </?php $prime_industry_author = get_theme_mod('prime_industry_post_hide_author',false);
					if($prime_industry_author === false){ ?>
                    <span
                        class="me-2 entry-by"></?php echo esc_html(get_theme_mod('prime_industry_meta_field_by', '- By'));?></span><span
                        class="entry-author"><a
                            href="</?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"></?php the_author(); ?><span
                                class="screen-reader-text"></?php the_author(); ?></span></a></span>
                    </?php } ?>

                    </?php $prime_industry_time = get_theme_mod('prime_industry_post_hide_time',false);
				if($prime_industry_time === false){ ?>
                    <span
                        class="mx-2"></?php echo esc_html(get_theme_mod('prime_industry_meta_field_separator', '|'));?></span><span
                        class="entry-time"></?php echo esc_html( get_the_time() ); ?></span>
                    </?php } ?>
                </div> -->
            </header>
            <!-- </?php the_content(); ?> -->
            <p><?php
			// Set a word limit, e.g., 40 words
			$content_limit = 18; 

			// Get the content and trim it
			echo wp_trim_words(get_the_content(), $content_limit, '...');
		?></p>
        <p><?php
            // Optionally add a 'Read More' link
			echo '<a class="readbtn mx-1" href="' . get_permalink() . '">' . __('Read More', 'prime-industry') . '</a>';
            ?>
        </p>
        </div>

    </div>

</div>