<?php 
 /*
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package prime-industry
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php if(get_theme_mod('show_metatext_on_off',true) == true ){  ?>
		<div class="entry-meta">
				<?php prime_industry_posted_on();
				prime_industry_entry_meta(); ?>
		</div><!-- .entry-meta -->	
	<?php } ?>
	
	<div class="entry-content sin mt-4">
		<?php the_content(); ?>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'prime-industry' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->
	<?php prime_industry_posts_tags(); ?>
	<?php if ( get_edit_post_link() ) : ?>
		<footer class="entry-footer">
			<?php
				edit_post_link(
					sprintf(
						/* translators: %s: Name of current post */
						esc_html__( 'Edit %s', 'prime-industry' ),
						the_title( '<span class="screen-reader-text">"', '"</span>', false )
					),
					'<span class="edit-link">',
					'</span>'
				);
			?>
		</footer><!-- .entry-footer -->
	<?php endif; ?>	
</article><!-- #post-## -->