<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package prime-industry
 */
?>
<aside id="secondary" class="widget-area">
	<?php dynamic_sidebar( 'sidebar-1' ); ?>
</aside><!-- #secondary -->

<?php 
  if ( ! is_active_sidebar( 'sidebar-1' )) { ?>
<aside id="secondary" class="widget-area">
    <section id="Search" class="widget widget_block widget_archive ">
        <h2 class="widget-title"><?php esc_html_e('Search', 'prime-industry'); ?></h2>
        <?php get_search_form(); ?>
    </section>
    <section id="recent-posts" class="widget" role="complementary">
        <h2 class="widget-title"><?php esc_html_e('Recent Posts', 'prime-industry'); ?></h2>
        <ul class="recent-posts-list">
            <?php
		        $prime_industry_recent_posts = get_posts(array(
		            'numberposts' => 5, // Adjust the number of posts to display
		            'post_status' => 'publish',
		        ));

		        foreach ($prime_industry_recent_posts as $prime_industry_post) :
		            setup_postdata($prime_industry_post);
		            ?>
            <li>
                <a href="<?php echo get_permalink($prime_industry_post->ID); ?>">
                    <?php echo esc_html(get_the_title($prime_industry_post->ID)); ?>
                </a>
            </li>
            <?php
		        endforeach;
		        wp_reset_postdata();
		        ?>
        </ul>
    </section>
    <section id="archives" class="widget widget_block widget_archive ">
        <h2 class="widget-title"><?php esc_html_e('Archives', 'prime-industry'); ?></h2>
        <ul>
            <?php
		        wp_get_archives(array(
		            'type'            => 'monthly',
		            'show_post_count' => true,
		        ));
		        ?>
        </ul>
    </section>
    <section id="categories" class="widget widget_categories" role="complementary">
        <h2 class="widget-title"><?php esc_html_e('Categories', 'prime-industry'); ?></h2>
        <ul>
            <?php
		        wp_list_categories(array(
		            'orderby'    => 'name',
		            'title_li'   => '',
		            'show_count' => true,
		        ));
		        ?>
        </ul>
    </section>


</aside><!-- #secondary -->
<?php } ?>
