<?php
/**
 * Sanitization functions.
 *
 * @package prime-industry
 */

if ( ! function_exists( 'prime_industry_sanitize_select' ) ) :

	/**
	 * Sanitize select.
	 *
	 * @since 1.0.0
	 *	
	 */
	function prime_industry_sanitize_select( $input, $setting ) {

		// Ensure input is a slug.
		$input = sanitize_key( $input );

		// Get list of choices from the control associated with the setting.
		$choices = $setting->manager->get_control( $setting->id )->choices;

		// If the input is a valid key, return it; otherwise, return the default.
		return ( array_key_exists( $input, $choices ) ? $input : $setting->default );

	}

endif;

if ( ! function_exists( 'prime_industry_dropdown_pages' ) ) :
	function prime_industry_dropdown_pages( $page_id, $setting ) {
	  // Ensure $input is an absolute integer.
	  $page_id = absint( $page_id );
	  
	  // If $page_id is an ID of a published page, return it; otherwise, return the default.
	  return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
	}
endif;

if ( ! function_exists( 'prime_industry_dropdown_posts' ) ) :

	/**
	 * Post Dropdown.
	 *
	 * @since 1.0.0	 *
	 */
	function prime_industry_dropdown_posts() {

		$posts = get_posts( array( 'numberposts' => -1 ) );
		$choices = array();
		$choices[0] = esc_html__( '--Select--', 'prime-industry' );
		foreach ( $posts as $post ) {
			$choices[$post->ID] = $post->post_title;
		}
		return $choices;
	}

endif;

if ( ! function_exists( 'prime_industry_dropdown_sliders' ) ) :

	/**
	 * Post Dropdown.
	 *
	 * @since 1.0.0	 *
	 */
	function prime_industry_dropdown_sliders() {

		$posts = get_posts( array( 'post_type'   => 'sliders', 'numberposts' => -1 ) );
		$choices = array();
		$choices[0] = esc_html__( '--Select--', 'prime-industry' );
		foreach ( $posts as $post ) {
			$choices[$post->ID] = $post->post_title;
		}
		return $choices;
	}

endif;

if ( ! function_exists( 'prime_industry_dropdown_features' ) ) :

	/**
	 * Post Dropdown.
	 *
	 * @since 1.0.0	 *
	 */
	function prime_industry_dropdown_features() {

		$posts = get_posts( array( 'post_type'   => 'features', 'numberposts' => -1 ) );
		$choices = array();
		$choices[0] = esc_html__( '--Select--', 'prime-industry' );
		foreach ( $posts as $post ) {
			$choices[$post->ID] = $post->post_title;
		}
		return $choices;
	}

endif;

if ( ! function_exists( 'prime_industry_sanitize_counter_with_text' ) ) :
    function prime_industry_sanitize_counter_with_text( $input, $setting ) {
        // Extract number from the input string
        preg_match('/\d+/', $input, $matches);
        $number = isset($matches[0]) ? floatval($matches[0]) : 0;

        // Get the text part (everything after the number)
        $text_part = preg_replace('/\d+/', '', $input);
        $text_part = trim($text_part);

        // Return the sanitized combined string
        return $number . ' ' . $text_part;
    }
endif;




if ( ! function_exists( 'prime_industry_dropdown_counters' ) ) :

	/**
	 * Post Dropdown.
	 *
	 * @since 1.0.0	 *
	 */
	function prime_industry_dropdown_counters() {

		$posts = get_posts( array( 'post_type'   => 'counters', 'numberposts' => -1 ) );
		$choices = array();
		$choices[0] = esc_html__( '--Select--', 'prime-industry' );
		foreach ( $posts as $post ) {
			$choices[$post->ID] = $post->post_title;
		}
		return $choices;
	}

endif;

if ( ! function_exists( 'prime_industry_dropdown_services' ) ) :

	/**
	 * Post Dropdown.
	 *
	 * @since 1.0.0	 *
	 */
	function prime_industry_dropdown_services() {

		$posts = get_posts( array( 'post_type'   => 'services', 'numberposts' => -1 ) );
		$choices = array();
		$choices[0] = esc_html__( '--Select--', 'prime-industry' );
		foreach ( $posts as $post ) {
			$choices[$post->ID] = $post->post_title;
		}
		return $choices;
	}

endif;

// / project
if ( ! function_exists( 'prime_industry_dropdown_projects' ) ) :

	/**
	 * Post Dropdown.
	 *
	 * @since 1.0.0	 *
	 */
	function prime_industry_dropdown_projects() {

		$posts = get_posts( array( 'post_type'   => 'projects', 'numberposts' => -1 ) );
		$choices = array();
		$choices[0] = esc_html__( '--Select--', 'prime-industry' );
		foreach ( $posts as $post ) {
			$choices[$post->ID] = $post->post_title;
		}
		return $choices;
	}

endif;


if ( ! function_exists( 'prime_industry_dropdown_upcoming' ) ) :

	/**
	 * Post Dropdown.
	 *
	 * @since 1.0.0	 *
	 */
	function prime_industry_dropdown_upcoming() {

		$posts = get_posts( array( 'post_type'   => 'events', 'numberposts' => -1 ) );
		$choices = array();
		$choices[0] = esc_html__( '--Select--', 'prime-industry' );
		foreach ( $posts as $post ) {
			$choices[$post->ID] = $post->post_title;
		}
		return $choices;
	}

endif;

if ( ! function_exists( 'prime_industry_dropdown_gallery' ) ) :

	/**
	 * Post Dropdown.
	 *
	 * @since 1.0.0	 *
	 */
	function prime_industry_dropdown_gallery() {

		$posts = get_posts( array( 'post_type'   => 'gallery', 'numberposts' => -1 ) );
		$choices = array();
		$choices[0] = esc_html__( '--Select--', 'prime-industry' );
		foreach ( $posts as $post ) {
			$choices[$post->ID] = $post->post_title;
		}
		return $choices;
	}

endif;

if ( ! function_exists( 'prime_industry_dropdown_testimonials' ) ) :

	/**
	 * Post Dropdown.
	 *
	 * @since 1.0.0	 *
	 */
	function prime_industry_dropdown_testimonials() {

		$posts = get_posts( array( 'post_type'   => 'testimonials', 'numberposts' => -1 ) );
		$choices = array();
		$choices[0] = esc_html__( '--Select--', 'prime-industry' );
		foreach ( $posts as $post ) {
			$choices[$post->ID] = $post->post_title;
		}
		return $choices;
	}

endif;

if ( ! function_exists( 'prime_industry_dropdown_team' ) ) :

	/**
	 * Post Dropdown.
	 *
	 * @since 1.0.0	 *
	 */
	function prime_industry_dropdown_team() {

		$posts = get_posts( array( 'post_type'   => 'team', 'numberposts' => -1 ) );
		$choices = array();
		$choices[0] = esc_html__( '--Select--', 'prime-industry' );
		foreach ( $posts as $post ) {
			$choices[$post->ID] = $post->post_title;
		}
		return $choices;
	}

endif;


if ( ! function_exists( 'prime_industry_dropdown_clients' ) ) :

	/**
	 * Post Dropdown.
	 *
	 * @since 1.0.0	 *
	 */
	function prime_industry_dropdown_clients() {

		$posts = get_posts( array( 'post_type'   => 'clients', 'numberposts' => -1 ) );
		$choices = array();
		$choices[0] = esc_html__( '--Select--', 'prime-industry' );
		foreach ( $posts as $post ) {
			$choices[$post->ID] = $post->post_title;
		}
		return $choices;
	}

endif;

if ( ! function_exists( 'prime_industry_dropdown_faqs' ) ) :

	/**
	 * Post Dropdown.
	 *
	 * @since 1.0.0	 *
	 */
	function prime_industry_dropdown_faqs() {

		$posts = get_posts( array( 'post_type'   => 'faqs', 'numberposts' => -1 ) );
		$choices = array();
		$choices[0] = esc_html__( '--Select--', 'prime-industry' );
		foreach ( $posts as $post ) {
			$choices[$post->ID] = $post->post_title;
		}
		return $choices;
	}

endif;

if ( ! function_exists( 'prime_industry_sanitize_checkbox' ) ) :

	/**
	 * Sanitize checkbox.
	 *
	 * @since 1.0.0
	 *	
	 */
	function prime_industry_sanitize_checkbox( $checked ) {

		return ( ( isset( $checked ) && true === $checked ) ? true : false );

	}

endif;

if ( ! function_exists( 'prime_industry_switch_sanitization' ) ) :

function prime_industry_switch_sanitization( $input ) {
    if ( true === $input ) {
        return 1;
    } else {
        return 0;
    }
}

endif;

if ( ! function_exists( 'prime_industry_sanitize_choices' ) ) :

function prime_industry_sanitize_choices( $input, $setting ) {
    global $wp_customize; 
    $control = $wp_customize->get_control( $setting->id ); 
    if ( array_key_exists( $input, $control->choices ) ) {
        return $input;
    } else {
        return $setting->default;
    }
}

endif;


if ( ! function_exists( 'prime_industry_sanitize_float' ) ) :

function prime_industry_sanitize_float( $input ) {
    return filter_var($input, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
}

endif;

if ( ! function_exists( 'prime_industry_sanitize_number_range' ) ) :

	/**
	 * Sanitize number range.
	 *	
	 */
	function prime_industry_sanitize_number_range( $input, $setting ) {

	    // Get the input attributes associated with the setting.
	    $atts = $setting->manager->get_control($setting->id)->input_attrs;

	    // Ensure input is a float within the specified range.
	    $input = floatval($input);
	    $min = isset($atts['min']) ? $atts['min'] : 0;
	    $max = isset($atts['max']) ? $atts['max'] : 1;
	    $step = isset($atts['step']) ? $atts['step'] : 0.1;

	    // Sanitize the input.
	    $input = max($min, min($max, $input));
	    $input = round($input / $step) * $step;

	    return $input;
	}

endif;



if ( ! function_exists( 'prime_industry_sanitize_imageheight_number_range' ) ) :

	/**
	 * Sanitize image height number range.
	 *	
	 */
	function prime_industry_sanitize_imageheight_number_range( $input, $setting ) {

	    // Get the input attributes associated with the setting.
	    $atts = $setting->manager->get_control($setting->id)->input_attrs;

	    // Ensure input is a float within the specified range.
	    $input = floatval($input);
	    $min = isset($atts['min']) ? $atts['min'] : 0;
	    $max = isset($atts['max']) ? $atts['max'] : 1000000000;
	    $step = isset($atts['step']) ? $atts['step'] : 1;

	    // Sanitize the input.
	    $input = max($min, min($max, $input));
	    $input = round($input / $step) * $step;

	    return $input;
	}

endif;

if ( ! function_exists( 'prime_industry_sanitize_fontsize_number_range' ) ) :

	/**
	 * Sanitize font size number range.
	 *	
	 */
	function prime_industry_sanitize_fontsize_number_range( $input, $setting ) {

	    // Get the input attributes associated with the setting.
	    $atts = $setting->manager->get_control($setting->id)->input_attrs;

	    // Ensure input is a float within the specified range.
	    $input = floatval($input);
	    $min = isset($atts['min']) ? $atts['min'] : 0;
	    $max = isset($atts['max']) ? $atts['max'] : 100;
	    $step = isset($atts['step']) ? $atts['step'] : 1;

	    // Sanitize the input.
	    $input = max($min, min($max, $input));
	    $input = round($input / $step) * $step;

	    return $input;
	}

endif;


if ( ! function_exists( 'prime_industry_sanitize_fontweight_number_range' ) ) :

	/**
	 * Sanitize font weight number range.
	 *	
	 */
	function prime_industry_sanitize_fontweight_number_range( $input, $setting ) {

	    // Get the input attributes associated with the setting.
	    $atts = $setting->manager->get_control($setting->id)->input_attrs;

	    // Ensure input is a float within the specified range.
	    $input = floatval($input);
	    $min = isset($atts['min']) ? $atts['min'] : 0;
	    $max = isset($atts['max']) ? $atts['max'] : 1000;
	    $step = isset($atts['step']) ? $atts['step'] : 100;

	    // Sanitize the input.
	    $input = max($min, min($max, $input));
	    $input = round($input / $step) * $step;

	    return $input;
	}

endif;

if ( ! function_exists( 'prime_industry_sanitize_textarea_content' ) ) :

	/**
	 * Sanitize textarea content.
	 *
	 * @since 1.0.0
	 *
	 */
	function prime_industry_sanitize_textarea_content( $input, $setting ) {

		return ( stripslashes( wp_filter_post_kses( addslashes( $input ) ) ) );

	}
endif;

if ( ! function_exists( 'prime_industry_sanitize_positive_integer' ) ) :

	/**
	 * Sanitize positive integer.
	 *
	 * @since 1.0.0
	 *
	 * @param int                  $input Number to sanitize.
	 * @param WP_Customize_Setting $setting WP_Customize_Setting instance.
	 * @return int Sanitized number; otherwise, the setting default.
	 */
	function prime_industry_sanitize_positive_integer( $input, $setting ) {

		$input = absint( $input );

		// If the input is an positive integer, return it.
		// otherwise, return the default.
		return ( $input ? $input : $setting->default );
	}

endif;

// Integer sanitization (already correct)
if ( ! function_exists( 'prime_industry_sanitize_integer' ) ) {
    function prime_industry_sanitize_integer( $input ) {
        return intval( $input );
    }
}


/* Excerpt Limit Begin */
function prime_industry_string_limit_words($string, $word_limit) {
    $words = explode(' ', $string, ($word_limit + 1));
    if(count($words) > $word_limit)
    array_pop($words);
    return implode(' ', $words);
}

/**
 * Image sanitization callback example.
 *
 * Checks the image's file extension and mime type against a whitelist. If they're allowed,
 * send back the filename, otherwise, return the setting default.
 *
 * - Sanitization: image file extension
 * - Control: text, WP_Customize_Image_Control
 * 
 * @see wp_check_filetype() https://developer.wordpress.org/reference/functions/wp_check_filetype/
 *
 * @param string               $image   Image filename.
 * @param WP_Customize_Setting $setting Setting instance.
 * @return string The image filename if the extension is allowed; otherwise, the setting default.
 */
function prime_industry_sanitize_image( $image, $setting ) {
    /*
     * Array of valid image file types.
     *
     * The array includes image mime types that are included in wp_get_mime_types()
     */
    $mimes = array(
        'jpg|jpeg|jpe' => 'image/jpeg',
        'gif'          => 'image/gif',
        'png'          => 'image/png',
        'bmp'          => 'image/bmp',
        'tif|tiff'     => 'image/tiff',
        'ico'          => 'image/x-icon'
    );
    // Return an array with file extension and mime_type.
    $file = wp_check_filetype( $image, $mimes );
    // If $image has a valid mime_type, return it; otherwise, return the default.
    return ( $file['ext'] ? $image : $setting->default );
}

/**
 * Sanitize social links.
 *
 * @since 1.0.0
 *
 * @param mixed                $input The value to sanitize.
 * @param WP_Customize_Setting $setting WP_Customize_Setting instance.
 * @return mixed Sanitized value.
 */
function prime_industry_sanitize_social_links( $input, $setting ) {

	if ( empty( $input ) ) {
		return '';
	}

	$exploded = explode( '|', $input );
	$new_array = array_map( 'esc_url_raw', $exploded );
	$output = implode( '|', $new_array );

	return $output;
}

if ( ! function_exists( 'prime_industry_sanitize_sortable' ) ) :
	/**
	* Sanitizes strings in array
	* @param  $input entered value
	* @return sanitized output
	*
	* @since prime_industry 1.0
	*/
	function prime_industry_sanitize_sortable( $input ) {

		// Ensure $input is an array.
		if ( ! is_array( $input ) )
			$input = explode( ',', $input );

		$output = array_map( 'sanitize_text_field', $input );

		return implode( ',', $output );
	}
endif;

/**
* Sanitizes email
* @param  $input entered value
* @return sanitized output
*
* @since Creativ Musician 1.0
*/
function prime_industry_sanitize_array_int( $input ) {

	// Ensure $input is an url.
	$links = array_map( 'absint', $input );

	return $links;
}

if ( ! function_exists( 'prime_industry_sanitize_phone_number' ) ) :

	/**
	 * Sanitize Phone number.
	 *
	 * @since 1.0.0
	 *	
	 */
	function prime_industry_sanitize_phone_number( $phone ) {
		return preg_replace( '/[^\d+]/', '', $phone );
	}

endif;


