<?php 
/**
 * Home Section
 *
 * @package prime-industry
 */
$default = prime_industry_get_default_theme_options();

/** Slider Info section */
$wp_customize->add_section(
    'featured_slider_info_section',
    array(
        'title'    => __( 'Slider Info', 'prime-industry' ),      
        'priority' => 1,
        'panel'      => 'prime_industry_section_panel',       	
    )
);

// Enable Section
$wp_customize->add_setting(
    'slider_enable_section',
    array(
        'default' 			=> true,
       'sanitize_callback' => 'prime_industry_sanitize_switch',

    )
);
$wp_customize->add_control(
    new prime_industry_Toggle_Checkbox_Custom_control(
        $wp_customize,
        'slider_enable_section',
        array(
            'settings'      => 'slider_enable_section',
            'section'       => 'featured_slider_info_section',
            'label'         => __( 'Enable Section', 'prime-industry' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'prime-industry' ),
                'off' => __( 'No', 'prime-industry' )
            ),
        )
    )
);

// /// effects
$wp_customize->add_setting('prime_industry_featured_slider_onload_effects',array(
    'default' => 'Bounce In Up',
    'sanitize_callback' => 'prime_industry_sanitize_choices',
));
$wp_customize->add_control('prime_industry_featured_slider_onload_effects',array(
    'type' => 'select',
    'label' => __('Box Onload Transition Effects','prime-industry'),
    'choices' => array (
        'wow bounceInLeft' => __('Bounce In Left','prime-industry'),
        'wow bounceInRight' => __('Bounce In Right','prime-industry'),
        'wow bounceInUp' => __('Bounce In Up','prime-industry'),
        'wow bounceInDown' => __('Bounce In Down','prime-industry'),
        'wow zoomIn' => __('Zoom In','prime-industry'),
        'wow zoomOut' => __('Zoom Out','prime-industry'),
        'wow fadeInDown' => __('Fade In Down','prime-industry'),            
        'wow fadeInUp' => __('Fade In Up','prime-industry'),
        'wow fadeInLeft' => __('Fade In Left','prime-industry'),
        'wow fadeInRight' => __('Fade In Right','prime-industry'),
        'flip-up' => __('Flip Up','prime-industry')
    ),
    'section' => 'featured_slider_info_section',
)); 

 $wp_customize->add_setting('theme_options[featured_slider_section_heading]', 
        array(
        'default'           => $default['featured_slider_section_heading'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control('theme_options[featured_slider_section_heading]', 
        array(
        'label'       => __('Slider Heading', 'prime-industry'),
        'section'     => 'featured_slider_info_section',   
        'settings'    => 'theme_options[featured_slider_section_heading]',				
        'type'        => 'text'
        )
    );

// Items
// Number of Slider Items
$wp_customize->add_setting('number_of_featured_slider_items', array(
    'default'           => 3, // Set default number of items
    'sanitize_callback' => 'absint', // Ensure it's a valid integer
));

$wp_customize->add_control('number_of_featured_slider_items', array(
    'label'    => __('Number Of Slider To Show', 'prime-industry'),
    'section'  => 'featured_slider_info_section', // The section where this control will appear
    'type'     => 'number',
    'input_attrs' => array(
        'min' => 1, // Minimum value
        'max' => 10, // Maximum value
        'step' => 1, // Increment step
    ),
));

$prime_industry_slider_list = array();
$args = array('post_type' => 'post'); // Fetch posts, not pages
$prime_industry_posts = get_posts( $args ); 
foreach($prime_industry_posts as $prime_industry_post) {
    $prime_industry_slider_list[$prime_industry_post->ID] = $prime_industry_post->post_title; // Use post ID as key and title as value
}

for ( $count = 1; $count <= 4; $count++ ) {
    $wp_customize->add_setting( 'select_post_slider' . $count, array(
        'default'           => '',
        'sanitize_callback' => 'prime_industry_sanitize_post_dropdown'
    ));
    $wp_customize->add_control( 'select_post_slider' . $count, array(
        'label'   => __( 'Select A Post Page', 'prime-industry' ),
        'section' => 'featured_slider_info_section',
        'type'    => 'select', // Use 'select' for custom post list
        'choices' => $prime_industry_slider_list // Populate choices with posts
    ));
}

// $wp_customize->add_setting('prime_industry_button1_text', 
//     array(
//     'default'           => __('PROJECTS', 'prime-industry'),
//     'type'              => 'theme_mod',
//     'capability'        => 'edit_theme_options',    
//     'sanitize_callback' => 'sanitize_text_field'
//     )
// );

// $wp_customize->add_control('prime_industry_button1_text', 
//     array(
//     'label'       => __('Read More Button Text', 'prime-industry'),
//     'section'     => 'featured_slider_info_section',   
//     'settings'    => 'prime_industry_button1_text',           
//     'type'        => 'text'
//     )
// );

$wp_customize->add_setting('prime_industry_button2_text', 
    array(
    'default'           => __('Contact Us', 'prime-industry'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control('prime_industry_button2_text', 
    array(
    'label'       => __('Contact Button Text', 'prime-industry'),
    'section'     => 'featured_slider_info_section',   
    'settings'    => 'prime_industry_button2_text',       
    'type'        => 'text'
    )
);

/** Slider Color section */

$wp_customize->add_section(
    'slider_text_colors_section',
    array(
        'title'    => __( 'Colors', 'prime-industry' ),        
        'priority' => 2,
        'panel'      => 'prime_industry_section_panel',  
    )
);

   // ///////// Title Text Color
    $wp_customize->add_setting('slider_title_color', array(
    'default'   => '#fff',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_title_color', array(
    'section' => 'slider_text_colors_section',
    'description' => __('Title Color', 'prime-industry'),
    )));

  // ///////// Paragraph Text Color
  $wp_customize->add_setting('slider_subtitle_color', array(
    'default'   => '#ffffff',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_subtitle_color', array(
    'section' => 'slider_text_colors_section',
    'description' => __('Paragraph Color', 'prime-industry'),
    )));

     // ///////// Slick Dot Color
  $wp_customize->add_setting('slider_slickdot_color', array(
    'default'   => '#ffffff',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_slickdot_color', array(
    'section' => 'slider_text_colors_section',
    'description' => __('Slider Dot Color', 'prime-industry'),
    )));

     // ///////// Active Slick Dot Color
  $wp_customize->add_setting('slider_activeslickdot_color', array(
    'default'   => '#4d617a',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_activeslickdot_color', array(
    'section' => 'slider_text_colors_section',
    'description' => __('Active Slider Dot Color', 'prime-industry'),
    )));

/////////////////////Button Color///////////////////////
    $wp_customize->add_setting('slider_buttontext1_color', array(
        'default'   => '#000',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
        ));
      
        $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_buttontext1_color', array(
        'section' => 'slider_text_colors_section',
        'description' => __('Read More Button Color', 'prime-industry'),
        )));

        $wp_customize->add_setting('slider_buttonbg1_color', array(
            'default'   => '#fff',
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
            ));
          
            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_buttonbg1_color', array(
            'section' => 'slider_text_colors_section',
            'description' => __('Read More Button Background Color', 'prime-industry'),
            )));

        $wp_customize->add_setting('slider_buttontext2_color', array(
            'default'   => '#fff',
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
            ));
          
            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_buttontext2_color', array(
            'section' => 'slider_text_colors_section',
            'description' => __('Contact Button Color', 'prime-industry'),
            )));

            $wp_customize->add_setting('slider_buttonbg2_color', array(
                'default'   => '#eb4438',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color',
                ));
              
                $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_buttonbg2_color', array(
                'section' => 'slider_text_colors_section',
                'description' => __('Contact Background Color', 'prime-industry'),
                )));
    
    // ----------------------------------------------------------

    /** Slider Structure section */

	$wp_customize->add_section(
	    'slider_structure_section',
	    array(
	        'title'    => __( 'Structure', 'prime-industry' ),        
	        'priority' => 3,
	        'panel'      => 'prime_industry_section_panel',  
	    )
	);

	$wp_customize->add_setting('featured_slider_title_case',array(
        'default' => 'Uppercase',
        'sanitize_callback' => 'prime_industry_sanitize_choices',
    ));
    $wp_customize->add_control('featured_slider_title_case',array(
        'type' => 'select',
        'label' => __('Title Case','prime-industry'),
        'choices' => array (
            'Uppercase' => __('Uppercase','prime-industry'),
            'Lowercase' => __('Lowercase','prime-industry'),
            'Capitalize' => __('Capitalize','prime-industry'),
            'None' => __('None','prime-industry')
        ),
        'section' => 'slider_structure_section',
    ));

    $wp_customize->add_setting('featured_slider_subtitle_case',array(
        'default' => 'Capitalize',
        'sanitize_callback' => 'prime_industry_sanitize_choices',
    ));
    $wp_customize->add_control('featured_slider_subtitle_case',array(
        'type' => 'select',
        'label' => __('Sub Title Case','prime-industry'),
        'choices' => array (
            'Uppercase' => __('Uppercase','prime-industry'),
            'Lowercase' => __('Lowercase','prime-industry'),
            'Capitalize' => __('Capitalize','prime-industry'),
            'None' => __('None','prime-industry')
        ),
        'section' => 'slider_structure_section',
    ));