<?php
/**
 * Features Section options.
 *
 * @package prime industry
 */
$default = prime_industry_get_default_theme_options();

$wp_customize->add_section( 'featured_feature_info_section', array(
    'title'    => __( 'Facility Info', 'prime-industry' ),
    'priority' => 2,
    'panel'    => 'prime_industry_section_panel',
) );

// Enable toggle for section visibility
$wp_customize->add_setting( 'enable_featured_features_section', array(
    'default'           => true,
    'sanitize_callback' => 'prime_industry_sanitize_switch',
) );

$wp_customize->add_control( new prime_industry_Toggle_Checkbox_Custom_control(
    $wp_customize,
    'enable_featured_features_section',
    array(
        'settings'     => 'enable_featured_features_section',
        'section'      => 'featured_feature_info_section',
        'label'        => __( 'Enable Section', 'prime-industry' ),
        'on_off_label' => array(
            'on'  => __( 'Yes', 'prime-industry' ),
            'off' => __( 'No', 'prime-industry' ),
        ),
    )
) );

// Section Sub Text
$wp_customize->add_setting('theme_options[featured_features_title1]', 
	array(
	'default'           => 'Buildings',
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_features_title1]', 
	array(
	'label'       => __('Title', 'prime-industry'),
	'section'     => 'featured_feature_info_section',   
	'settings'    => 'theme_options[featured_features_title1]',		
	'type'        => 'text'
	)
);
$wp_customize->add_setting('theme_options[featured_features_text1]', 
	array(
	'default'           => "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or",
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_features_text1]', 
	array(
	'label'       => __('Text', 'prime-industry'),
	'section'     => 'featured_feature_info_section',   
	'settings'    => 'theme_options[featured_features_text1]',		
	'type'        => 'text'
	)
);
  // Icon
    $wp_customize->add_setting('theme_options[featured_icon_features1]', 
        array(
        'default'           => 'fas fa-user-graduate',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control('theme_options[featured_icon_features1]', 
        array(
        'label'       		=> __('Icon', 'prime-industry'),
        'section'     		=> 'featured_feature_info_section',   
        'settings'    		=> 'theme_options[featured_icon_features1]',			
        'type'        		=> 'text',
        )
    );


    $wp_customize->add_setting('theme_options[featured_features_title2]', 
	array(
	'default'           => 'Civil Infrastructure',
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_features_title2]', 
	array(
	'label'       => __('Title', 'prime-industry'),
	'section'     => 'featured_feature_info_section',   
	'settings'    => 'theme_options[featured_features_title2]',		
	'type'        => 'text'
	)
);
$wp_customize->add_setting('theme_options[featured_features_text2]', 
	array(
	'default'           => "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or",
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_features_text2]', 
	array(
	'label'       => __('Text', 'prime-industry'),
	'section'     => 'featured_feature_info_section',   
	'settings'    => 'theme_options[featured_features_text2]',		
	'type'        => 'text'
	)
);
  // Icon
    $wp_customize->add_setting('theme_options[featured_icon_features2]', 
        array(
        'default'           => 'fas fas fa-city',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control('theme_options[featured_icon_features2]', 
        array(
        'label'       		=> __('Icon', 'prime-industry'),
        'section'     		=> 'featured_feature_info_section',   
        'settings'    		=> 'theme_options[featured_icon_features2]',			
        'type'        		=> 'text',
        )
    );

       $wp_customize->add_setting('theme_options[featured_features_title3]', 
	array(
	'default'           => 'Multipurpose',
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_features_title3]', 
	array(
	'label'       => __('Title', 'prime-industry'),
	'section'     => 'featured_feature_info_section',   
	'settings'    => 'theme_options[featured_features_title3]',		
	'type'        => 'text'
	)
);
$wp_customize->add_setting('theme_options[featured_features_text3]', 
	array(
	'default'           => "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or",
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_features_text3]', 
	array(
	'label'       => __('Text', 'prime-industry'),
	'section'     => 'featured_feature_info_section',   
	'settings'    => 'theme_options[featured_features_text3]',		
	'type'        => 'text'
	)
);
  // Icon
    $wp_customize->add_setting('theme_options[featured_icon_features3]', 
        array(
        'default'           => 'fas fa-user-graduate',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control('theme_options[featured_icon_features3]', 
        array(
        'label'       		=> __('Icon', 'prime-industry'),
        'section'     		=> 'featured_feature_info_section',   
        'settings'    		=> 'theme_options[featured_icon_features3]',			
        'type'        		=> 'text',
        )
    );
// Feature Items (Flat keys)
// for ( $i = 1; $i <= 3; $i++ ) {
//     // Title
//     $wp_customize->add_setting( "featured_features_title_$i", array(
//         'type'              => 'theme_mod',
//         'sanitize_callback' => 'sanitize_text_field',
//     ) );
//     $wp_customize->add_control( "featured_features_title_$i", array(
//         'label'   => sprintf( __( 'Feature Title %d', 'prime-industry' ), $i ),
//         'section' => 'featured_feature_info_section',
//         'type'    => 'text',
//     ) );

//     // Description
//     $wp_customize->add_setting( "featured_features_text_$i", array(
//         'type'              => 'theme_mod',
//         'sanitize_callback' => 'sanitize_text_field',
//     ) );
//     $wp_customize->add_control( "featured_features_text_$i", array(
//         'label'   => sprintf( __( 'Feature Description %d', 'prime-industry' ), $i ),
//         'section' => 'featured_feature_info_section',
//         'type'    => 'text',
//     ) );

//     // Icon
//     $wp_customize->add_setting( "featured_icon_features_$i", array(
//         'type'              => 'theme_mod',
//         'sanitize_callback' => 'sanitize_text_field',
//     ) );
//     $wp_customize->add_control( "featured_icon_features_$i", array(
//         'label'       => sprintf( __( 'Feature Icon Class %d', 'prime-industry' ), $i ),
//         'section'     => 'featured_feature_info_section',
//         'type'        => 'text',
//         'description' => __( 'Example: fa fa-star', 'prime-industry' ),
//     ) );
// }
