<?php
/**
 * About Section options.
 *
 * @package prime-industry  
 */

$default = prime_industry_get_default_theme_options();

/** About Info section */
$wp_customize->add_section(
    'featured_about_info_section',
    array(
        'title'    => __( 'About Info', 'prime-industry' ),      
        'priority' => 1,
        'panel'      => 'prime_industry_section_panel',       	
    )
);

// Enable Section
$wp_customize->add_setting(
    'feature_about_enable_section',
    array(
        'default' 			=> true,
       'sanitize_callback' => 'prime_industry_sanitize_switch',

    )
);
$wp_customize->add_control(
    new prime_industry_Toggle_Checkbox_Custom_control(
        $wp_customize,
        'feature_about_enable_section',
        array(
            'settings'      => 'feature_about_enable_section',
            'section'       => 'featured_about_info_section',
            'label'         => __( 'Enable Section', 'prime-industry' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'prime-industry' ),
                'off' => __( 'No', 'prime-industry' )
            ),
        )
    )
);
    $wp_customize->add_setting('prime_industry_featured_about_onload_effects',array(
        'default' => 'zoom-in',
        'sanitize_callback' => 'prime_industry_sanitize_choices',
    ));
    $wp_customize->add_control('prime_industry_featured_about_onload_effects',array(
        'type' => 'select',
        'label' => __('Box Onload Transition Effects','prime-industry'),
        'choices' => array (
            'wow bounceInLeft' => __('Bounce In Left','prime-industry'),
            'wow bounceInRight' => __('Bounce In Right','prime-industry'),
            'wow bounceInUp' => __('Bounce In Up','prime-industry'),
            'wow bounceInDown' => __('Bounce In Down','prime-industry'),
            'wow zoomIn' => __('Zoom In','prime-industry'),
            'wow zoomOut' => __('Zoom Out','prime-industry'),
            'wow fadeInDown' => __('Fade In Down','prime-industry'),            
            'wow fadeInUp' => __('Fade In Up','prime-industry'),
            'wow fadeInLeft' => __('Fade In Left','prime-industry'),
            'wow fadeInRight' => __('Fade In Right','prime-industry'),
            'flip-up' => __('Flip Up','prime-industry')
        ),
        'section' => 'featured_about_info_section',
    ));

// Section main  Title
$wp_customize->add_setting('theme_options[featured_about_section_maintitle]', 
	array(
	'default'           => $default['featured_about_section_maintitle'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_maintitle]', 
	array(
	'label'       => __('Heading', 'prime-industry'),
	'section'     => 'featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_maintitle]',		
	'type'        => 'text'
	)
);
// Section Title
$wp_customize->add_setting('theme_options[featured_about_section_title]', 
	array(
	'default'           => $default['featured_about_section_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_title]', 
	array(
	'label'       => __('Sub Heading', 'prime-industry'),
	'section'     => 'featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_title]',		
	'type'        => 'text'
	)
);


// Section Sub Text
$wp_customize->add_setting('theme_options[featured_about_section_text]', 
	array(
	'default'           => $default['featured_about_section_text'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_text]', 
	array(
	'label'       => __('Text', 'prime-industry'),
	'section'     => 'featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_text]',				
	'type'        => 'text'
	)
);


    $wp_customize->add_setting( 'prime_industry_about_featureimage1', array(  
        'sanitize_callback' => 'prime_industry_sanitise_custom_url'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'prime_industry_about_featureimage1', array(
        'label' => __('Feature Image 1','prime-industry'),
        // 'description'   => __( 'Size 704px x 900x', 'prime-industry' ),
        'section' => 'featured_about_info_section',
        'settings'   => 'prime_industry_about_featureimage1',
    )));

   // Section Sub Title
        $wp_customize->add_setting('theme_options[featured_about_section_bxtitle1]', 
        array(
        'default'           => $default['featured_about_section_bxtitle1'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
        )
    );
        $wp_customize->add_control('theme_options[featured_about_section_bxtitle1]', 
        array(
        'label'       => __('Plan Title 1', 'prime-industry'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_section_bxtitle1]',				
        'type'        => 'text'
        )
    );

    // Section Sub Text
//     $wp_customize->add_setting('theme_options[featured_about_section_bxtext1]', 
//        array(
//        'default'           => $default['featured_about_section_bxtext1'],
//        'type'              => 'theme_mod',
//        'capability'        => 'edit_theme_options',	
//        'sanitize_callback' => 'sanitize_text_field'
//        )
//    );
//        $wp_customize->add_control('theme_options[featured_about_section_bxtext1]', 
//        array(
//        'label'       => __('Plan Text 1', 'prime-industry'),
//        'section'     => 'featured_about_info_section',   
//        'settings'    => 'theme_options[featured_about_section_bxtext1]',				
//        'type'        => 'text'
//        )
//    );


    
   $wp_customize->add_setting( 'prime_industry_about_featureimage2', array(  
        'sanitize_callback' => 'prime_industry_sanitise_custom_url'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'prime_industry_about_featureimage2', array(
        'label' => __('Feature Image 2','prime-industry'),
        // 'description'   => __( 'Size 704px x 900x', 'prime-industry' ),
        'section' => 'featured_about_info_section',
        'settings'   => 'prime_industry_about_featureimage2',
    )));

    // Section Sub Title
    $wp_customize->add_setting('theme_options[featured_about_section_bxtitle2]', 
       array(
       'default'           => $default['featured_about_section_bxtitle2'],
       'type'              => 'theme_mod',
       'capability'        => 'edit_theme_options',	
       'sanitize_callback' => 'sanitize_text_field'
       )
   );
       $wp_customize->add_control('theme_options[featured_about_section_bxtitle2]', 
       array(
       'label'       => __('Plan Title 2', 'prime-industry'),
       'section'     => 'featured_about_info_section',   
       'settings'    => 'theme_options[featured_about_section_bxtitle2]',				
       'type'        => 'text'
       )
   );

// Section img Text 1
// $wp_customize->add_setting('theme_options[featured_about_section_imagetitle1]', 
// 	array(
// 	'default'           => $default['featured_about_section_imagetitle1'],
// 	'type'              => 'theme_mod',
// 	'capability'        => 'edit_theme_options',	
// 	'sanitize_callback' => 'sanitize_text_field'
// 	)
// );
// $wp_customize->add_control('theme_options[featured_about_section_imagetitle1]', 
// 	array(
// 	'label'       => __('Image Upper Text', 'prime-industry'),
// 	'section'     => 'featured_about_info_section',   
// 	'settings'    => 'theme_options[featured_about_section_imagetitle1]',				
// 	'type'        => 'text'
// 	)
// );

// Section img Text 1
// $wp_customize->add_setting('theme_options[featured_about_section_imagetitle2]', 
// 	array(
// 	'default'           => $default['featured_about_section_imagetitle2'],
// 	'type'              => 'theme_mod',
// 	'capability'        => 'edit_theme_options',	
// 	'sanitize_callback' => 'sanitize_text_field'
// 	)
// );
// $wp_customize->add_control('theme_options[featured_about_section_imagetitle2]', 
// 	array(
// 	'label'       => __('Image Below Text', 'prime-industry'),
// 	'section'     => 'featured_about_info_section',   
// 	'settings'    => 'theme_options[featured_about_section_imagetitle2]',				
// 	'type'        => 'text'
// 	)
// );



$wp_customize->add_setting('prime_industry_about_numberofplan',array(
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('prime_industry_about_numberofplan',array(
    'label' => __('Number Of Plan To Show','prime-industry'),
    'section' => 'featured_about_info_section'
));





    // Section Sub Text
//     $wp_customize->add_setting('theme_options[featured_about_section_bxtext2]', 
//        array(
//        'default'           => $default['featured_about_section_bxtext2'],
//        'type'              => 'theme_mod',
//        'capability'        => 'edit_theme_options',	
//        'sanitize_callback' => 'sanitize_text_field'
//        )
//    );
//        $wp_customize->add_control('theme_options[featured_about_section_bxtext2]', 
//        array(
//        'label'       => __('Plan Title 2', 'prime-industry'),
//        'section'     => 'featured_about_info_section',   
//        'settings'    => 'theme_options[featured_about_section_bxtext2]',				
//        'type'        => 'text'
//        )
//    );

    // Icon
    $wp_customize->add_setting('theme_options[featured_iconabout1]', 
        array(
        'default'           => $default['featured_iconabout1'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control('theme_options[featured_iconabout1]', 
        array(
        'label'       		=> __('Plan Icon 1', 'prime-industry'),
        'section'     		=> 'featured_about_info_section',   
        'settings'    		=> 'theme_options[featured_iconabout1]',			
        'type'        		=> 'text',
        )
    );

    // Section Features
    $wp_customize->add_setting('theme_options[featured_about_section_features1]', 
        array(
        'default'           => $default['featured_about_section_features1'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control('theme_options[featured_about_section_features1]', 
        array(
        'label'       => __('Facility Title 1', 'prime-industry'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_section_features1]',				
        'type'        => 'text'
        )
    );

            // Icon
$wp_customize->add_setting('theme_options[featured_iconabout2]', 
     array(
     'default'           => $default['featured_iconabout2'],
     'type'              => 'theme_mod',
     'capability'        => 'edit_theme_options',	
     'sanitize_callback' => 'sanitize_text_field'
     )
 );
 $wp_customize->add_control('theme_options[featured_iconabout2]', 
     array(
     'label'       		=> __('Plan Icon 2', 'prime-industry'),
     'section'     		=> 'featured_about_info_section',   
     'settings'    		=> 'theme_options[featured_iconabout2]',				
     'type'        		=> 'text',
     )
 );

    $wp_customize->add_setting('theme_options[featured_about_section_features2]', 
        array(
        'default'           => $default['featured_about_section_features2'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control('theme_options[featured_about_section_features2]', 
        array(
        'label'       => __('Facility Title 2', 'prime-industry'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_section_features2]',				
        'type'        => 'text'
        )
    );

      $wp_customize->add_setting('theme_options[featured_iconabout3]', 
        array(
        'default'           => $default['featured_iconabout3'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control('theme_options[featured_iconabout3]', 
        array(
        'label'       		=> __('Plan Icon 1', 'prime-industry'),
        'section'     		=> 'featured_about_info_section',   
        'settings'    		=> 'theme_options[featured_iconabout3]',			
        'type'        		=> 'text',
        )
    );

    $wp_customize->add_setting('theme_options[featured_about_section_features3]', 
        array(
        'default'           => $default['featured_about_section_features3'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control('theme_options[featured_about_section_features3]', 
        array(
        'label'       => __('Facility Title 3', 'prime-industry'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_section_features3]',				
        'type'        => 'text'
        )
    );


    $wp_customize->add_setting('theme_options[featured_about_section_buttontext]', 
        array(
        'default'           => $default['featured_about_section_buttontext'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control('theme_options[featured_about_section_buttontext]', 
        array(
        'label'       => __('Button Text', 'prime-industry'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_section_buttontext]',				
        'type'        => 'text'
        )
    );

  

// saprator
    $wp_customize->add_setting('prime_industry_about_leftheading',array(
       'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('prime_industry_about_leftheading',array(
        'label' => __('Left Side Image','prime-industry'),
        'section' => 'featured_about_info_section'
    ));

// main about image 1
    $wp_customize->add_setting( 'prime_industry_about_image1', array(  
        'sanitize_callback' => 'prime_industry_sanitise_custom_url'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'prime_industry_about_image1', array(
        'label' => __('About Image 1','prime-industry'),
        'description'   => __( 'Size 704px x 900x', 'prime-industry' ),
        'section' => 'featured_about_info_section',
        'settings'   => 'prime_industry_about_image1',
    )));

    // main about image 2
    $wp_customize->add_setting( 'prime_industry_about_image2', array(  
        'sanitize_callback' => 'prime_industry_sanitise_custom_url'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'prime_industry_about_image2', array(
        'label' => __('About Image 2','prime-industry'),
        'description'   => __( 'Size 704px x 900x', 'prime-industry' ),
        'section' => 'featured_about_info_section',
        'settings'   => 'prime_industry_about_image2',
    )));

$wp_customize->add_setting('prime_industry_bann2_vb_embade', array(
    'default' => 'Add your video embade code',
    'sanitize_callback' => 'prime_industry_sanitize_iframe',
));

$wp_customize->add_control('prime_industry_bann2_vb_embade', array(
    'settings' => 'prime_industry_bann2_vb_embade',
    'section'  => 'featured_about_info_section',
    'type'     => 'textarea',
    'label'    => __('Iframe Code For Video', 'prime-industry'),
));

    

/*********** About Colors Section *************/

// $wp_customize->add_section(
//     'featured_about_info_section',
//     array(
//         'title'    => __( 'Colors', 'prime-industry' ),        
//         'priority' => 2,
//         'panel'      => 'prime_industry_aboutsec_panel4',  
//     )
// );

// saprator
$wp_customize->add_setting('prime_industry_about_leftheading',array(
    'sanitize_callback' => 'sanitize_text_field'
 ));
 $wp_customize->add_control('prime_industry_about_leftheading',array(
     'label' => __('Color Section','prime-industry'),
     'section' => 'featured_about_info_section'
 ));


/** Colors control */     

    $wp_customize->add_setting('about_bx1icn_clr', 
        array(
        'default'     => "#EB4438",
        'transport'   => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize,'about_bx1icn_clr', 
        array(
        'label'       => __('Plan Icon Color', 'prime-industry'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'about_bx1icn_clr',  
        
        )
    ));         

    $wp_customize->add_setting('about_button_bgclr', 
        array(
        'default'     => "#eb4438",
        'transport'   => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color', 
        )
    );
    $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize,'about_button_bgclr', 
        array(
        'label'       => __('Button BG Color', 'prime-industry'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'about_button_bgclr', 
        
        )
    )); 

    $wp_customize->add_setting('about_button_textclr', 
        array(
        'default'     => "#FFFFFF",
        'transport'   => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize,'about_button_textclr', 
        array(
        'label'       => __('Button Text Color', 'prime-industry'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'about_button_textclr',  
        
        )
    )); 

    $wp_customize->add_setting('about_image_upper_textclr', 
        array(
        'default'     => "#272727",
        'transport'   => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize,'about_image_upper_textclr', 
        array(
        'label'       => __('Image Upper Text Color', 'prime-industry'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'about_image_upper_textclr',  
        
        )
    )); 

    $wp_customize->add_setting('about_image_below_textclr', 
        array(
        'default'     => "#fff",
        'transport'   => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize,'about_image_below_textclr', 
        array(
        'label'       => __('Image Below Text Color', 'prime-industry'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'about_image_below_textclr',  
        
        )
    )); 

