<?php
/**
 * Default theme options.
 *
 * @package prime-industry  
 */

if (!function_exists('prime_industry_get_default_theme_options')):

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
	function prime_industry_get_default_theme_options()
	{

		$defaults = array();


		// Front Page Content
		$defaults['enable_frontpage_content'] = true;

		// Slider Section	
		$defaults['enable_featured_slider_section'] = true;
		//$defaults['show_slider_colors']		    			= false;	
		$defaults['featured_slider_content_type'] = 'featured_slider_page';
		$defaults['featured_slider_category_readmore_text'] = esc_html__('Read More', 'prime-industry');
		$defaults['data_slick_speed'] = 1000;
		$defaults['data_slick_infinite'] = 1;
		$defaults['data_slick_dots'] = 1;
		$defaults['data_slick_autoplay'] = 1;
		$defaults['data_slick_draggable'] = 1;
		$defaults['data_slick_fade'] = 1;
		$defaults['number_of_featured_slider_items'] = 6;

		// About Section	
		$defaults['enable_featured_about_section'] = true;

		$defaults['about_image_show'] = true;
		$defaults['featured_about_section_maintitle'] = esc_html__('About Us', 'prime-industry');
		$defaults['featured_about_section_title'] = esc_html__('We Help To Build Your Dream', 'prime-industry');
		$defaults['featured_about_section_imagetitle1'] = esc_html__('SINCE', 'prime-industry');
		$defaults['featured_about_section_text'] = esc_html__("Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took", 'prime-industry');
		$defaults['featured_about_section_imagetitle2'] = esc_html__('1999', 'prime-industry');
		$defaults['featured_about_section_bxtitle1'] = esc_html__('Best Materials', 'prime-industry');
		$defaults['featured_about_section_bxtext1'] = esc_html__('Donec eget porttitor odio', 'prime-industry');
		$defaults['featured_about_section_bxtitle2'] = esc_html__('Best Materials', 'prime-industry');
		$defaults['featured_about_section_bxtext2'] = esc_html__('Etiam finibus sapien.', 'prime-industry');
		$defaults['featured_iconabout1'] = esc_html__('fas fa-genderless', 'prime-industry');
		$defaults['featured_iconabout2'] = esc_html__('fas fa-genderless', 'prime-industry');
		$defaults['featured_iconabout3'] = esc_html__('fas fa-genderless', 'prime-industry');
		$defaults['featured_about_section_features1'] = esc_html__('Lorem Ipsum is simply dummy text', 'prime-industry');
		$defaults['featured_about_section_features2'] = esc_html__('Lorem Ipsum is simply dummy text of the printing.', 'prime-industry');
		$defaults['featured_about_section_features3'] = esc_html__('Lorem Ipsum text of the printing.', 'prime-industry');
		$defaults['featured_slider_section_heading'] = esc_html__('YOUR VISION. OUR MISSION.', 'prime-industry');

		$defaults['featured_about_section_buttontext'] = esc_html__('Read More', 'prime-industry');
		$defaults['featured_iconbutnicn'] = esc_html__('fas fa-arrow-up', 'prime-industry');
		// Pass through filter.
		$defaults = apply_filters('prime_industry_filter_default_theme_options', $defaults);
		return $defaults;

		// features section
		$defaults['enable_featured_features_section'] = true;

	// $defaults['featured_features_title1'] = esc_html__('Buildings', 'prime-industry');
	// $defaults['featured_features_text1'] = esc_html__("There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or", 'prime-industry');
	// $defaults['featured_icon_features1'] = esc_html__('fas fa-user-graduate', 'prime-industry');

	// $defaults['featured_features_title2'] = esc_html__('Civil Infrastructure', 'prime-industry');
	// $defaults['featured_features_text2'] = esc_html__("There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or", 'prime-industry');
	// $defaults['featured_icon_features2'] = esc_html__('fas fa-city', 'prime-industry');
	
	// $defaults['featured_features_title3'] = esc_html__('Multipurpose', 'prime-industry');
	// $defaults['featured_features_text3'] = esc_html__("There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or", 'prime-industry');
	// $defaults['featured_icon_features3'] = esc_html__('fas fa-hourglass-start', 'prime-industry');


		// Inner Blog Page	
		$defaults['featured_bloginn_botton_text'] = esc_html__('Read More', 'prime-industry');

	}

endif;

/**
 *  Get theme options
 */
if (!function_exists('prime_industry_get_option')):

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function prime_industry_get_option($key)
	{

		$default_options = prime_industry_get_default_theme_options();
		if (empty($key)) {
			return;
		}

		$theme_options = (array) get_theme_mod('theme_options');
		$theme_options = wp_parse_args($theme_options, $default_options);

		$value = null;

		if (isset($theme_options[$key])) {
			$value = $theme_options[$key];
		}

		return $value;

	}

endif;