<?php
/**
 * Active callback functions.
 *
 * @package prime-industry
 */

function prime_industry_featured_slider_active( $control ) {
    if( $control->manager->get_setting( 'slider_enable_section' )->value() == true ) {
        return true;
    }else{
        return false;
    }
}

function prime_industry_featured_services_page( $control ) {
    $content_type = $control->manager->get_setting( 'theme_options[featured_services_content_type]' )->value();
    return ( prime_industry_featured_services_active( $control ) && ( 'featured_services_page' == $content_type ) );
}

function prime_industry_featured_slider_page( $control ) {
    $content_type = $control->manager->get_setting( 'theme_options[featured_slider_content_type]' )->value();
    return ( prime_industry_featured_slider_active( $control ) && ( 'featured_slider_page' == $content_type ) );
}

//  What We Offer
function prime_industry_featured_whatweoffer_active( $control ) {
    if( $control->manager->get_setting( 'whatweoffer_enable_section' )->value() == true ) {
        return true;
    }else{
        return false;
    }
}
function prime_industry_featured_whatweoffer_page( $control ) {
    $content_type = $control->manager->get_setting( 'theme_options[featured_whatweoffer_content_type]' )->value();
    return ( prime_industry_featured_whatweoffer_active( $control ) && ( 'featured_whatweoffer_page' == $content_type ) );
}


/**
 * Active Callback for top bar section
 */
function prime_industry_contact_info_ac( $control ) {

    $show_contact_info = $control->manager->get_setting( 'theme_options[show_header_contact_info]')->value();
    $control_id        = $control->id;
         
    if ( $control_id == 'theme_options[header_location]' && $show_contact_info ) return true;
    if ( $control_id == 'theme_options[header_email]' && $show_contact_info ) return true;
    if ( $control_id == 'theme_options[header_phone]' && $show_contact_info ) return true;
    if ( $control_id == 'theme_options[hphone_text]' && $show_contact_info ) return true;

    return false;
}

function prime_industry_social_links_active( $control ) {
    if( $control->manager->get_setting( 'theme_options[show_header_social_links]' )->value() == true ) {
        return true;
    }else{
        return false;
    }
}